/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.creator;

import java.lang.invoke.MethodHandle;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.creator.ObjectCreator;
import org.dromara.hutool.core.reflect.lookup.LookupUtil;
import org.dromara.hutool.core.reflect.method.MethodHandleUtil;

public class DefaultObjectCreator<T>
implements ObjectCreator<T> {
    final MethodHandle constructor;
    final Object[] params;

    public static <T> DefaultObjectCreator<T> of(String fullClassName) {
        return DefaultObjectCreator.of(ClassLoaderUtil.loadClass(fullClassName), new Object[0]);
    }

    public static <T> DefaultObjectCreator<T> of(Class<T> clazz, Object ... params) {
        return new DefaultObjectCreator<T>(clazz, params);
    }

    public DefaultObjectCreator(Class<T> clazz, Object ... params) {
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        this.constructor = LookupUtil.findConstructor(clazz, paramTypes);
        Assert.notNull(this.constructor, "Constructor not found!", new Object[0]);
        this.params = params;
    }

    @Override
    public T create() {
        return MethodHandleUtil.invokeHandle(this.constructor, this.params);
    }
}

