/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.dromara.hutool.core.map.FuncKeyMap;
import org.dromara.hutool.core.map.MapBuilder;
import org.dromara.hutool.core.text.StrUtil;

public class CamelCaseMap<K, V>
extends FuncKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        this(MapBuilder.of(new HashMap(initialCapacity, loadFactor)));
    }

    CamelCaseMap(MapBuilder<K, V> emptyMapBuilder) {
        super(emptyMapBuilder.build(), (Function<Object, Object> & Serializable)key -> {
            if (key instanceof CharSequence) {
                key = StrUtil.toCamelCase(key.toString());
            }
            return key;
        });
    }
}

