/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.range;

import java.util.Objects;
import org.dromara.hutool.core.lang.range.Bound;
import org.dromara.hutool.core.lang.range.BoundType;
import org.dromara.hutool.core.lang.range.BoundedRange;
import org.dromara.hutool.core.lang.range.NoneLowerBound;
import org.dromara.hutool.core.lang.range.NoneUpperBound;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.core.util.ObjUtil;

class FiniteBound<T extends Comparable<? super T>>
implements Bound<T> {
    private final T value;
    private final BoundType type;

    FiniteBound(T value, BoundType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public BoundType getType() {
        return this.type;
    }

    @Override
    public boolean test(T t) {
        BoundType bt = this.getType();
        int compareValue = this.getValue().compareTo(t);
        if (compareValue == 0) {
            return bt.isClose();
        }
        return compareValue > 0 ? bt.isUpperBound() : bt.isLowerBound();
    }

    @Override
    public int compareTo(Bound<T> bound) {
        if (bound instanceof NoneLowerBound) {
            return 1;
        }
        if (bound instanceof NoneUpperBound) {
            return -1;
        }
        if (ObjUtil.notEquals(this.getValue(), bound.getValue())) {
            return this.getValue().compareTo(bound.getValue());
        }
        return this.compareIfSameBoundValue(bound);
    }

    @Override
    public String descBound() {
        BoundType bt = this.getType();
        return bt.isLowerBound() ? bt.getSymbol() + this.getValue() : this.getValue() + bt.getSymbol();
    }

    @Override
    public Bound<T> negate() {
        return new FiniteBound<T>(this.value, this.getType().negate());
    }

    @Override
    public BoundedRange<T> toRange() {
        return this.getType().isLowerBound() ? new BoundedRange(this, Bound.noneUpperBound()) : new BoundedRange(Bound.noneLowerBound(), this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiniteBound that = (FiniteBound)o;
        return this.value.equals(that.value) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    @Override
    public String toString() {
        return CharSequenceUtil.format("{x | x {} {}}", this.type.getOperator(), this.value);
    }

    private int compareIfSameBoundValue(Bound<T> bound) {
        BoundType bt2;
        BoundType bt1 = this.getType();
        if (bt1 == (bt2 = bound.getType())) {
            return 0;
        }
        if (bt1.isDislocated(bt2)) {
            return bt1.isLowerBound() ? 1 : -1;
        }
        return Integer.compare(bt1.getCode(), bt2.getCode());
    }
}

