/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.lang.EnumItem;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.util.EnumUtil;

public class EnumConverter
extends AbstractConverter
implements MatcherConverter {
    private static final long serialVersionUID = 1L;
    public static final EnumConverter INSTANCE = new EnumConverter();
    private static final WeakConcurrentMap<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new WeakConcurrentMap();

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return rawType.isEnum();
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, targetClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(targetClass, this.convertToStr(value));
        }
        if (null != enumValue) {
            return enumValue;
        }
        throw new ConvertException("Can not convert {} to {}", value, targetClass);
    }

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        EnumItem first;
        if (value == null) {
            return null;
        }
        if (EnumItem.class.isAssignableFrom(enumClass) && null != (first = (EnumItem)EnumUtil.getEnumAt(enumClass, 0))) {
            if (value instanceof Integer) {
                return (Enum)first.fromInt((Integer)value);
            }
            if (value instanceof String) {
                return (Enum)first.fromStr(value.toString());
            }
        }
        try {
            Map<Class<?>, Method> methodMap = EnumConverter.getMethodMap(enumClass);
            if (MapUtil.isNotEmpty(methodMap)) {
                Class<?> valueClass = value.getClass();
                for (Map.Entry<Class<?>, Method> entry : methodMap.entrySet()) {
                    if (!ClassUtil.isAssignable(entry.getKey(), valueClass)) continue;
                    return (Enum)MethodUtil.invokeStatic(entry.getValue(), value);
                }
            }
        }
        catch (Exception methodMap) {
            // empty catch block
        }
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumUtil.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getMethodMap(Class<?> enumClass) {
        return VALUE_OF_METHOD_CACHE.computeIfAbsent(enumClass, key -> Arrays.stream(enumClass.getMethods()).filter(ModifierUtil::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> !"valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (k1, k2) -> k1)));
    }
}

