/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.hash.metro;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dromara.hutool.core.codec.Number128;
import org.dromara.hutool.core.codec.hash.Hash128;
import org.dromara.hutool.core.codec.hash.metro.AbstractMetroHash;

public class MetroHash128
extends AbstractMetroHash<MetroHash128>
implements Hash128<byte[]> {
    private static final long K0 = 3359281633L;
    private static final long K1 = 2252921819L;
    private static final long K2 = 2078195771L;
    private static final long K3 = 794325157L;

    public static MetroHash128 of(long seed) {
        return new MetroHash128(seed);
    }

    public MetroHash128(long seed) {
        super(seed);
    }

    @Override
    public MetroHash128 reset() {
        this.v0 = (this.seed - 3359281633L) * 794325157L;
        this.v1 = (this.seed + 2252921819L) * 2078195771L;
        this.v2 = (this.seed + 3359281633L) * 2078195771L;
        this.v3 = (this.seed - 2252921819L) * 794325157L;
        this.nChunks = 0L;
        return this;
    }

    public Number128 get() {
        return new Number128(this.v0, this.v1);
    }

    @Override
    public Number128 hash128(byte[] bytes) {
        return ((MetroHash128)this.apply(ByteBuffer.wrap(bytes))).get();
    }

    @Override
    public MetroHash128 write(ByteBuffer output, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            MetroHash128.writeLittleEndian(this.v0, output);
            MetroHash128.writeLittleEndian(this.v1, output);
        } else {
            output.asLongBuffer().put(this.v1).put(this.v0);
        }
        return this;
    }

    @Override
    MetroHash128 partialApply32ByteChunk(ByteBuffer partialInput) {
        assert (partialInput.remaining() >= 32);
        this.v0 += MetroHash128.grab(partialInput, 8) * 3359281633L;
        this.v0 = Long.rotateRight(this.v0, 29) + this.v2;
        this.v1 += MetroHash128.grab(partialInput, 8) * 2252921819L;
        this.v1 = Long.rotateRight(this.v1, 29) + this.v3;
        this.v2 += MetroHash128.grab(partialInput, 8) * 2078195771L;
        this.v2 = Long.rotateRight(this.v2, 29) + this.v0;
        this.v3 += MetroHash128.grab(partialInput, 8) * 794325157L;
        this.v3 = Long.rotateRight(this.v3, 29) + this.v1;
        ++this.nChunks;
        return this;
    }

    @Override
    MetroHash128 partialApplyRemaining(ByteBuffer partialInput) {
        assert (partialInput.remaining() < 32);
        if (this.nChunks > 0L) {
            this.metroHash128_32();
        }
        if (partialInput.remaining() >= 16) {
            this.metroHash128_16(partialInput);
        }
        if (partialInput.remaining() >= 8) {
            this.metroHash128_8(partialInput);
        }
        if (partialInput.remaining() >= 4) {
            this.metroHash128_4(partialInput);
        }
        if (partialInput.remaining() >= 2) {
            this.metroHash128_2(partialInput);
        }
        if (partialInput.remaining() >= 1) {
            this.metroHash128_1(partialInput);
        }
        this.v0 += Long.rotateRight(this.v0 * 3359281633L + this.v1, 13);
        this.v1 += Long.rotateRight(this.v1 * 2252921819L + this.v0, 37);
        this.v0 += Long.rotateRight(this.v0 * 2078195771L + this.v1, 13);
        this.v1 += Long.rotateRight(this.v1 * 794325157L + this.v0, 37);
        return this;
    }

    private void metroHash128_32() {
        this.v2 ^= Long.rotateRight((this.v0 + this.v3) * 3359281633L + this.v1, 21) * 2252921819L;
        this.v3 ^= Long.rotateRight((this.v1 + this.v2) * 2252921819L + this.v0, 21) * 3359281633L;
        this.v0 ^= Long.rotateRight((this.v0 + this.v2) * 3359281633L + this.v3, 21) * 2252921819L;
        this.v1 ^= Long.rotateRight((this.v1 + this.v3) * 2252921819L + this.v2, 21) * 3359281633L;
    }

    private void metroHash128_16(ByteBuffer bb) {
        this.v0 += MetroHash128.grab(bb, 8) * 2078195771L;
        this.v0 = Long.rotateRight(this.v0, 33) * 794325157L;
        this.v1 += MetroHash128.grab(bb, 8) * 2078195771L;
        this.v1 = Long.rotateRight(this.v1, 33) * 794325157L;
        this.v0 ^= Long.rotateRight(this.v0 * 2078195771L + this.v1, 45) * 2252921819L;
        this.v1 ^= Long.rotateRight(this.v1 * 794325157L + this.v0, 45) * 3359281633L;
    }

    private void metroHash128_8(ByteBuffer bb) {
        this.v0 += MetroHash128.grab(bb, 8) * 2078195771L;
        this.v0 = Long.rotateRight(this.v0, 33) * 794325157L;
        this.v0 ^= Long.rotateRight(this.v0 * 2078195771L + this.v1, 27) * 2252921819L;
    }

    private void metroHash128_4(ByteBuffer bb) {
        this.v1 += MetroHash128.grab(bb, 4) * 2078195771L;
        this.v1 = Long.rotateRight(this.v1, 33) * 794325157L;
        this.v1 ^= Long.rotateRight(this.v1 * 794325157L + this.v0, 46) * 3359281633L;
    }

    private void metroHash128_2(ByteBuffer bb) {
        this.v0 += MetroHash128.grab(bb, 2) * 2078195771L;
        this.v0 = Long.rotateRight(this.v0, 33) * 794325157L;
        this.v0 ^= Long.rotateRight(this.v0 * 2078195771L + this.v1, 22) * 2252921819L;
    }

    private void metroHash128_1(ByteBuffer bb) {
        this.v1 += MetroHash128.grab(bb, 1) * 2078195771L;
        this.v1 = Long.rotateRight(this.v1, 33) * 794325157L;
        this.v1 ^= Long.rotateRight(this.v1 * 794325157L + this.v0, 58) * 3359281633L;
    }
}

