/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation.elements;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;

public class HierarchicalAnnotatedElements
implements AnnotatedElement,
Iterable<AnnotatedElement> {
    protected final BiFunction<Set<AnnotatedElement>, AnnotatedElement, AnnotatedElement> elementFactory;
    private volatile Set<AnnotatedElement> elementMappings;
    protected final AnnotatedElement source;

    public static HierarchicalAnnotatedElements of(AnnotatedElement element) {
        return HierarchicalAnnotatedElements.of(element, (es, e) -> e);
    }

    public static HierarchicalAnnotatedElements of(AnnotatedElement element, BiFunction<Set<AnnotatedElement>, AnnotatedElement, AnnotatedElement> elementFactory) {
        return element instanceof HierarchicalAnnotatedElements ? (HierarchicalAnnotatedElements)element : new HierarchicalAnnotatedElements(element, elementFactory);
    }

    HierarchicalAnnotatedElements(AnnotatedElement element, BiFunction<Set<AnnotatedElement>, AnnotatedElement, AnnotatedElement> elementFactory) {
        this.source = Objects.requireNonNull(element);
        this.elementMappings = null;
        this.elementFactory = Objects.requireNonNull(elementFactory);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getElementMappings().stream().anyMatch(element -> element.isAnnotationPresent(annotationType));
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.getElementMappings().stream().map(AnnotatedElement::getAnnotations).filter(ArrayUtil::isNotEmpty).flatMap(Stream::of).toArray(Annotation[]::new);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.getElementMappings().stream().map(e -> e.getAnnotation(annotationType)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return (Annotation[])this.getElementMappings().stream().map(e -> e.getAnnotationsByType(annotationType)).filter(ArrayUtil::isNotEmpty).flatMap(Stream::of).toArray(size -> (Annotation[])ArrayUtil.newArray(annotationType, size));
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.getElementMappings().stream().map(AnnotationUtil::getDeclaredAnnotations).filter(ArrayUtil::isNotEmpty).flatMap(Stream::of).toArray(Annotation[]::new);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.getElementMappings().stream().map(element -> element.getDeclaredAnnotation(annotationType)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationType) {
        return (Annotation[])this.getElementMappings().stream().map(element -> element.getDeclaredAnnotationsByType(annotationType)).filter(ArrayUtil::isNotEmpty).flatMap(Stream::of).toArray(size -> (Annotation[])ArrayUtil.newArray(annotationType, size));
    }

    @Override
    public Iterator<AnnotatedElement> iterator() {
        return this.getElementMappings().iterator();
    }

    public AnnotatedElement getElement() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalAnnotatedElements that = (HierarchicalAnnotatedElements)o;
        return this.elementFactory.equals(that.elementFactory) && this.source.equals(that.source);
    }

    public int hashCode() {
        return Objects.hash(this.elementFactory, this.source);
    }

    public final Set<AnnotatedElement> getElementMappings() {
        this.initElementMappingsIfNecessary();
        return this.elementMappings;
    }

    protected boolean isMatchMethod(Method source, Method target) {
        return CharSequenceUtil.equals(source.getName(), target.getName()) && !target.isBridge() && !target.isSynthetic() && ClassUtil.isAssignable(target.getReturnType(), source.getReturnType()) && Arrays.equals(source.getParameterTypes(), target.getParameterTypes());
    }

    private void collectElement(Set<AnnotatedElement> elements, AnnotatedElement element) {
        AnnotatedElement target = this.elementFactory.apply(elements, element);
        if (Objects.nonNull(target)) {
            elements.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initElementMappingsIfNecessary() {
        if (Objects.isNull(this.elementMappings)) {
            HierarchicalAnnotatedElements hierarchicalAnnotatedElements = this;
            synchronized (hierarchicalAnnotatedElements) {
                if (Objects.isNull(this.elementMappings)) {
                    Set<AnnotatedElement> mappings = this.initElementMappings();
                    this.elementMappings = SetUtil.view(mappings);
                }
            }
        }
    }

    private Set<AnnotatedElement> initElementMappings() {
        LinkedHashSet<AnnotatedElement> mappings = new LinkedHashSet<AnnotatedElement>();
        if (this.source instanceof Class) {
            this.scanHierarchy(mappings, (Class)this.source, false, this.source);
        } else if (this.source instanceof Method) {
            Method methodSource = (Method)this.source;
            if (Modifier.isPrivate(methodSource.getModifiers()) || Modifier.isFinal(methodSource.getModifiers()) || Modifier.isStatic(methodSource.getModifiers())) {
                this.collectElement(mappings, methodSource);
            } else {
                this.scanHierarchy(mappings, methodSource.getDeclaringClass(), true, methodSource);
            }
        }
        return mappings;
    }

    private void scanHierarchy(Set<AnnotatedElement> mappings, Class<?> type, boolean isMethod, AnnotatedElement source) {
        Method methodSource = isMethod ? (Method)source : null;
        LinkedList deque = new LinkedList();
        deque.addLast(type);
        HashSet accessed = new HashSet();
        while (!deque.isEmpty()) {
            type = (Class)deque.removeFirst();
            if (!this.isNeedMapping(type, accessed)) continue;
            if (!isMethod) {
                this.collectElement(mappings, type);
            } else {
                Stream.of(MethodUtil.getDeclaredMethods(type)).filter(method -> this.isMatchMethod(methodSource, (Method)method)).forEach(method -> this.collectElement(mappings, (AnnotatedElement)method));
            }
            accessed.add(type);
            deque.addLast(type.getSuperclass());
            CollUtil.addAll(deque, type.getInterfaces());
        }
    }

    private boolean isNeedMapping(Class<?> type, Set<Class<?>> accessedTypes) {
        return Objects.nonNull(type) && !accessedTypes.contains(type) && !Objects.equals(type, Object.class);
    }
}

