/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.Severity;
import org.codehaus.mojo.clirr.Difference;
import org.codehaus.mojo.clirr.MojoDiffListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClirrDiffListener
extends DiffListenerAdapter
implements MojoDiffListener {
    private List<ApiDifference> apiDifferences = new LinkedList<ApiDifference>();
    private Map<Difference, List<ApiDifference>> ignoredApiDifferences = new HashMap<Difference, List<ApiDifference>>();
    private Map<Severity, Integer> counts = new HashMap<Severity, Integer>(3);

    public void reportDiff(ApiDifference apiDifference) {
        this.incrementCount(apiDifference.getMaximumSeverity(), this.counts);
        this.apiDifferences.add(apiDifference);
    }

    @Override
    public void reportIgnoredDiff(ApiDifference ignoredDiff, Difference reason) {
        List<ApiDifference> diffs = this.ignoredApiDifferences.get(reason);
        if (diffs == null) {
            diffs = new LinkedList<ApiDifference>();
            this.ignoredApiDifferences.put(reason, diffs);
        }
        diffs.add(ignoredDiff);
    }

    public void stop() {
        Collections.sort(this.apiDifferences, new Comparator<ApiDifference>(){

            @Override
            public int compare(ApiDifference d1, ApiDifference d2) {
                return d2.getMaximumSeverity().compareTo((Object)d1.getMaximumSeverity());
            }
        });
    }

    private void incrementCount(Severity sev, Map<Severity, Integer> counts) {
        if (sev != null) {
            int count = this.getCount(counts, sev);
            counts.put(sev, count + 1);
        }
    }

    private int getCount(Map<Severity, Integer> counts, Severity sev) {
        Integer count = counts.get(sev);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public List<ApiDifference> getApiDifferences() {
        return Collections.unmodifiableList(this.apiDifferences);
    }

    public Map<Difference, List<ApiDifference>> getIgnoredApiDifferences() {
        return Collections.unmodifiableMap(this.ignoredApiDifferences);
    }

    public int getSeverityCount(Severity severity) {
        return this.getCount(this.counts, severity);
    }
}

