/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.aruco;

import org.opencv.core.Mat;

public class Dictionary {
    protected final long nativeObj;

    protected Dictionary(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Dictionary __fromPtr__(long addr) {
        return new Dictionary(addr);
    }

    public static Mat getBitsFromByteList(Mat byteList, int markerSize) {
        return new Mat(Dictionary.getBitsFromByteList_0(byteList.nativeObj, markerSize));
    }

    public static Mat getByteListFromBits(Mat bits) {
        return new Mat(Dictionary.getByteListFromBits_0(bits.nativeObj));
    }

    public static Dictionary create_from(int nMarkers, int markerSize, Dictionary baseDictionary, int randomSeed) {
        return Dictionary.__fromPtr__(Dictionary.create_from_0(nMarkers, markerSize, baseDictionary.getNativeObjAddr(), randomSeed));
    }

    public static Dictionary create_from(int nMarkers, int markerSize, Dictionary baseDictionary) {
        return Dictionary.__fromPtr__(Dictionary.create_from_1(nMarkers, markerSize, baseDictionary.getNativeObjAddr()));
    }

    public static Dictionary create(int nMarkers, int markerSize, int randomSeed) {
        return Dictionary.__fromPtr__(Dictionary.create_0(nMarkers, markerSize, randomSeed));
    }

    public static Dictionary create(int nMarkers, int markerSize) {
        return Dictionary.__fromPtr__(Dictionary.create_1(nMarkers, markerSize));
    }

    public static Dictionary get(int dict) {
        return Dictionary.__fromPtr__(Dictionary.get_0(dict));
    }

    public void drawMarker(int id, int sidePixels, Mat _img, int borderBits) {
        Dictionary.drawMarker_0(this.nativeObj, id, sidePixels, _img.nativeObj, borderBits);
    }

    public void drawMarker(int id, int sidePixels, Mat _img) {
        Dictionary.drawMarker_1(this.nativeObj, id, sidePixels, _img.nativeObj);
    }

    public Mat get_bytesList() {
        return new Mat(Dictionary.get_bytesList_0(this.nativeObj));
    }

    public void set_bytesList(Mat bytesList) {
        Dictionary.set_bytesList_0(this.nativeObj, bytesList.nativeObj);
    }

    public int get_markerSize() {
        return Dictionary.get_markerSize_0(this.nativeObj);
    }

    public void set_markerSize(int markerSize) {
        Dictionary.set_markerSize_0(this.nativeObj, markerSize);
    }

    public int get_maxCorrectionBits() {
        return Dictionary.get_maxCorrectionBits_0(this.nativeObj);
    }

    public void set_maxCorrectionBits(int maxCorrectionBits) {
        Dictionary.set_maxCorrectionBits_0(this.nativeObj, maxCorrectionBits);
    }

    protected void finalize() throws Throwable {
        Dictionary.delete(this.nativeObj);
    }

    private static native long getBitsFromByteList_0(long var0, int var2);

    private static native long getByteListFromBits_0(long var0);

    private static native long create_from_0(int var0, int var1, long var2, int var4);

    private static native long create_from_1(int var0, int var1, long var2);

    private static native long create_0(int var0, int var1, int var2);

    private static native long create_1(int var0, int var1);

    private static native long get_0(int var0);

    private static native void drawMarker_0(long var0, int var2, int var3, long var4, int var6);

    private static native void drawMarker_1(long var0, int var2, int var3, long var4);

    private static native long get_bytesList_0(long var0);

    private static native void set_bytesList_0(long var0, long var2);

    private static native int get_markerSize_0(long var0);

    private static native void set_markerSize_0(long var0, int var2);

    private static native int get_maxCorrectionBits_0(long var0);

    private static native void set_maxCorrectionBits_0(long var0, int var2);

    private static native void delete(long var0);
}

