/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.runtime.AbstractScalarProvider;
import org.babyfish.jimmer.sql.runtime.EnumProviderBuilder;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.jetbrains.annotations.NotNull;

public interface ScalarProvider<T, S> {
    @NotNull
    default public Type getScalarType() {
        return Meta.of(this.getClass()).scalarType;
    }

    @NotNull
    default public Class<S> getSqlType() {
        return Meta.of(this.getClass()).sqlType;
    }

    public T toScalar(@NotNull S var1) throws Exception;

    public S toSql(@NotNull T var1) throws Exception;

    default public Collection<ImmutableProp> getHandledProps() {
        return null;
    }

    default public boolean isJsonScalar() {
        return false;
    }

    default public Reader<S> reader() {
        return null;
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType) {
        return ScalarProvider.enumProviderByString(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType, Consumer<EnumProviderBuilder<E, String>> block) {
        EnumProviderBuilder<Enum, String> builder = EnumProviderBuilder.of(enumType, String.class, Enum::name);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType) {
        return ScalarProvider.enumProviderByInt(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType, Consumer<EnumProviderBuilder<E, Integer>> block) {
        EnumProviderBuilder<Enum, Integer> builder = EnumProviderBuilder.of(enumType, Integer.class, Enum::ordinal);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    public static ScalarProvider<UUID, byte[]> uuidByByteArray() {
        return AbstractScalarProvider.UUID_BY_BYTE_ARRAY;
    }

    public static ScalarProvider<UUID, String> uuidByString() {
        return AbstractScalarProvider.UUID_BY_STRING;
    }

    public static class Meta {
        private static final ClassCache<Meta> META_CACHE = new ClassCache(Meta::create);
        final Type scalarType;
        final Class<?> sqlType;

        private Meta(Type scalarType, Class<?> sqlType) {
            this.scalarType = scalarType;
            this.sqlType = sqlType;
        }

        public static Meta of(Class<?> scalarProviderType) {
            return (Meta)META_CACHE.get(scalarProviderType);
        }

        static Meta create(Class<?> scalarProviderType) {
            if (!ScalarProvider.class.isAssignableFrom(scalarProviderType)) {
                throw new IllegalArgumentException("The `scalarProviderType` \"" + scalarProviderType.getName() + "\" + does not implement \"" + ScalarProvider.class.getName() + "\"");
            }
            Map argMap = TypeUtils.getTypeArguments(scalarProviderType, ScalarProvider.class);
            if (argMap.isEmpty()) {
                throw new IllegalStateException("Illegal type \"" + scalarProviderType.getName() + "\", it does not specify generic arguments for \"" + ScalarProvider.class.getName() + "\"");
            }
            TypeVariable<Class<T>>[] params = ScalarProvider.class.getTypeParameters();
            Type scalarType = (Type)argMap.get(params[0]);
            Class sqlType = (Class)argMap.get(params[1]);
            Meta.validateScalarType(scalarType);
            return new Meta(scalarType, sqlType);
        }

        static void validateScalarType(Type scalarType) {
            if (scalarType == UUID.class) {
                return;
            }
            if (!(scalarType instanceof Class)) {
                return;
            }
            Class scalarClass = (Class)scalarType;
            if (scalarType == Void.TYPE) {
                throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", it cannot be void");
            }
            if (scalarType == Object.class) {
                throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support object type which means any");
            }
            if (TupleImplementor.class.isAssignableFrom(scalarClass)) {
                throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support tuple type");
            }
            Class<?> annotationType = Meta.getOrmAnnotationType(scalarClass);
            if (annotationType != null) {
                throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support scalar type which is decorated by \"@" + annotationType.getName() + "\"");
            }
        }

        private static Class<?> getOrmAnnotationType(Class<?> type) {
            Class<?> annoType;
            if (type == null) {
                return null;
            }
            if (type != Object.class) {
                if (type.isAnnotationPresent(Entity.class)) {
                    return Entity.class;
                }
                if (type.isAssignableFrom(MappedSuperclass.class)) {
                    return MappedSuperclass.class;
                }
                if (type.isAssignableFrom(Embeddable.class)) {
                    return Embeddable.class;
                }
            }
            if ((annoType = Meta.getOrmAnnotationType(type.getSuperclass())) != null) {
                return annoType;
            }
            for (Class<?> interfaceType : type.getInterfaces()) {
                annoType = Meta.getOrmAnnotationType(interfaceType);
                if (annoType == null) continue;
                return annoType;
            }
            return null;
        }
    }
}

