/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.babyfish.jimmer.DraftConsumerUncheckedException;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.runtime.Reader;

class DynamicEmbeddedReader
implements Reader<Object> {
    private final ImmutableType type;
    private final List<ImmutableProp> props;
    private final List<Reader<?>> readers;
    @Nullable
    private final List<PropId> shownPropIds;
    @Nullable
    private final List<PropId> hiddenPropIds;

    DynamicEmbeddedReader(ImmutableType type, List<ImmutableProp> props, List<Reader<?>> readers, @Nullable List<PropId> shownPropIds, @Nullable List<PropId> hiddenPropIds) {
        this.type = type;
        this.props = props;
        this.readers = readers;
        this.shownPropIds = shownPropIds;
        this.hiddenPropIds = hiddenPropIds;
    }

    @Override
    public void skip(Reader.Context ctx) {
        this.readers.forEach(reader -> reader.skip(ctx));
    }

    @Override
    public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
        DraftSpi spi = (DraftSpi)this.type.getDraftFactory().apply(ctx.draftContext(), null);
        boolean hasNoNull = false;
        boolean hasRequiredNull = false;
        try {
            int size = this.readers.size();
            for (int i = 0; i < size; ++i) {
                Object value = this.readers.get(i).read(rs, ctx);
                if (hasRequiredNull) continue;
                ImmutableProp prop = this.props.get(i);
                if (value == null) {
                    if (prop.isNullable()) {
                        spi.__set(prop.getId(), null);
                        continue;
                    }
                    hasRequiredNull = true;
                    continue;
                }
                spi.__set(prop.getId(), value);
                hasNoNull = true;
            }
        }
        catch (Throwable ex) {
            throw DraftConsumerUncheckedException.rethrow((Throwable)ex);
        }
        if (this.shownPropIds != null) {
            for (PropId propId : this.shownPropIds) {
                spi.__show(propId, true);
            }
        }
        if (this.hiddenPropIds != null) {
            for (PropId propId : this.hiddenPropIds) {
                spi.__show(propId, false);
            }
        }
        return hasNoNull && !hasRequiredNull ? ctx.resolve(spi) : null;
    }

    public String toString() {
        return "DynamicEmbeddedReader{type=" + this.type + ", propIds=" + this.props + ", rReaders=" + this.readers + '}';
    }
}

