/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.jetbrains.annotations.NotNull;

public class FilterArgsImpl<P extends Props>
implements FilterArgs<P> {
    private static final String JOIN_DISABLED_REASON = "it is not allowed by in filter";
    private final TableLikeImplementor<?> tableLikeImplementor;
    private final P props;
    private final List<Predicate> predicates = new ArrayList<Predicate>();

    public FilterArgsImpl(TableLikeImplementor<?> tableLikeImplementor, Props props, boolean forCache) {
        this.tableLikeImplementor = tableLikeImplementor;
        if (forCache) {
            props = props instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)((Object)props), JOIN_DISABLED_REASON) : ((TableProxy)props).__disableJoin(JOIN_DISABLED_REASON);
        }
        this.props = props;
    }

    @Override
    @NotNull
    public P getTable() {
        return this.props;
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        List<Predicate> list = this.predicates;
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            list.add(predicate);
        }
        return this;
    }

    @Override
    public Sortable orderBy(Expression<?> ... expressions) {
        AbstractMutableStatementImpl filterable = this.tableLikeImplementor.getStatement();
        if (filterable instanceof Sortable) {
            ((Sortable)((Object)filterable)).orderBy(expressions);
        }
        return this;
    }

    @Override
    public Sortable orderBy(Order ... orders) {
        AbstractMutableStatementImpl filterable = this.tableLikeImplementor.getStatement();
        if (filterable instanceof Sortable) {
            ((Sortable)((Object)filterable)).orderBy(orders);
        }
        return this;
    }

    @Override
    public Sortable orderBy(List<Order> orders) {
        AbstractMutableStatementImpl filterable = this.tableLikeImplementor.getStatement();
        if (filterable instanceof Sortable) {
            ((Sortable)((Object)filterable)).orderBy(orders);
        }
        return this;
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        AbstractMutableStatementImpl filterable = this.tableLikeImplementor.getStatement();
        return filterable.createSubQuery(table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        AbstractMutableStatementImpl filterable = this.tableLikeImplementor.getStatement();
        return filterable.createAssociationSubQuery(table);
    }

    public AbstractMutableStatementImpl unwrap() {
        return this.tableLikeImplementor.getStatement();
    }

    public List<Predicate> toPredicates() {
        return this.predicates;
    }
}

