/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.impl.util.PropCache;
import org.babyfish.jimmer.lang.Lazy;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.binlog.BinLogPropReader;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogModule;
import org.babyfish.jimmer.sql.event.binlog.impl.MiddleRow;
import org.babyfish.jimmer.sql.event.binlog.impl.ValueParser;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinLogParser {
    private final Map<String, BinLogPropReader> readerMap = new HashMap<String, BinLogPropReader>();
    private final Map<Class<?>, BinLogPropReader> typeReaderMap = new HashMap();
    private final PropCache<BinLogPropReader> readerCache = new PropCache(this::createReader, true);
    private ObjectMapper mapper;
    private JSqlClientImplementor sqlClient;

    public BinLogParser initialize(JSqlClientImplementor sqlClient, ObjectMapper mapper, Map<ImmutableProp, BinLogPropReader> propReaderMap, Map<Class<?>, BinLogPropReader> typePropReaderMap) {
        if (sqlClient == null) {
            throw new IllegalArgumentException("`sqlClient` cannot be null");
        }
        ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper();
        clonedMapper.registerModule((Module)new BinLogModule(this)).registerModule((Module)new JavaTimeModule());
        this.mapper = clonedMapper;
        this.sqlClient = sqlClient;
        HashMap<String, BinLogPropReader> propNameReaderMap = new HashMap<String, BinLogPropReader>();
        for (ImmutableType type : sqlClient.getEntityManager().getAllTypes(sqlClient.getMicroServiceName())) {
            for (ImmutableProp prop : type.getEntityProps().values()) {
                BinLogPropReader reader = BinLogParser.reader(prop, propReaderMap);
                if (reader == null) continue;
                propNameReaderMap.put(prop.toString(), reader);
            }
        }
        this.readerMap.putAll(propNameReaderMap);
        this.typeReaderMap.putAll(typePropReaderMap);
        return this;
    }

    public JSqlClientImplementor sqlClient() {
        return this.sqlClient;
    }

    public BinLogPropReader reader(ImmutableProp prop) {
        return (BinLogPropReader)this.readerCache.get(prop);
    }

    public <T> T parseEntity(@NotNull Class<T> type, String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)this.mapper().readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
    }

    public <T> T parseEntity(@NotNull Class<T> type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <T> T parseEntity(@NotNull ImmutableType type, String json) {
        if (type instanceof AssociationType) {
            throw new IllegalArgumentException("type cannot be AssociationType");
        }
        return this.parseEntity(type.getJavaClass(), json);
    }

    public <T> T parseEntity(@NotNull ImmutableType type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull AssociationType associationType, JsonNode data) {
        AssociationProp sourceProp = associationType.getSourceProp();
        AssociationProp targetProp = associationType.getTargetProp();
        ImmutableProp sourceIdProp = sourceProp.getTargetType().getIdProp();
        ImmutableProp targetIdProp = targetProp.getTargetType().getIdProp();
        MetadataStrategy strategy = this.sqlClient.getMetadataStrategy();
        LogicalDeletedInfo deletedInfo = associationType.getJoinTableDeletedInfo();
        JoinTableFilterInfo filterInfo = associationType.getJoinTableFilterInfo();
        String deletedColumnName = deletedInfo != null ? DatabaseIdentifiers.comparableIdentifier((String)deletedInfo.getColumnName()) : null;
        String filteredColumnName = filterInfo != null ? DatabaseIdentifiers.comparableIdentifier((String)filterInfo.getColumnName()) : null;
        Object sourceId = null;
        Object targetId = null;
        Boolean deleted = null;
        Object filteredValue = null;
        Iterator fieldEntryItr = data.fields();
        while (fieldEntryItr.hasNext()) {
            Map.Entry e = (Map.Entry)fieldEntryItr.next();
            String columnName = (String)e.getKey();
            String comparableColumnName = DatabaseIdentifiers.comparableIdentifier((String)columnName);
            if (comparableColumnName.equals(deletedColumnName)) {
                deleted = deletedInfo.isDeleted(ValueParser.valueOrError((JsonNode)e.getValue(), deletedInfo.getType()));
                continue;
            }
            if (comparableColumnName.equals(filteredColumnName)) {
                filteredValue = ValueParser.valueOrError((JsonNode)e.getValue(), filterInfo.getType());
                continue;
            }
            List chain = associationType.getPropChain((String)e.getKey(), strategy, true);
            if (chain == null) continue;
            if (chain.get(0) == sourceProp) {
                if (sourceIdProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                    sourceId = Internal.produce((ImmutableType)sourceIdProp.getTargetType(), sourceId, draft -> ValueParser.addEntityProp((DraftSpi)draft, chain.subList(2, chain.size()), (JsonNode)e.getValue(), this));
                    continue;
                }
                sourceId = ValueParser.parseSingleValue(this, (JsonNode)e.getValue(), sourceIdProp, false);
                continue;
            }
            if (chain.get(0) != targetProp) continue;
            if (targetIdProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                targetId = Internal.produce((ImmutableType)targetIdProp.getTargetType(), targetId, draft -> ValueParser.addEntityProp((DraftSpi)draft, chain.subList(2, chain.size()), (JsonNode)e.getValue(), this));
                continue;
            }
            targetId = ValueParser.parseSingleValue(this, (JsonNode)e.getValue(), targetIdProp, false);
        }
        return new MiddleRow<Object, Object>(sourceId, targetId, deleted, filteredValue);
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull AssociationType associationType, String json) {
        JsonNode data;
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            data = this.mapper().readTree(json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
        return this.parseMiddleRow(associationType, data);
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull TypedProp<?, ?> prop, JsonNode data) {
        return this.parseMiddleRow(AssociationType.of(prop.unwrap()), data);
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull ImmutableProp prop, JsonNode data) {
        return this.parseMiddleRow(AssociationType.of(prop), data);
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull TypedProp<?, ?> prop, String json) {
        return this.parseMiddleRow(AssociationType.of(prop.unwrap()), json);
    }

    public <S, T> MiddleRow<S, T> parseMiddleRow(@NotNull ImmutableProp prop, String json, @Nullable Lazy<Tuple2<?, ?>> defaultTupleLazy) {
        return this.parseMiddleRow(AssociationType.of(prop), json);
    }

    private static BinLogPropReader reader(ImmutableProp prop, Map<ImmutableProp, BinLogPropReader> configuredReaderMap) {
        BinLogPropReader reader = configuredReaderMap.get(prop);
        if (reader != null) {
            return reader;
        }
        for (ImmutableType superType : prop.getDeclaringType().getSuperTypes()) {
            ImmutableProp superProp = (ImmutableProp)superType.getProps().get(prop.getName());
            if (superProp == null) continue;
            BinLogPropReader superReader = BinLogParser.reader(superProp, configuredReaderMap);
            if (reader == null) {
                reader = superReader;
                continue;
            }
            if (reader.equals(superReader)) continue;
            throw new ModelException("Conflict super binlog reader for property \"" + prop + "\"");
        }
        return reader;
    }

    private BinLogPropReader createReader(ImmutableProp prop) {
        BinLogPropReader reader = this.readerMap.get(prop.toString());
        if (reader != null) {
            return reader;
        }
        return this.typeReaderMap.get(prop.getElementClass());
    }

    private ObjectMapper mapper() {
        ObjectMapper mapper = this.mapper;
        if (mapper == null) {
            throw new IllegalStateException("The binlog is not ready because the initialization of sqlClient is 'MANUAL' but the sqlClient is not initialized");
        }
        return mapper;
    }
}

