/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.table;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.table.AssociationTableProxyImpl;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;

public interface AssociationTable<SE, ST extends Table<SE>, TE, TT extends Table<TE>>
extends TableEx<Association<SE, TE>> {
    default public ST source() {
        return (ST)this.join("source");
    }

    default public <SID> PropExpression<SID> sourceId() {
        return this.getAssociatedId("source");
    }

    default public ST source(ImmutableType treatedAs) {
        return (ST)this.join("source", JoinType.INNER, treatedAs);
    }

    default public <TID> PropExpression<TID> targetId() {
        return this.getAssociatedId("target");
    }

    default public TT target() {
        return (TT)this.join("target");
    }

    default public ST target(ImmutableType treatedAs) {
        return (ST)this.join("target", JoinType.INNER, treatedAs);
    }

    public static <SE, ST extends Table<SE>, TE, TT extends Table<TE>> AssociationTable<SE, ST, TE, TT> of(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter) {
        return AssociationTableProxyImpl.table(AssociationType.of(ImmutableProps.join(sourceTableType, targetTableGetter)));
    }
}

