/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.value.EmbeddedValueGetter;
import org.babyfish.jimmer.sql.ast.impl.value.GetterMetadata;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPropertyGetter
implements PropertyGetter {
    @Nullable
    final String alias;
    final ImmutableProp prop;
    final ValueGetter valueGetter;

    AbstractPropertyGetter(@Nullable String alias, ImmutableProp prop, ValueGetter valueGetter) {
        this.alias = alias;
        this.prop = prop;
        this.valueGetter = valueGetter;
    }

    @Override
    @Nullable
    public String alias() {
        return this.alias;
    }

    @Override
    public ImmutableProp prop() {
        return this.prop;
    }

    @Override
    public GetterMetadata metadata() {
        return this.valueGetter.metadata();
    }

    public int hashCode() {
        return this.prop.hashCode() * 31 + this.valueGetter.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPropertyGetter)) {
            return false;
        }
        AbstractPropertyGetter other = (AbstractPropertyGetter)obj;
        return this.prop.equals((Object)other.prop) && this.valueGetter.equals(other.valueGetter);
    }

    public final String toString() {
        if (this.valueGetter instanceof EmbeddedValueGetter) {
            return this.toStringPrefix() + '.' + this.valueGetter;
        }
        return this.toStringPrefix();
    }

    @Override
    public boolean isInsertable(Collection<ImmutableProp> conflictProps, @Nullable UpsertMask<?> mask) {
        if (conflictProps.contains(this.prop)) {
            return true;
        }
        if (mask == null) {
            return true;
        }
        return this.isMutableByPaths(mask.getInsertablePaths());
    }

    @Override
    public boolean isUpdatable(Collection<ImmutableProp> conflictProps, @Nullable UpsertMask<?> mask) {
        if (conflictProps.contains(this.prop)) {
            return false;
        }
        if (mask == null) {
            return true;
        }
        return this.isMutableByPaths(mask.getUpdatablePaths());
    }

    private boolean isMutableByPaths(@Nullable List<List<ImmutableProp>> paths) {
        if (paths == null) {
            return true;
        }
        for (List<ImmutableProp> path : paths) {
            if (!this.isMutableByPath(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isMutableByPath(@Nullable List<ImmutableProp> path) {
        if (!this.prop.equals((Object)path.get(0))) {
            return false;
        }
        if (path.size() > 1) {
            if (!(this.valueGetter instanceof EmbeddedValueGetter)) {
                return false;
            }
            List<ImmutableProp> deeperProps = path.subList(1, path.size());
            List<ImmutableProp> currentDeeperProps = ((EmbeddedValueGetter)this.valueGetter).props();
            int size = deeperProps.size();
            if (size > currentDeeperProps.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (deeperProps.get(i).equals((Object)currentDeeperProps.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    abstract String toStringPrefix();
}

