/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.LinkedList;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.jetbrains.annotations.NotNull;

public class IsNullUtils {
    private IsNullUtils() {
    }

    public static void isValidIsNullExpression(@NotNull PropExpressionImplementor<?> propExpression) {
        for (PropExpressionImplementor<?> pe = propExpression; pe != null; pe = pe.getBase()) {
            if (!pe.isNullable()) continue;
            return;
        }
        TableLike<Object> table = propExpression.getTable();
        while (table != null) {
            JoinType currentJoinType;
            ImmutableProp prop;
            if (table instanceof TableProxy) {
                TableProxy proxy = (TableProxy)table;
                prop = proxy.__prop();
                if (proxy.__isInverse()) {
                    prop = prop.getOpposite();
                }
                if (prop != null && ((currentJoinType = proxy.__joinType()) == JoinType.LEFT || currentJoinType == JoinType.FULL)) {
                    return;
                }
                table = proxy.__parent();
                continue;
            }
            TableImplementor impl = (TableImplementor)table;
            prop = impl.getJoinProp();
            if (impl.isInverse()) {
                prop = prop.getOpposite();
            }
            if (prop != null && ((currentJoinType = impl.getJoinType()) == JoinType.LEFT || currentJoinType == JoinType.FULL)) {
                return;
            }
            table = impl.getParent();
        }
        LinkedList<String> pathNames = new LinkedList<String>();
        for (PropExpressionImplementor<?> pe = propExpression; pe != null; pe = pe.getBase()) {
            if (!pe.isNullable()) continue;
            pathNames.add(0, pe.getProp().getName());
        }
        TableLike<Object> table2 = propExpression.getTable();
        while (table2 != null) {
            ImmutableProp prop;
            if (table2 instanceof TableProxy) {
                TableProxy proxy = (TableProxy)table2;
                prop = proxy.__prop();
                if (proxy.__isInverse()) {
                    prop = prop.getOpposite();
                }
                if (prop != null) {
                    pathNames.add(0, prop.getName() + "(" + proxy.__joinType().name() + ")");
                } else if (proxy.__weakJoinHandle() != null) {
                    pathNames.add(0, "weakJoin<" + proxy.__weakJoinHandle().getWeakJoinType().getSimpleName() + ">");
                } else {
                    pathNames.add(0, table2.getImmutableType().getJavaClass().getSimpleName());
                }
                table2 = proxy.__parent();
                continue;
            }
            TableImplementor impl = (TableImplementor)table2;
            prop = impl.getJoinProp();
            if (impl.isInverse()) {
                prop = prop.getOpposite();
            }
            if (prop != null) {
                pathNames.add(0, prop.getName() + "(" + impl.getJoinType().name() + ")");
            }
            if (impl.getWeakJoinHandle() != null) {
                pathNames.add(0, "weakJoin<" + impl.getWeakJoinHandle().getWeakJoinType().getSimpleName() + ">");
            } else {
                pathNames.add(0, table2.getImmutableType().getJavaClass().getSimpleName());
            }
            table2 = impl.getParent();
        }
        String path = String.join((CharSequence)".", pathNames);
        throw new IllegalArgumentException("Unable to instantiate the \"is null\" predicate, the path \"" + path + "\" is neither non-null expression nor path with left or full table join");
    }
}

