/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.List;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedBaseQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTypeMergeScope;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.RealTableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.jetbrains.annotations.NotNull;

public class BaseTableImpl
extends AbstractDataManager<Key, BaseTableImpl>
implements BaseTableImplementor {
    private final BaseTableSymbol symbol;
    private final TableLikeImplementor<?> parent;
    private final BaseTableImplementor recursive;
    private BaseTableSymbol rootSymbol;
    private RealTable rootRealTable;

    public static BaseTableImplementor of(BaseTableSymbol symbol, TableLikeImplementor<?> parent, BaseTableImplementor recursive) {
        BaseTableImpl child;
        if (parent == null) {
            return new BaseTableImpl(symbol, null, null);
        }
        if (parent instanceof TableImplementor) {
            ((TableImplementor)parent).setHasBaseTable();
        }
        if (parent instanceof BaseTableImplementor) {
            BaseTableImpl parentImpl = (BaseTableImpl)parent;
            Key key = new Key(symbol.getWeakJoinHandle(), symbol.getJoinType());
            child = (BaseTableImpl)parentImpl.getValue(key);
            if (child == null) {
                child = new BaseTableImpl(symbol, parentImpl, recursive);
                parentImpl.putValue(key, child);
            }
        } else {
            TableImpl parentImpl = (TableImpl)parent;
            parentImpl.setHasBaseTable();
            child = parentImpl.computedIfAbsent(new TableImpl.Key("", symbol.getJoinType(), symbol.getWeakJoinHandle(), false), () -> new BaseTableImpl(symbol, parent, recursive));
        }
        return child;
    }

    private BaseTableImpl(BaseTableSymbol symbol, TableLikeImplementor<?> parent, BaseTableImplementor recursive) {
        this.symbol = symbol;
        this.parent = parent;
        this.recursive = recursive;
    }

    @Override
    public TableLikeImplementor<?> getParent() {
        return this.parent;
    }

    @Override
    public WeakJoinHandle getWeakJoinHandle() {
        return this.symbol.getWeakJoinHandle();
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.symbol.getSelections();
    }

    @Override
    public JoinType getJoinType() {
        return this.symbol.getJoinType();
    }

    @Override
    public TypedBaseQueryImplementor<?> getQuery() {
        return this.symbol.getQuery();
    }

    @Override
    public BaseTableSymbol toSymbol() {
        return this.symbol;
    }

    @Override
    public BaseTableImplementor getRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isCte() {
        return this.toSymbol().isCte();
    }

    @Override
    public boolean isRecursiveCte() {
        return this.toSymbol().isRecursiveCte();
    }

    @Override
    public RealTable realTable(JoinTypeMergeScope scope) {
        if (this.parent == null) {
            RealTable rrt = this.rootRealTable;
            if (rrt == null) {
                this.rootRealTable = rrt = new RealTableImpl(this);
            }
            return rrt;
        }
        RealTableImpl parentRealTable = (RealTableImpl)this.parent.realTable(scope);
        return parentRealTable.child(scope, this);
    }

    @Override
    public void accept(AstVisitor visitor) {
        visitor.visitTableReference(this.realTable(visitor.getAstContext()), null, false);
        BaseTableImpl.actualQuery(this.symbol).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sql(" from ");
        this.realTable(builder.assertSimple().getAstContext()).renderTo(builder, false);
    }

    void renderBaseQueryCore(AbstractSqlBuilder<?> builder) {
        BaseTableImpl.actualQuery(this.symbol).renderTo(builder);
    }

    private static TypedBaseQueryImplementor<?> actualQuery(BaseTableSymbol symbol) {
        ConfigurableBaseQueryImpl<?> query = symbol.getQuery();
        MergedBaseQueryImpl<?> mergedBy = query.getMergedBy();
        return mergedBy != null ? mergedBy : query;
    }

    @Override
    public AbstractMutableStatementImpl getStatement() {
        return this.getRootSymbol().getQuery().getMutableQuery();
    }

    private BaseTableSymbol getRootSymbol() {
        BaseTableSymbol rs = this.rootSymbol;
        if (rs == null) {
            this.rootSymbol = rs = this.createRootSymbol();
        }
        return rs;
    }

    private BaseTableSymbol createRootSymbol() {
        if (this.parent instanceof BaseTableImpl) {
            return ((BaseTableImpl)this.parent).createRootSymbol();
        }
        return this.symbol;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseTableImpl");
        this.toString(true, true, builder);
        return builder.toString();
    }

    private void toString(boolean up, boolean down, StringBuilder builder) {
        builder.append("{");
        builder.append("symbol=").append(this.symbol);
        if (up && this.parent != null) {
            builder.append(",parent=");
            if (this.parent instanceof BaseTableImpl) {
                ((BaseTableImpl)this.parent).toString(true, false, builder);
            } else {
                builder.append(this.parent);
            }
        }
        if (down && !this.isEmpty()) {
            builder.append(",children=[");
            boolean addComma = false;
            for (BaseTableImpl child : this) {
                if (addComma) {
                    builder.append(",");
                } else {
                    addComma = true;
                }
                child.toString(false, true, builder);
            }
            builder.append(']');
        }
        builder.append("}");
    }

    @Override
    public boolean hasBaseTable() {
        return true;
    }

    public static class Key {
        final WeakJoinHandle handle;
        final JoinType joinType;

        Key(WeakJoinHandle handle, JoinType joinType) {
            this.handle = handle;
            this.joinType = joinType;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.handle.equals(key.handle) && this.joinType == key.joinType;
        }

        public int hashCode() {
            int result = this.handle.hashCode();
            result = 31 * result + this.joinType.hashCode();
            return result;
        }

        public String toString() {
            return "Key{handle=" + this.handle + ", joinType=" + this.joinType + '}';
        }
    }
}

