/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.render;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Variables;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.util.ArrayUtils;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSqlBuilder<T extends AbstractSqlBuilder<T>> {
    protected static final Map<Class<?>, Converter<?, ?>> ARRAY_CONVERTER_MAP;
    protected final StringBuilder builder = new StringBuilder();
    private boolean indentRequired;

    protected abstract SqlFormatter formatter();

    protected abstract ScopeManager scopeManager();

    public abstract JSqlClientImplementor sqlClient();

    public T sql(String sql) {
        this.preAppend();
        this.builder.append(sql);
        return (T)this;
    }

    public T sql(ValueGetter getter) {
        getter.metadata().renderTo(this);
        return (T)this;
    }

    public final T ast(Ast ast, int currentPrecedence) {
        if (ast instanceof ExpressionImplementor && ((ExpressionImplementor)((Object)ast)).precedence() <= currentPrecedence) {
            ast.renderTo(this);
        } else {
            ((AbstractSqlBuilder)this.sql("(")).space('\n');
            ast.renderTo(this);
            ((AbstractSqlBuilder)this.space('\n')).sql(")");
        }
        return (T)this;
    }

    public T logicalDeleteAssignment(LogicalDeletedInfo logicalDeletedInfo, @Nullable Ref<?> generatedValueRef, @Nullable String alias) {
        Object generatedValue;
        String assignedName = logicalDeletedInfo.getColumnName();
        if (assignedName == null) {
            assignedName = ((SingleColumn)logicalDeletedInfo.getProp().getStorage(this.sqlClient().getMetadataStrategy())).getName();
        }
        if (alias != null) {
            assignedName = alias + '.' + assignedName;
        }
        ((AbstractSqlBuilder)this.sql(assignedName)).sql(" = ");
        if (generatedValueRef != null) {
            generatedValue = generatedValueRef.getValue();
        } else {
            LogicalDeletedValueGenerator generator = LogicalDeletedValueGenerators.of((LogicalDeletedInfo)logicalDeletedInfo, (SqlContext)this.sqlClient());
            Object object = generatedValue = generator != null ? generator.generate() : null;
        }
        if (generatedValue == null) {
            this.sql("null");
        } else {
            generatedValue = Variables.process(generatedValue, logicalDeletedInfo.getType(), this.sqlClient());
            this.rawVariable(generatedValue);
        }
        return (T)this;
    }

    public T logicalDeleteFilter(LogicalDeletedInfo logicalDeletedInfo, String alias) {
        LogicalDeletedInfo.Action action;
        String assignedName = logicalDeletedInfo.getColumnName();
        if (assignedName == null) {
            assignedName = ((SingleColumn)logicalDeletedInfo.getProp().getStorage(this.sqlClient().getMetadataStrategy())).getName();
        }
        if (alias != null) {
            assignedName = alias + '.' + assignedName;
        }
        if ((action = logicalDeletedInfo.getAction()) instanceof LogicalDeletedInfo.Action.Eq) {
            LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" = ");
            Object value = eq.getValue();
            value = Variables.process(value, logicalDeletedInfo.getProp(), this.sqlClient());
            this.rawVariable(value);
        } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
            LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" <> ");
            Object value = ne.getValue();
            value = Variables.process(value, logicalDeletedInfo.getProp(), this.sqlClient());
            this.rawVariable(value);
        } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" is null");
        } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" is not null");
        }
        return (T)this;
    }

    public abstract T rawVariable(Object var1);

    public T enter(String separator) {
        this.enterImpl(ScopeType.BLANK, separator);
        return (T)this;
    }

    public T enter(ScopeType type) {
        this.enterImpl(type, null);
        return (T)this;
    }

    private void enterImpl(ScopeType type, String separator) {
        boolean ignored;
        ScopeManager scopeManager = this.scopeManager();
        Scope parentScope = scopeManager.current;
        boolean bl = ignored = type == ScopeType.NULL || type == ScopeType.TUPLE && parentScope != null && parentScope.type == ScopeType.TUPLE;
        if (!ignored) {
            if (type == ScopeType.SMART_OR) {
                if (parentScope == null) {
                    this.part(ScopeType.SUB_QUERY.prefix);
                } else if (parentScope.isAndLike()) {
                    this.part(ScopeType.SUB_QUERY.prefix);
                }
            } else {
                this.part(type.prefix);
            }
        }
        scopeManager.current = new Scope(parentScope, type, ignored, separator);
    }

    public T separator() {
        Scope scope = this.scopeManager().current;
        if (scope != null && scope.dirty) {
            boolean forceInLine = false;
            if (scope.type == ScopeType.LIST) {
                boolean bl = forceInLine = ++scope.listSeparatorCount < this.formatter().getListParamCountInLine();
                if (!forceInLine) {
                    scope.listSeparatorCount = 0;
                }
            }
            if (scope.type.isSeparatorIndent) {
                this.part(scope.separator, forceInLine);
            } else {
                --scope.depth;
                this.part(scope.separator, forceInLine);
                ++scope.depth;
            }
            scope.dirty = false;
        }
        return (T)this;
    }

    public T leave() {
        Scope parentScope;
        ScopeManager scopeManager = this.scopeManager();
        Scope scope = scopeManager.current;
        scopeManager.current = parentScope = scope.parent;
        if (!scope.ignored) {
            if (scope.type == ScopeType.SMART_OR) {
                if (parentScope == null) {
                    this.part(ScopeType.SUB_QUERY.suffix);
                } else if (parentScope.isAndLike()) {
                    this.part(ScopeType.SUB_QUERY.suffix);
                }
            } else {
                this.part(scope.type.suffix);
            }
        }
        return (T)this;
    }

    private void part(ScopeType.Part part) {
        this.part(part, false);
    }

    private void part(ScopeType.Part part, boolean forceInLine) {
        if (part == null) {
            return;
        }
        this.space(part.before, forceInLine);
        this.preAppend();
        this.builder.append(part.value);
        this.space(part.after, forceInLine);
    }

    public T space(char ch) {
        return this.space(ch, false);
    }

    public T space(char ch, boolean forceInLine) {
        switch (ch) {
            case '?': {
                if (!forceInLine && this.formatter().isPretty()) {
                    this.newLine();
                    break;
                }
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case ' ': {
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case '\n': {
                if (forceInLine || !this.formatter().isPretty()) break;
                this.newLine();
            }
        }
        return (T)this;
    }

    protected final void preAppend() {
        Scope scope = this.scopeManager().current;
        if (scope != null) {
            scope.setDirty();
        }
        if (scope == null || !this.indentRequired) {
            this.indentRequired = false;
            return;
        }
        this.indentRequired = false;
        String indent = this.formatter().getIndent();
        for (int i = scope.depth; i > 0; --i) {
            this.builder.append(indent);
        }
    }

    private void newLine() {
        this.builder.append('\n');
        this.indentRequired = true;
    }

    public SqlBuilder assertSimple() {
        if (this instanceof SqlBuilder) {
            return (SqlBuilder)this;
        }
        throw new IllegalArgumentException("The argument cannot be \"" + this.getClass().getName() + "\", only \"" + SqlBuilder.class.getName() + "\"");
    }

    public T definition(String tableAlias, ColumnDefinition definition, BaseSelectionMapper mapper) {
        return this.definition(tableAlias, definition, null, mapper);
    }

    public T definition(String tableAlias, ColumnDefinition definition, Function<Integer, String> asBlock, BaseSelectionMapper mapper) {
        block6: {
            block4: {
                String columnName;
                block5: {
                    if (tableAlias == null || tableAlias.isEmpty()) {
                        return this.definition(definition);
                    }
                    this.preAppend();
                    if (!(definition instanceof SingleColumn)) break block4;
                    columnName = ((SingleColumn)definition).getName();
                    if (mapper == null) break block5;
                    this.builder.append(mapper.getAlias()).append(".c").append(mapper.columnIndex(tableAlias, columnName));
                    break block6;
                }
                this.builder.append(tableAlias).append('.').append(columnName);
                if (asBlock == null) break block6;
                this.builder.append(" ").append(asBlock.apply(0));
                break block6;
            }
            int size = definition.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.builder.append(", ");
                }
                String columnName = definition.name(i);
                if (mapper != null) {
                    this.builder.append(mapper.getAlias()).append(".c").append(mapper.columnIndex(tableAlias, columnName));
                    continue;
                }
                this.builder.append(tableAlias).append('.').append(columnName);
                if (asBlock == null) continue;
                this.builder.append(" ").append(asBlock.apply(i));
            }
        }
        return (T)this;
    }

    public T definition(ColumnDefinition definition) {
        this.preAppend();
        if (definition instanceof SingleColumn) {
            this.builder.append(((SingleColumn)definition).getName());
        } else {
            boolean addComma = false;
            for (String columnName : definition) {
                if (addComma) {
                    this.builder.append(", ");
                } else {
                    addComma = true;
                }
                this.builder.append(columnName);
            }
        }
        return (T)this;
    }

    protected BatchSqlBuilder assertBatch(AbstractSqlBuilder<?> builder) {
        if (this instanceof BatchSqlBuilder) {
            return (BatchSqlBuilder)this;
        }
        throw new IllegalArgumentException("The argument cannot be \"" + this.getClass().getName() + "\", only \"" + SqlBuilder.class.getName() + "\"");
    }

    public String toString() {
        return this.builder.toString();
    }

    static {
        HashMap map = new HashMap();
        map.put(boolean[].class, new Converter<boolean[], Boolean[]>(){

            @Override
            public Boolean[] convert(boolean[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(char[].class, new Converter<char[], Character[]>(){

            @Override
            public Character[] convert(char[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(short[].class, new Converter<short[], Short[]>(){

            @Override
            public Short[] convert(short[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(int[].class, new Converter<int[], Integer[]>(){

            @Override
            public Integer[] convert(int[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(long[].class, new Converter<long[], Long[]>(){

            @Override
            public Long[] convert(long[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(float[].class, new Converter<float[], Float[]>(){

            @Override
            public Float[] convert(float[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        map.put(double[].class, new Converter<double[], Double[]>(){

            @Override
            public Double[] convert(double[] arr) {
                return ArrayUtils.toObject(arr);
            }
        });
        ARRAY_CONVERTER_MAP = map;
    }

    public static enum ScopeType {
        NULL(null, null, null),
        BLANK(null, null, null),
        SELECT("select?", ",?", null),
        SELECT_DISTINCT("select distinct?", ",?", null),
        SET("?set?", ",?", null),
        WHERE("?where?", "?and?", null),
        ORDER_BY("?order by?", ",?", null),
        GROUP_BY("?group by?", ",?", null),
        HAVING("?having?", "?and?", null),
        SUB_QUERY("(\n", null, "\n)"),
        LIST("(\n", ",?", "\n)"),
        COMMA(null, ",?", null),
        TUPLE("(", ", ", ")"),
        MULTIPLE_LINE_TUPLE("(\n", ", ", "\n)"),
        AND(null, "?and?", null, false),
        OR(null, "?or?", null, false),
        SMART_OR(null, "?or?", null, false),
        VALUES("?values\n", ",?", null);

        final Part prefix;
        final Part separator;
        final Part suffix;
        final boolean isSeparatorIndent;

        private ScopeType(String prefix, String separator, String suffix) {
            this(prefix, separator, suffix, true);
        }

        private ScopeType(String prefix, String separator, String suffix, boolean isSeparatorIndent) {
            this.prefix = ScopeType.partOf(prefix);
            this.separator = ScopeType.partOf(separator);
            this.suffix = ScopeType.partOf(suffix);
            this.isSeparatorIndent = isSeparatorIndent;
        }

        private static Part partOf(String value) {
            if (value == null) {
                return null;
            }
            char before = ScopeType.spaceChar(value.charAt(0));
            char after = value.length() > 1 ? ScopeType.spaceChar(value.charAt(value.length() - 1)) : (char)'\u0000';
            return new Part(before, value.substring(before == '\u0000' ? 0 : 1, value.length() - (after == '\u0000' ? 0 : 1)), after);
        }

        private static char spaceChar(char c) {
            return c == ' ' || c == '\n' || c == '?' ? c : (char)'\u0000';
        }

        private static class Part {
            final char before;
            final String value;
            final char after;

            Part(char before, String value, char after) {
                this.before = before;
                this.value = value;
                this.after = after;
            }
        }
    }

    protected static class ScopeManager {
        public Scope current;

        public Scope cloneScope() {
            if (this.current == null) {
                return null;
            }
            return new Scope(this.current);
        }
    }

    protected static class Scope {
        final Scope parent;
        final ScopeType type;
        final boolean ignored;
        final ScopeType.Part separator;
        int depth;
        boolean dirty;
        int listSeparatorCount;

        Scope(Scope parent, ScopeType type, boolean ignored, String separator) {
            this.parent = parent;
            this.type = type;
            this.ignored = ignored;
            this.depth = ignored ? (parent != null ? parent.depth : 0) : (parent != null ? parent.depth + 1 : 1);
            this.separator = separator != null ? ScopeType.partOf(separator) : type.separator;
        }

        Scope(Scope base) {
            this.parent = base.parent != null ? new Scope(base.parent) : null;
            this.type = base.type;
            this.ignored = base.ignored;
            this.separator = base.separator;
            this.depth = base.depth;
            this.dirty = base.dirty;
            this.listSeparatorCount = base.listSeparatorCount;
        }

        void setDirty() {
            Scope scope = this;
            while (scope != null && !scope.dirty) {
                scope.dirty = true;
                scope = scope.parent;
            }
        }

        public boolean isAndLike() {
            Scope scope = this;
            while (scope != null) {
                ScopeType scopeType = scope.type;
                if (scopeType != ScopeType.NULL) {
                    return scopeType == ScopeType.AND || scopeType == ScopeType.WHERE || scopeType == ScopeType.HAVING;
                }
                scope = scope.parent;
            }
            return false;
        }
    }

    protected static interface Converter<S, T> {
        public T convert(S var1);
    }
}

