/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.AbstractBaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableKind;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbols;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.RecursiveBaseQueryCreator;
import org.babyfish.jimmer.sql.ast.impl.query.TypedBaseQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableTypeProvider;
import org.babyfish.jimmer.sql.ast.query.ConfigurableBaseQuery;
import org.babyfish.jimmer.sql.ast.query.TypedBaseQuery;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTypedTable;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;

public class MergedBaseQueryImpl<T extends BaseTable>
implements TypedBaseQuery<T>,
TypedBaseQueryImplementor<T> {
    private static final ConfigurableBaseQueryImpl<?>[] EMPTY_QUERIES = new ConfigurableBaseQueryImpl[0];
    final JSqlClientImplementor sqlClient;
    private final String operator;
    private TypedBaseQueryImplementor<T>[] queries;
    private ConfigurableBaseQueryImpl<T>[] expandedQueries;
    private T baseTable;
    private MergedBaseQueryImpl<T> mergedBy;
    private final boolean recursive;
    private RecursiveBaseQueryCreator<T>[] recursiveBaseQueryCreators;

    @SafeVarargs
    public static <T extends BaseTable> TypedBaseQuery<T> of(String operator, TypedBaseQuery<T> ... queries) {
        switch (queries.length) {
            case 0: {
                throw new IllegalArgumentException("No queries are specified");
            }
            case 1: {
                return queries[0];
            }
        }
        return new MergedBaseQueryImpl<T>(((TypedBaseQueryImplementor)queries[0]).getSqlClient(), operator, queries, null);
    }

    @SafeVarargs
    public static <T extends BaseTable> TypedBaseQuery<T> of(TypedBaseQuery<T> query, RecursiveBaseQueryCreator<T> ... recursiveBaseQueryCreators) {
        if (recursiveBaseQueryCreators.length == 0) {
            return query;
        }
        return new MergedBaseQueryImpl<T>(((TypedBaseQueryImplementor)query).getSqlClient(), "union all", new TypedBaseQuery[]{query}, recursiveBaseQueryCreators);
    }

    private MergedBaseQueryImpl(JSqlClientImplementor sqlClient, String operator, TypedBaseQuery<T>[] queries, RecursiveBaseQueryCreator<T>[] recursiveBaseQueryCreators) {
        for (TypedBaseQuery<T> query : queries) {
            ((TypedBaseQueryImplementor)query).setMergedBy(this);
        }
        this.sqlClient = sqlClient;
        this.operator = operator;
        if (recursiveBaseQueryCreators != null) {
            if (recursiveBaseQueryCreators.length < 1) {
                throw new IllegalArgumentException("`recursiveBaseQueryCreators.length` must not be less than 2");
            }
            if (queries.length < 1) {
                throw new IllegalArgumentException("no start query for recursive CTE");
            }
        } else if (queries.length < 2) {
            throw new IllegalArgumentException("`queries.length` must not be less than 2");
        }
        TypedBaseQueryImplementor[] queryArr = new TypedBaseQueryImplementor[queries.length];
        queryArr[0] = (TypedBaseQueryImplementor)queries[0];
        for (int i = 1; i < queryArr.length; ++i) {
            queryArr[i] = (TypedBaseQueryImplementor)queries[i];
            MergedBaseQueryImpl.validateSelections(queryArr[0].getSelections(), queryArr[i].getSelections());
        }
        this.queries = queryArr;
        ArrayList realQueries = new ArrayList();
        MergedBaseQueryImpl.collectRealQueries(this, realQueries);
        this.expandedQueries = realQueries.toArray(EMPTY_QUERIES);
        this.recursive = recursiveBaseQueryCreators != null;
        this.recursiveBaseQueryCreators = recursiveBaseQueryCreators;
    }

    private void upgrade() {
        if (this.recursiveBaseQueryCreators == null) {
            return;
        }
        T baseTable = this.asBaseTable(null, true);
        int size = this.queries.length;
        TypedBaseQueryImplementor[] newQueryArr = new TypedBaseQueryImplementor[size + this.recursiveBaseQueryCreators.length];
        System.arraycopy(this.queries, 0, newQueryArr, 0, size);
        for (RecursiveBaseQueryCreator<T> creator : this.recursiveBaseQueryCreators) {
            TypedBaseQueryImplementor query = (TypedBaseQueryImplementor)creator.create(BaseTableSymbols.recursive(baseTable));
            MergedBaseQueryImpl.validateSelections(this.queries[0].getSelections(), query.getSelections());
            newQueryArr[size++] = query;
        }
        this.recursiveBaseQueryCreators = null;
        this.queries = newQueryArr;
        ArrayList realQueries = new ArrayList();
        MergedBaseQueryImpl.collectRealQueries(this, realQueries);
        this.expandedQueries = realQueries.toArray(EMPTY_QUERIES);
    }

    private static void validateSelections(List<Selection<?>> list1, List<Selection<?>> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        int size = list1.size();
        for (int index = 0; index < size; ++index) {
            if (MergedBaseQueryImpl.isSameType(list1.get(index), list2.get(index))) continue;
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof TableTypeProvider && b instanceof TableTypeProvider) {
            return ((TableTypeProvider)((Object)a)).getImmutableType() == ((TableTypeProvider)((Object)b)).getImmutableType();
        }
        if (a instanceof FetcherSelection && b instanceof FetcherSelection) {
            return ((FetcherSelection)a).getFetcher().equals(((FetcherSelection)b).getFetcher());
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.getAstContext().visitRecursiveQuery(this, () -> {
            for (ConfigurableBaseQueryImpl<T> query : this.getExpandedQueries()) {
                query.accept(visitor);
            }
        });
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.enter('?' + this.operator + '?');
        for (TypedBaseQueryImplementor<T> query : this.getQueries()) {
            builder.separator();
            query.renderTo(builder);
        }
        builder.leave();
    }

    @Override
    public boolean hasVirtualPredicate() {
        for (TypedBaseQueryImplementor<T> query : this.getQueries()) {
            if (!query.hasVirtualPredicate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        TypedBaseQueryImplementor<T>[] queries = this.getQueries();
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = ctx.resolveVirtualPredicate(queries[i]);
        }
        return this;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return ((BaseTableSymbol)this.baseTable).getSelections();
    }

    @Override
    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    public TypedBaseQueryImplementor<T>[] getQueries() {
        this.upgrade();
        return this.queries;
    }

    public ConfigurableBaseQueryImpl<T>[] getExpandedQueries() {
        this.upgrade();
        return this.expandedQueries;
    }

    public ConfigurableBaseQueryImpl<T> firstQuery() {
        return this.expandedQueries[0];
    }

    @Override
    public TableImplementor<?> resolveRootTable(Table<?> table) {
        for (TypedBaseQueryImplementor<T> query : this.getQueries()) {
            TableImplementor<?> tableImplementor;
            if (query instanceof MergedBaseQueryImpl) {
                tableImplementor = ((MergedBaseQueryImpl)query).getQueries()[0].resolveRootTable(table);
            } else {
                MutableBaseQueryImpl mutableQuery = ((ConfigurableBaseQueryImpl)query).getMutableQuery();
                TableImplementor<?> tableImplementor2 = tableImplementor = AbstractTypedTable.__refEquals(mutableQuery.getTable(), table) ? (TableImplementor<?>)mutableQuery.getTableLikeImplementor() : null;
            }
            if (tableImplementor == null) continue;
            return tableImplementor;
        }
        return null;
    }

    @Override
    public MergedBaseQueryImpl<T> getMergedBy() {
        return this.mergedBy;
    }

    @Override
    public void setMergedBy(MergedBaseQueryImpl<T> mergedBy) {
        if (this.baseTable != null) {
            throw new IllegalStateException("The base query cannot be merged after its `asBaseTable` is called");
        }
        if (this.mergedBy != null && this.mergedBy != mergedBy) {
            throw new IllegalArgumentException("This current base-query has been merged by another merged base query");
        }
        this.mergedBy = mergedBy;
    }

    @Override
    public T asBaseTable() {
        return this.asBaseTable(null, false);
    }

    @Override
    public T asCteBaseTable() {
        return this.asBaseTable(null, true);
    }

    @Override
    public T asBaseTable(byte[] kotlinSelectionTypes, boolean cte) {
        if (!cte && this.recursive) {
            throw new IllegalArgumentException("Recursive base query only be treated as cteBaseTable, not general baseTable");
        }
        T baseTable = this.baseTable;
        if (baseTable != null) {
            return AbstractBaseTableSymbol.validateCte(baseTable, cte);
        }
        baseTable = this.mergedBy != null ? this.mergedBy.asBaseTable(kotlinSelectionTypes, cte) : BaseTableSymbols.of(this, this.expandedQueries[0].getSelections(), kotlinSelectionTypes, this.recursive ? BaseTableKind.RECURSIVE_CTE : (cte ? BaseTableKind.CTE : BaseTableKind.DERIVED));
        this.baseTable = baseTable;
        return baseTable;
    }

    private static void collectRealQueries(TypedBaseQueryImplementor<?> query, List<ConfigurableBaseQueryImpl<?>> results) {
        if (query instanceof ConfigurableBaseQuery) {
            results.add((ConfigurableBaseQueryImpl)query);
        } else {
            MergedBaseQueryImpl mq = (MergedBaseQueryImpl)query;
            for (TypedBaseQueryImplementor sq : mq.getQueries()) {
                MergedBaseQueryImpl.collectRealQueries(sq, results);
            }
        }
    }

    public static MergedBaseQueryImpl<?> from(TypedBaseQueryImplementor<?> query) {
        return MergedBaseQueryImpl.from0(query, null);
    }

    private static MergedBaseQueryImpl<?> from0(TypedBaseQueryImplementor<?> query, MergedBaseQueryImpl<?> prevMergedBy) {
        MergedBaseQueryImpl<?> mergedBy = query.getMergedBy();
        if (mergedBy == null) {
            return prevMergedBy;
        }
        return MergedBaseQueryImpl.from0(mergedBy, mergedBy);
    }
}

