/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExistsPredicate;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.SubQueryFunctionExpression;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableTypeProvider;
import org.babyfish.jimmer.sql.ast.query.ConfigurableSubQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableSubQueryImpl<R>
extends AbstractConfigurableTypedQueryImpl
implements ConfigurableSubQuery<R>,
ExpressionImplementor<R> {
    private final Class<R> type;

    ConfigurableSubQueryImpl(TypedQueryData data, MutableSubQueryImpl baseQuery) {
        super(data, baseQuery);
        List<Selection<?>> selections = data.selections;
        switch (selections.size()) {
            case 1: {
                Selection<?> selection = selections.get(0);
                if (selection instanceof TableTypeProvider) {
                    this.type = ((TableTypeProvider)((Object)selection)).getImmutableType().getJavaClass();
                    break;
                }
                this.type = ((ExpressionImplementor)selection).getType();
                break;
            }
            case 2: {
                this.type = Tuple2.class;
                break;
            }
            case 3: {
                this.type = Tuple3.class;
                break;
            }
            case 4: {
                this.type = Tuple4.class;
                break;
            }
            case 5: {
                this.type = Tuple5.class;
                break;
            }
            case 6: {
                this.type = Tuple6.class;
                break;
            }
            case 7: {
                this.type = Tuple7.class;
                break;
            }
            case 8: {
                this.type = Tuple8.class;
                break;
            }
            case 9: {
                this.type = Tuple9.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("selection count must between 1 and 9");
            }
        }
    }

    static <R> TypedSubQuery<R> of(TypedQueryData data, MutableSubQueryImpl baseQuery) {
        Selection<?> selection;
        if (data.selections.size() == 1 && (selection = data.selections.get(0)) instanceof ExpressionImplementor) {
            Class type = ((ExpressionImplementor)selection).getType();
            if (type == String.class) {
                return new Str(data, baseQuery);
            }
            if (ConfigurableSubQueryImpl.isPrimitiveNumberType(type)) {
                return new Num(data, baseQuery);
            }
            if (Number.class.isAssignableFrom(type)) {
                return new Num(data, baseQuery);
            }
            if (Date.class.isAssignableFrom(type)) {
                return new Dt(data, baseQuery);
            }
            if (Temporal.class.isAssignableFrom(type)) {
                return new Tp(data, baseQuery);
            }
            if (Comparable.class.isAssignableFrom(type)) {
                return new Cmp(data, baseQuery);
            }
        }
        return new ConfigurableSubQueryImpl<R>(data, baseQuery);
    }

    private static boolean isPrimitiveNumberType(Class<?> type) {
        return type.isPrimitive() && type != Boolean.TYPE && type != Character.TYPE;
    }

    @Override
    public Class<R> getType() {
        return this.type;
    }

    @Override
    public MutableSubQueryImpl getMutableQuery() {
        return (MutableSubQueryImpl)super.getMutableQuery();
    }

    @Override
    public ConfigurableSubQuery<R> limit(int limit) {
        return this.limitImpl(limit, null);
    }

    @Override
    public ConfigurableSubQuery<R> offset(long offset) {
        return this.limitImpl(null, offset);
    }

    @Override
    public ConfigurableSubQuery<R> limit(int limit, long offset) {
        return this.limitImpl(limit, offset);
    }

    private ConfigurableSubQuery<R> limitImpl(@Nullable Integer limit, @Nullable Long offset) {
        TypedQueryData data = this.getData();
        if (limit == null) {
            limit = data.limit;
        }
        if (offset == null) {
            offset = data.offset;
        }
        if (data.limit == limit && data.offset == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        return (ConfigurableSubQuery)ConfigurableSubQueryImpl.of(data.limit(limit, offset), this.getMutableQuery());
    }

    @Override
    public ConfigurableSubQuery<R> distinct() {
        TypedQueryData data = this.getData();
        if (data.distinct) {
            return this;
        }
        return new ConfigurableSubQueryImpl<R>(data.distinct(), this.getMutableQuery());
    }

    @Override
    public ConfigurableSubQuery<R> hint(@Nullable String hint) {
        TypedQueryData data = this.getData();
        return (ConfigurableSubQuery)ConfigurableSubQueryImpl.of(data.hint(hint), this.getMutableQuery());
    }

    @Override
    public Expression<R> all() {
        return new SubQueryFunctionExpression.All(this);
    }

    @Override
    public Expression<R> any() {
        return new SubQueryFunctionExpression.Any(this);
    }

    @Override
    public Predicate exists() {
        return ExistsPredicate.of(this, false);
    }

    @Override
    public Predicate notExists() {
        return ExistsPredicate.of(this, true);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.getMutableQuery().setParent(visitor.getAstContext().getStatement());
        if (visitor.visitSubQuery(this)) {
            super.accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        super.renderTo(builder);
        builder.leave();
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public boolean hasVirtualPredicate() {
        return this.getMutableQuery().hasVirtualPredicate();
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        this.getMutableQuery().resolveVirtualPredicate(ctx);
        return this;
    }

    private static class Str
    extends ConfigurableSubQueryImpl<String>
    implements ConfigurableSubQuery.Str,
    StringExpressionImplementor {
        Str(TypedQueryData data, MutableSubQueryImpl baseQuery) {
            super(data, baseQuery);
        }
    }

    private static class Num<N extends Number>
    extends ConfigurableSubQueryImpl<N>
    implements ConfigurableSubQuery.Num<N>,
    NumericExpressionImplementor<N> {
        Num(TypedQueryData data, MutableSubQueryImpl baseQuery) {
            super(data, baseQuery);
        }
    }

    private static class Dt<T extends Date>
    extends ConfigurableSubQueryImpl<T>
    implements ConfigurableSubQuery.Dt<T>,
    DateExpressionImplementor<T> {
        Dt(TypedQueryData data, MutableSubQueryImpl baseQuery) {
            super(data, baseQuery);
        }
    }

    private static class Tp<T extends Temporal & Comparable<?>>
    extends ConfigurableSubQueryImpl<T>
    implements ConfigurableSubQuery.Tp<T>,
    TemporalExpressionImplementor<T> {
        Tp(TypedQueryData data, MutableSubQueryImpl baseQuery) {
            super(data, baseQuery);
        }
    }

    private static class Cmp<T extends Comparable<?>>
    extends ConfigurableSubQueryImpl<T>
    implements ConfigurableSubQuery.Cmp<T>,
    ComparableExpressionImplementor<T> {
        Cmp(TypedQueryData data, MutableSubQueryImpl baseQuery) {
            super(data, baseQuery);
        }
    }
}

