/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractPreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;

class UpdatePreHandler
extends AbstractPreHandler {
    private ShapedEntityMap<DraftSpi> updatedMap;

    UpdatePreHandler(SaveContext ctx) {
        super(ctx);
    }

    @Override
    public ShapedEntityMap<DraftSpi> updatedMap() {
        this.resolve();
        return this.updatedMap;
    }

    @Override
    void onResolve() {
        DraftSpi draft;
        Iterator itr;
        QueryReason queryReason;
        ArrayList<DraftInterceptor.Item<Object, DraftSpi>> items = new ArrayList<DraftInterceptor.Item<Object, DraftSpi>>(this.draftsWithId.size() + this.draftsWithKey.size());
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        if (!this.draftsWithId.isEmpty() && (queryReason = this.queryReason(true, this.draftsWithId)) != QueryReason.NONE) {
            Map<Object, ImmutableSpi> idMap = this.findOldMapByIds(queryReason);
            itr = this.draftsWithId.iterator();
            while (itr.hasNext()) {
                draft = (DraftSpi)itr.next();
                Object id = draft.__get(idPropId);
                ImmutableSpi original = idMap.get(id);
                if (original != null) {
                    items.add(this.newItem(draft, original));
                    continue;
                }
                itr.remove();
            }
        }
        if (!this.draftsWithKey.isEmpty() && (queryReason = this.queryReason(false, this.draftsWithKey)) != QueryReason.NONE) {
            Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> keyMap = this.findOldMapByKeys(queryReason);
            itr = this.draftsWithKey.iterator();
            while (itr.hasNext()) {
                draft = (DraftSpi)itr.next();
                KeyMatcher.Group group = this.keyMatcher.match((Object)draft);
                assert (group != null);
                Object key = Keys.keyOf((ImmutableSpi)draft, group.getProps());
                Map subMap = keyMap.getOrDefault(group, Collections.emptyMap());
                ImmutableSpi original = (ImmutableSpi)subMap.get(key);
                if (original != null) {
                    items.add(this.newItem(draft, original));
                    draft.__set(idPropId, original.__get(idPropId));
                    continue;
                }
                itr.remove();
            }
        }
        this.callInterceptor(items);
        this.updatedMap = this.createEntityMap(null, this.draftsWithId, this.draftsWithKey, SaveMode.UPDATE_ONLY, null);
    }
}

