/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Arrays;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.TargetTransferMode;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.UnloadedVersionBehavior;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.DtoMetadata;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class SimpleEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements SimpleEntitySaveCommand<E> {
    public SimpleEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, E entity) {
        super(SimpleEntitySaveCommandImpl.initialCfg(sqlClient, con, entity));
    }

    private SimpleEntitySaveCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    private static AbstractCommandImpl.Cfg initialCfg(JSqlClientImplementor sqlClient, Connection con, Object entity) {
        if (!(entity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("entity must be an immutable object");
        }
        if (!((ImmutableSpi)entity).__type().isEntity()) {
            throw new IllegalArgumentException("the object is not instance of entity class");
        }
        if (entity instanceof DraftSpi) {
            throw new IllegalArgumentException("entity cannot be a draft object");
        }
        AbstractCommandImpl.Cfg cfg = new AbstractCommandImpl.RootCfg(sqlClient, entity);
        if (con != null) {
            cfg = new AbstractCommandImpl.ConnectionCfg(cfg, con);
        }
        return cfg;
    }

    @Override
    public SimpleEntitySaveCommand<E> setMode(SaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAssociatedModeAll(AssociatedSaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAssociatedMode(ImmutableProp prop, AssociatedSaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, prop, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setKeyProps(String group, ImmutableProp ... props) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyGroupsCfg(this.cfg, group, Arrays.asList(props)));
    }

    @Override
    public SimpleEntitySaveCommand<E> setUpsertMask(UpsertMask<?> mask) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.UpsertMaskCfg(this.cfg, mask));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAutoIdOnlyTargetCheckingAll() {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, true));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAutoIdOnlyTargetChecking(ImmutableProp prop, boolean checking) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, prop, checking));
    }

    @Override
    public SimpleEntitySaveCommand<E> setIdOnlyAsReferenceAll(boolean asReference) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAsReferenceCfg(this.cfg, asReference));
    }

    @Override
    public SimpleEntitySaveCommand<E> setIdOnlyAsReference(ImmutableProp prop, boolean asReference) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAsReferenceCfg(this.cfg, prop, asReference));
    }

    @Override
    public SimpleEntitySaveCommand<E> setKeyOnlyAsReferenceAll() {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyOnlyAsReferenceCfg(this.cfg, true));
    }

    @Override
    public SimpleEntitySaveCommand<E> setKeyOnlyAsReference(ImmutableProp prop, boolean asReference) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyOnlyAsReferenceCfg(this.cfg, prop, asReference));
    }

    @Override
    public SimpleEntitySaveCommand<E> setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.DissociationActionCfg(this.cfg, prop, dissociateAction));
    }

    @Override
    public SimpleEntitySaveCommand<E> setTargetTransferMode(ImmutableProp prop, TargetTransferMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, prop, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setTargetTransferModeAll(TargetTransferMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setPessimisticLock(Class<?> entityType, boolean lock) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.PessimisticLockCfg(this.cfg, entityType, lock));
    }

    @Override
    public SimpleEntitySaveCommand<E> setPessimisticLockAll() {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.PessimisticLockCfg(this.cfg, true));
    }

    @Override
    public <T extends Table<E>> SimpleEntitySaveCommand<E> setOptimisticLock(Class<T> tableType, UnloadedVersionBehavior behavior, UserOptimisticLock<E, T> block) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, ImmutableType.get(tableType), behavior, block));
    }

    @Override
    public SimpleEntitySaveCommand<E> setEntityOptimisticLock(ImmutableType type, UnloadedVersionBehavior behavior, UserOptimisticLock<Object, Table<Object>> block) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, type, behavior, block));
    }

    @Override
    public SimpleEntitySaveCommand<E> setDeleteMode(DeleteMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.DeleteModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setMaxCommandJoinCount(int count) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.MaxCommandJoinCountCfg(this.cfg, count));
    }

    @Override
    public SimpleEntitySaveCommand<E> setDumbBatchAcceptable(boolean acceptable) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.DumbBatchAcceptableCfg(this.cfg, acceptable));
    }

    @Override
    public SimpleEntitySaveCommand<E> setConstraintViolationTranslatable(boolean transferable) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.ConstraintViolationTranslatableCfg(this.cfg, transferable));
    }

    @Override
    public SimpleEntitySaveCommand<E> addExceptionTranslator(ExceptionTranslator<?> translator) {
        if (translator == null) {
            return this;
        }
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ExceptionTranslatorCfg(this.cfg, translator));
    }

    @Override
    public SimpleEntitySaveCommand<E> setTransactionRequired(boolean required) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.TransactionRequiredCfg(this.cfg, required));
    }

    @Override
    public SimpleSaveResult<E> execute(Connection con, Fetcher<E> fetcher) {
        SaveOptions options = (SaveOptions)this.options();
        return options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, (Connection c) -> this.executeImpl((Connection)c, fetcher));
    }

    @Override
    public <V extends View<E>> SimpleSaveResult.View<E, V> execute(Connection con, Class<V> viewType) {
        SaveOptions options = (SaveOptions)this.options();
        DtoMetadata metadata = DtoMetadata.of(viewType);
        SimpleSaveResult result = options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, (Connection c) -> this.executeImpl((Connection)c, metadata.getFetcher()));
        return result.toView(metadata.getConverter());
    }

    private SimpleSaveResult<E> executeImpl(Connection con, Fetcher<E> fetcher) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        if (options.isTransactionRequired()) {
            Executor.validateMutationConnection(con);
        }
        ImmutableSpi entity = (ImmutableSpi)options.getArument();
        Saver saver = new Saver(options, con, entity.__type(), fetcher);
        return saver.save(entity);
    }
}

