/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.exception.CircularDeletionException;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.jetbrains.annotations.NotNull;

class DeleteContext
extends MutationContext {
    final DeleteContext parent;
    final DeleteOptions options;
    final Connection con;
    final MutationTrigger trigger;
    final Map<AffectedTable, Integer> affectedRowCountMap;
    final ImmutableProp backProp;
    private Boolean logicalDeleted;
    private final Map<ImmutableType, Set<Object>> idMutliMap;

    DeleteContext(DeleteOptions options, Connection con, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap, MutationPath path) {
        super(path);
        ImmutableProp mappedBy;
        ImmutableProp immutableProp = mappedBy = path.getProp() != null ? path.getProp().getMappedBy() : null;
        if (mappedBy != null && !mappedBy.isColumnDefinition()) {
            throw new IllegalArgumentException("The property \"" + path.getProp() + "\" does not reference child table");
        }
        this.parent = null;
        this.options = options;
        this.con = con;
        this.trigger = trigger;
        this.affectedRowCountMap = affectedRowCountMap;
        this.backProp = mappedBy;
        this.idMutliMap = new HashMap<ImmutableType, Set<Object>>();
    }

    private DeleteContext(DeleteContext parent, ImmutableProp prop, ImmutableProp backProp) {
        super(prop != null ? parent.path.to(prop) : parent.path.backFrom(backProp));
        if (prop != null) {
            if (!prop.isAssociation(TargetLevel.ENTITY) || !prop.isColumnDefinition() && !prop.isMiddleTableDefinition()) {
                throw new IllegalArgumentException("The property \"" + prop + "\" is not association property with column defined or middle table");
            }
        } else if (!backProp.isAssociation(TargetLevel.ENTITY) || !backProp.isColumnDefinition() && !backProp.isMiddleTableDefinition()) {
            throw new IllegalArgumentException("The back property \"" + backProp + "\" is not association property with column defined or middle table");
        }
        this.parent = parent;
        this.options = parent.options;
        this.con = parent.con;
        this.trigger = parent.trigger;
        this.affectedRowCountMap = parent.affectedRowCountMap;
        this.backProp = prop != null ? null : backProp;
        this.idMutliMap = parent.idMutliMap;
    }

    DeleteContext propOf(ImmutableProp prop) {
        if (prop.getMappedBy() != null) {
            return new DeleteContext(this, null, prop.getMappedBy());
        }
        return new DeleteContext(this, prop, null);
    }

    DeleteContext backPropOf(ImmutableProp backProp) {
        if (backProp.getMappedBy() != null) {
            return new DeleteContext(this, backProp.getMappedBy(), null);
        }
        return new DeleteContext(this, null, backProp);
    }

    boolean isLogicalDeleted() {
        Boolean ld = this.logicalDeleted;
        if (ld == null) {
            LogicalDeletedInfo info = this.path.getType().getLogicalDeletedInfo();
            switch (this.options.getMode()) {
                case LOGICAL: {
                    if (info == null) {
                        throw new IllegalArgumentException("Cannot logically delete the object whose type is \"" + this.path.getType() + "\" because that type does not support logical deletion");
                    }
                    ld = true;
                    break;
                }
                case PHYSICAL: {
                    ld = false;
                    break;
                }
                default: {
                    ld = info != null;
                }
            }
            this.logicalDeleted = ld;
        }
        return ld;
    }

    @NotNull
    public DeleteOptions getOptions() {
        return this.options;
    }

    void addDisconnectedId(Object id) {
        Set ids = this.idMutliMap.computeIfAbsent(this.path.getType(), it -> new HashSet());
        if (!ids.add(id)) {
            throw new CircularDeletionException(this.path, id);
        }
    }
}

