/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.base;

import java.time.temporal.Temporal;
import java.util.Date;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.TemporalExpression;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableExpression;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;

public class BaseTableSelections {
    private BaseTableSelections() {
    }

    public static <T extends Selection<?>> T of(T selection, BaseTable baseTable, int index) {
        if (selection instanceof TableProxy) {
            return (T)BaseTableSelections.of((TableProxy)selection, baseTable, index);
        }
        if (selection instanceof TableImplementor) {
            return (T)BaseTableSelections.of((TableImplementor)selection, baseTable, index);
        }
        if (selection instanceof Expression) {
            return (T)BaseTableSelections.of((Expression)selection, baseTable, index);
        }
        throw new IllegalArgumentException("base query can only select table or expression");
    }

    public static <T extends TableProxy<?>> T of(T table, BaseTable baseTable, int index) {
        return (T)table.__baseTableOwner(new BaseTableOwner(baseTable, index));
    }

    public static TableImplementor<?> of(TableImplementor<?> table, BaseTable baseTable, int index) {
        return table.baseTableOwner(new BaseTableOwner(baseTable, index));
    }

    public static <T> Expression<T> of(Expression<T> expr, BaseTable baseTable, int index) {
        if (expr instanceof ComparableExpression) {
            return BaseTableSelections.of((ComparableExpression)expr, baseTable, index);
        }
        return new BaseTableExpression((ExpressionImplementor)expr, new BaseTableOwner(baseTable, index));
    }

    public static <T extends Comparable<?>> ComparableExpression<T> of(ComparableExpression<T> expr, BaseTable baseTable, int index) {
        BaseTableOwner owner = new BaseTableOwner(baseTable, index);
        if (expr instanceof StringExpression) {
            return new BaseTableExpression.Str((StringExpressionImplementor)expr, owner);
        }
        if (expr instanceof NumericExpression) {
            return new BaseTableExpression.Num((NumericExpressionImplementor)expr, owner);
        }
        if (expr instanceof DateExpression) {
            return new BaseTableExpression.Dt((DateExpressionImplementor)expr, owner);
        }
        if (expr instanceof TemporalExpression) {
            return new BaseTableExpression.Tp((TemporalExpressionImplementor)expr, owner);
        }
        return new BaseTableExpression.Cmp((ComparableExpressionImplementor)expr, owner);
    }

    public static StringExpression of(StringExpression expr, BaseTable baseTable, int index) {
        BaseTableOwner owner = new BaseTableOwner(baseTable, index);
        return new BaseTableExpression.Str((StringExpressionImplementor)expr, owner);
    }

    public static <N extends Number> NumericExpression<N> of(NumericExpression<N> expr, BaseTable baseTable, int index) {
        BaseTableOwner owner = new BaseTableOwner(baseTable, index);
        return new BaseTableExpression.Num((NumericExpressionImplementor)expr, owner);
    }

    public static <T extends Date> DateExpression<T> of(DateExpression<T> expr, BaseTable baseTable, int index) {
        BaseTableOwner owner = new BaseTableOwner(baseTable, index);
        return new BaseTableExpression.Dt((DateExpressionImplementor)expr, owner);
    }

    public static <T extends Temporal & Comparable<?>> TemporalExpression<T> of(TemporalExpression<T> expr, BaseTable baseTable, int index) {
        BaseTableOwner owner = new BaseTableOwner(baseTable, index);
        return new BaseTableExpression.Tp((TemporalExpressionImplementor)expr, owner);
    }
}

