/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.base.BaseQueryScope;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;

public class BaseSelectionMapper {
    private final BaseQueryScope scope;
    private final RealTable realBaseTable;
    private final int selectionIndex;
    final Map<QualifiedColumn, Integer> columnIndexMap = new LinkedHashMap<QualifiedColumn, Integer>();
    int expressionIndex;

    public BaseSelectionMapper(BaseQueryScope scope, RealTable realBaseTable, int selectionIndex) {
        this.scope = scope;
        this.realBaseTable = realBaseTable;
        this.selectionIndex = selectionIndex;
    }

    public String getAlias() {
        return this.realBaseTable.getAlias();
    }

    public int columnIndex(String alias, String columnName) {
        AstContext ctx = this.scope.astContext;
        Selection<?> selection = ((BaseTableImplementor)this.realBaseTable.getTableLikeImplementor()).getSelections().get(this.selectionIndex);
        RealTable realTable = TableProxies.resolve((Table)selection, ctx).realTable(ctx);
        List<RealTable.Key> keys = this.keys(realTable, alias);
        return this.columnIndexMap.computeIfAbsent(new QualifiedColumn(keys, columnName), it -> this.scope.colNo());
    }

    public int formulaIndex(String alias, FormulaTemplate formula) {
        AstContext ctx = this.scope.astContext;
        Selection<?> selection = ((BaseTableImplementor)this.realBaseTable.getTableLikeImplementor()).getSelections().get(this.selectionIndex);
        RealTable realTable = TableProxies.resolve((Table)selection, ctx).realTable(ctx);
        List<RealTable.Key> keys = this.keys(realTable, alias);
        return this.columnIndexMap.computeIfAbsent(new QualifiedColumn(keys, formula), it -> this.scope.colNo());
    }

    public int expressionIndex() {
        if (this.expressionIndex == 0) {
            this.expressionIndex = this.scope.colNo();
        }
        return this.expressionIndex;
    }

    private List<RealTable.Key> keys(RealTable table, String alias) {
        ArrayList<RealTable.Key> keys = new ArrayList<RealTable.Key>();
        this.keys0(table, alias, keys);
        return keys;
    }

    private void keys0(RealTable table, String alias, List<RealTable.Key> keys) {
        if (table.getAlias().equals(alias)) {
            return;
        }
        RealTable realTable = table.getTableLikeImplementor().realTable(this.scope.astContext.getJoinTypeMergeScope());
        for (RealTable childTable : realTable) {
            keys.add(childTable.getKey());
            this.keys0(childTable, alias, keys);
        }
    }

    static class QualifiedColumn {
        final List<RealTable.Key> keys;
        final String name;
        final FormulaTemplate formula;

        QualifiedColumn(List<RealTable.Key> keys, String name) {
            this.keys = keys;
            this.name = name;
            this.formula = null;
        }

        QualifiedColumn(List<RealTable.Key> keys, FormulaTemplate formula) {
            this.keys = keys;
            this.name = null;
            this.formula = formula;
        }

        public int hashCode() {
            int result = this.keys.hashCode();
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.formula);
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QualifiedColumn that = (QualifiedColumn)o;
            return this.keys.equals(that.keys) && Objects.equals(this.name, that.name) && Objects.equals(this.formula, that.formula);
        }

        public String toString() {
            return "QualifiedColumn{keys=" + this.keys + ", name='" + this.name + '\'' + ", formula=" + this.formula + '}';
        }
    }
}

