/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class RightExpression
extends AbstractExpression<String>
implements StringExpressionImplementor {
    private Expression<String> raw;
    private Expression<Integer> length;

    RightExpression(Expression<String> raw, Expression<Integer> length) {
        this.raw = raw;
        this.length = length;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.raw)).accept(visitor);
        ((Ast)((Object)this.length)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sqlClient().getDialect().renderRight(builder, this.precedence(), (Ast)((Object)this.raw), (Ast)((Object)this.length));
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return RightExpression.hasVirtualPredicate(this.raw) || RightExpression.hasVirtualPredicate(this.length);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.raw = ctx.resolveVirtualPredicate(this.raw);
        this.length = ctx.resolveVirtualPredicate(this.length);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RightExpression that = (RightExpression)o;
        return this.raw.equals(that.raw) && this.length.equals(that.length);
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.length);
    }
}

