/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.jetbrains.annotations.NotNull;

public class InExpressionCollectionPredicate
extends AbstractPredicate {
    private final boolean negative;
    private Expression<?> expression;
    private Collection<Expression<?>> operands;

    public InExpressionCollectionPredicate(boolean negative, Expression<?> expression, Collection<Expression<?>> operands) {
        this.negative = negative;
        this.expression = expression;
        this.operands = operands;
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return InExpressionCollectionPredicate.hasVirtualPredicate(this.expression) || InExpressionCollectionPredicate.hasVirtualPredicate(this.operands);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        ArrayList newOperands = new ArrayList(this.operands.size());
        for (Expression<?> operand : this.operands) {
            newOperands.add(ctx.resolveVirtualPredicate(operand));
        }
        this.operands = newOperands;
        return this;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
        for (Expression<?> operand : this.operands) {
            ((Ast)((Object)operand)).accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        ComparisonPredicates.renderExpressionIn(this.negative, this.expression, this.operands, builder);
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Predicate not() {
        return new InExpressionCollectionPredicate(!this.negative, this.expression, this.operands);
    }
}

