/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Date;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class DataPlusExpression<T extends Date>
extends AbstractExpression<T>
implements DateExpressionImplementor<T> {
    private DateExpression<T> raw;
    private Expression<Long> value;
    private final SqlTimeUnit timeUnit;

    DataPlusExpression(DateExpression<T> raw, Expression<Long> value, SqlTimeUnit timeUnit) {
        this.raw = raw;
        this.value = value;
        this.timeUnit = timeUnit;
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return DataPlusExpression.hasVirtualPredicate(this.raw) || DataPlusExpression.hasVirtualPredicate(this.value);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.raw = ctx.resolveVirtualPredicate(this.raw);
        this.value = ctx.resolveVirtualPredicate(this.value);
        return this;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.raw)).accept(visitor);
        ((Ast)((Object)this.value)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sqlClient().getDialect().renderTimePlus(builder, this.precedence(), (Ast)((Object)this.raw), (Ast)((Object)this.value), this.timeUnit);
    }

    @Override
    public Class<T> getType() {
        return ((ExpressionImplementor)((Object)this.raw)).getType();
    }

    @Override
    public int precedence() {
        return 0;
    }
}

