/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.NativeBuilder;
import org.babyfish.jimmer.sql.ast.NativeContext;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.TemporalExpression;
import org.babyfish.jimmer.sql.ast.impl.CaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.Constants;
import org.babyfish.jimmer.sql.ast.impl.ExpressionFactories;
import org.babyfish.jimmer.sql.ast.impl.InExpressionCollectionPredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NullExpression;
import org.babyfish.jimmer.sql.ast.impl.SimpleCaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.Tuples;
import org.babyfish.jimmer.sql.ast.impl.util.RowCounts;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Expression<T>
extends Selection<T> {
    @NotNull
    public Predicate eq(Expression<T> var1);

    @NotNull
    public Predicate eq(@Nullable T var1);

    @Nullable
    default public Predicate eqIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.eq(other) : null;
    }

    @Nullable
    default public Predicate eqIf(@Nullable T other) {
        return this.eqIf(true, other);
    }

    @NotNull
    public Predicate ne(Expression<T> var1);

    @NotNull
    public Predicate ne(@Nullable T var1);

    @Nullable
    default public Predicate neIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.ne(other) : null;
    }

    @Nullable
    default public Predicate neIf(@Nullable T other) {
        return this.neIf(true, other);
    }

    @NotNull
    public Predicate isNull();

    @NotNull
    public Predicate isNotNull();

    @NotNull
    public Predicate in(Collection<T> var1);

    @NotNull
    public Predicate nullableIn(Collection<T> var1);

    @Nullable
    default public Predicate inIf(boolean condition, @Nullable Collection<T> values) {
        return condition && values != null ? this.in(values) : null;
    }

    @Nullable
    default public Predicate inIf(@Nullable Collection<T> values) {
        return this.inIf(true, values);
    }

    @Nullable
    default public Predicate nullableInIf(boolean condition, @Nullable Collection<T> values) {
        return condition && values != null ? this.nullableIn(values) : null;
    }

    @Nullable
    default public Predicate nullableInIf(@Nullable Collection<T> values) {
        return this.nullableInIf(true, values);
    }

    @NotNull
    public Predicate notIn(Collection<T> var1);

    @NotNull
    public Predicate nullableNotIn(Collection<T> var1);

    @Nullable
    default public Predicate notInIf(boolean condition, @Nullable Collection<T> values) {
        return condition && values != null ? this.notIn(values) : null;
    }

    @Nullable
    default public Predicate notInIf(@Nullable Collection<T> values) {
        return this.notInIf(true, values);
    }

    @Nullable
    default public Predicate nullableNotInIf(boolean condition, @Nullable Collection<T> values) {
        return condition && values != null ? this.nullableNotIn(values) : null;
    }

    @Nullable
    default public Predicate nullableNotInIf(@Nullable Collection<T> values) {
        return this.nullableNotInIf(true, values);
    }

    @NotNull
    public Predicate in(TypedSubQuery<T> var1);

    @Nullable
    default public Predicate inIf(boolean condition, @Nullable TypedSubQuery<T> subQuery) {
        return condition && subQuery != null ? this.in(subQuery) : null;
    }

    @Nullable
    default public Predicate inIf(@Nullable TypedSubQuery<T> subQuery) {
        return this.inIf(true, subQuery);
    }

    @NotNull
    public Predicate notIn(TypedSubQuery<T> var1);

    @Nullable
    default public Predicate notInIf(boolean condition, @Nullable TypedSubQuery<T> subQuery) {
        return condition && subQuery != null ? this.notIn(subQuery) : null;
    }

    @Nullable
    default public Predicate notInIf(@Nullable TypedSubQuery<T> subQuery) {
        return this.notInIf(true, subQuery);
    }

    default public Predicate expressionIn(Collection<Expression<T>> operands) {
        return new InExpressionCollectionPredicate(false, this, operands);
    }

    default public Predicate expressionNotIn(Collection<Expression<T>> operands) {
        return new InExpressionCollectionPredicate(true, this, operands);
    }

    @NotNull
    public NumericExpression<Long> count();

    @NotNull
    public NumericExpression<Long> count(boolean var1);

    @NotNull
    public Expression<T> coalesce(T var1);

    @NotNull
    public Expression<T> coalesce(Expression<T> var1);

    @NotNull
    public CoalesceBuilder<T> coalesceBuilder();

    @NotNull
    public Order asc();

    @NotNull
    public Order desc();

    @NotNull
    public static <N extends Number> NumericExpression<N> constant(N value) {
        return Constants.number(value);
    }

    @NotNull
    public static StringExpression constant(String value) {
        return Constants.string(value);
    }

    @NotNull
    public static NumericExpression<Long> rowCount() {
        return RowCounts.INSTANCE;
    }

    @NotNull
    public static StringFactory string() {
        return ExpressionFactories.of(StringFactory.class);
    }

    @NotNull
    public static NumericFactory numeric() {
        return ExpressionFactories.of(NumericFactory.class);
    }

    @NotNull
    public static ComparableFactory comparable() {
        return ExpressionFactories.of(ComparableFactory.class);
    }

    public static DateFactory date() {
        return ExpressionFactories.of(DateFactory.class);
    }

    public static TemporalFactory temporal() {
        return ExpressionFactories.of(TemporalFactory.class);
    }

    @NotNull
    public static AnyFactory any() {
        return ExpressionFactories.of(AnyFactory.class);
    }

    public static StringExpression value(String value) {
        return Literals.string(value);
    }

    public static <N extends Number> NumericExpression<N> value(N value) {
        return Literals.number(value);
    }

    @NotNull
    public static <T extends Date> DateExpression<T> value(@NotNull T value) {
        return Literals.date(value);
    }

    @NotNull
    public static <T extends Temporal & Comparable<?>> TemporalExpression<T> value(@NotNull T value) {
        return Literals.temporal(value);
    }

    public static <T extends Comparable<?>> ComparableExpression<T> value(T value) {
        return Literals.comparable(value);
    }

    public static <T> Expression<T> value(T value) {
        return Literals.any(value);
    }

    @NotNull
    public static <T> Expression<T> nullValue(Class<T> type) {
        return new NullExpression<T>(type);
    }

    @NotNull
    public static <T1, T2> Expression<Tuple2<T1, T2>> tuple(Expression<T1> expr1, Expression<T2> expr2) {
        return new Tuples.Expr2<T1, T2>(expr1, expr2);
    }

    @NotNull
    public static <T1, T2, T3> Expression<Tuple3<T1, T2, T3>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3) {
        return new Tuples.Expr3<T1, T2, T3>(expr1, expr2, expr3);
    }

    @NotNull
    public static <T1, T2, T3, T4> Expression<Tuple4<T1, T2, T3, T4>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4) {
        return new Tuples.Expr4<T1, T2, T3, T4>(expr1, expr2, expr3, expr4);
    }

    @NotNull
    public static <T1, T2, T3, T4, T5> Expression<Tuple5<T1, T2, T3, T4, T5>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5) {
        return new Tuples.Expr5<T1, T2, T3, T4, T5>(expr1, expr2, expr3, expr4, expr5);
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6> Expression<Tuple6<T1, T2, T3, T4, T5, T6>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6) {
        return new Tuples.Expr6<T1, T2, T3, T4, T5, T6>(expr1, expr2, expr3, expr4, expr5, expr6);
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7> Expression<Tuple7<T1, T2, T3, T4, T5, T6, T7>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7) {
        return new Tuples.Expr7<T1, T2, T3, T4, T5, T6, T7>(expr1, expr2, expr3, expr4, expr5, expr6, expr7);
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8> Expression<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7, Expression<T8> expr8) {
        return new Tuples.Expr8<T1, T2, T3, T4, T5, T6, T7, T8>(expr1, expr2, expr3, expr4, expr5, expr6, expr7, expr8);
    }

    @NotNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Expression<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7, Expression<T8> expr8, Expression<T9> expr9) {
        return new Tuples.Expr9<T1, T2, T3, T4, T5, T6, T7, T8, T9>(expr1, expr2, expr3, expr4, expr5, expr6, expr7, expr8, expr9);
    }

    public static interface StringFactory {
        @Deprecated
        @NotNull
        default public StringExpression value(String value) {
            return Expression.value(value);
        }

        @NotNull
        public NativeBuilder.Str sqlBuilder(String var1);

        default public StringExpression sql(String sql) {
            return this.sqlBuilder(sql).build();
        }

        default public StringExpression sql(String sql, Expression<?> ... expressions) {
            NativeBuilder.Str builder = this.sqlBuilder(sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public StringExpression sql(String sql, Consumer<NativeContext> block) {
            NativeBuilder.Str builder = this.sqlBuilder(sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C> SimpleCaseBuilder.Str<C> caseBuilder(C var1);

        @NotNull
        public <C> SimpleCaseBuilder.Str<C> caseBuilder(Expression<C> var1);

        @NotNull
        public CaseBuilder.Str caseBuilder();
    }

    public static interface NumericFactory {
        @Deprecated
        @NotNull
        default public <N extends Number> NumericExpression<N> value(N value) {
            return Expression.value(value);
        }

        @NotNull
        public <N extends Number> NativeBuilder.Num<N> sqlBuilder(Class<N> var1, String var2);

        default public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql) {
            return this.sqlBuilder(type, sql).build();
        }

        default public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql, Expression<?> ... expressions) {
            NativeBuilder.Num<N> builder = this.sqlBuilder(type, sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql, Consumer<NativeContext> block) {
            NativeBuilder.Num<N> builder = this.sqlBuilder(type, sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C, N extends Number> SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> var1, C var2);

        @NotNull
        public <C, N extends Number> SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> var1, Expression<C> var2);

        @NotNull
        public <N extends Number> CaseBuilder.Num<N> caseBuilder(Class<N> var1);
    }

    public static interface ComparableFactory {
        @Deprecated
        @NotNull
        default public <T extends Comparable<?>> ComparableExpression<T> value(T value) {
            return Expression.value(value);
        }

        @NotNull
        public <T extends Comparable<?>> NativeBuilder.Cmp<T> sqlBuilder(Class<T> var1, String var2);

        default public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql) {
            return this.sqlBuilder(type, sql).build();
        }

        default public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Expression<?> ... expressions) {
            NativeBuilder.Cmp<T> builder = this.sqlBuilder(type, sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Consumer<NativeContext> block) {
            NativeBuilder.Cmp<T> builder = this.sqlBuilder(type, sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C, T extends Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, C var2);

        @NotNull
        public <C, T extends Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        @NotNull
        public <T extends Comparable<?>> CaseBuilder.Cmp<T> caseBuilder(Class<T> var1);
    }

    public static interface DateFactory {
        @Deprecated
        default public <T extends Date> DateExpression<T> value(T value) {
            return Expression.value(value);
        }

        @NotNull
        public <T extends Date> NativeBuilder.Dt<T> sqlBuilder(Class<T> var1, String var2);

        default public <T extends Date> ComparableExpression<T> sql(Class<T> type, String sql) {
            return this.sqlBuilder(type, sql).build();
        }

        default public <T extends Date> ComparableExpression<T> sql(Class<T> type, String sql, Expression<?> ... expressions) {
            NativeBuilder.Dt<T> builder = this.sqlBuilder(type, sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public <T extends Date> ComparableExpression<T> sql(Class<T> type, String sql, Consumer<NativeContext> block) {
            NativeBuilder.Dt<T> builder = this.sqlBuilder(type, sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C, T extends Date> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, C var2);

        @NotNull
        public <C, T extends Date> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        @NotNull
        public <T extends Date> CaseBuilder.Cmp<T> caseBuilder(Class<T> var1);
    }

    public static interface TemporalFactory {
        @Deprecated
        default public <T extends Temporal & Comparable<?>> TemporalExpression<T> value(T value) {
            return Expression.value(value);
        }

        @NotNull
        public <T extends Temporal & Comparable<?>> NativeBuilder.Tp<T> sqlBuilder(Class<T> var1, String var2);

        default public <T extends Temporal & Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql) {
            return this.sqlBuilder(type, sql).build();
        }

        default public <T extends Temporal & Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Expression<?> ... expressions) {
            NativeBuilder.Tp<T> builder = this.sqlBuilder(type, sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public <T extends Temporal & Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Consumer<NativeContext> block) {
            NativeBuilder.Tp<T> builder = this.sqlBuilder(type, sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C, T extends Temporal & Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, C var2);

        @NotNull
        public <C, T extends Temporal & Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        @NotNull
        public <T extends Temporal & Comparable<?>> CaseBuilder.Cmp<T> caseBuilder(Class<T> var1);
    }

    public static interface AnyFactory {
        @Deprecated
        @NotNull
        default public <T> Expression<T> value(T value) {
            return Expression.value(value);
        }

        @NotNull
        public <T> NativeBuilder<T> sqlBuilder(Class<T> var1, String var2);

        default public <T> Expression<T> sql(Class<T> type, String sql) {
            return this.sqlBuilder(type, sql).build();
        }

        default public <T> Expression<T> sql(Class<T> type, String sql, Expression<?> ... expressions) {
            NativeBuilder<T> builder = this.sqlBuilder(type, sql);
            for (Expression<?> expression : expressions) {
                builder.expression((Expression)expression);
            }
            return builder.build();
        }

        default public <T> Expression<T> sql(Class<T> type, String sql, Consumer<NativeContext> block) {
            NativeBuilder<T> builder = this.sqlBuilder(type, sql);
            block.accept(builder);
            return builder.build();
        }

        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> var1, C var2);

        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        @NotNull
        public <T> CaseBuilder<T> caseBuilder(Class<T> var1);
    }
}

