/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.jetbrains.annotations.NotNull;

class DraftPreProcessorManager {
    private final Map<ImmutableType, List<DraftPreProcessor<?>>> processorMap;
    private final TypeCache<DraftPreProcessor<?>> cache = new TypeCache(this::create, true);

    DraftPreProcessorManager(Collection<DraftPreProcessor<?>> processors) {
        HashMap processorMap = new HashMap();
        for (DraftPreProcessor<?> processor : processors) {
            if (processor == null) continue;
            Map argTypeMap = TypeUtils.getTypeArguments(processor.getClass(), DraftPreProcessor.class);
            if (argTypeMap.isEmpty()) {
                throw new IllegalArgumentException("Illegal draft processor type \"" + processor.getClass().getName() + "\", it extends \"" + DraftPreProcessor.class.getName() + "\" but the generic type arguments are not specified");
            }
            TypeVariable<Class<T>>[] typeVariables = DraftPreProcessor.class.getTypeParameters();
            Type draftType = (Type)argTypeMap.get(typeVariables[0]);
            if (!(draftType instanceof Class && ((Class)draftType).isInterface() && Draft.class.isAssignableFrom((Class)draftType))) {
                throw new IllegalArgumentException("Illegal draft processor type \"" + processor.getClass().getName() + "\", it extends \"" + DraftPreProcessor.class.getName() + "\" but its draft type \"" + draftType + "\" is not non-generic interface type extends \"" + Draft.class.getName() + "\"");
            }
            ImmutableType immutableType = ImmutableType.get((Class)((Class)draftType));
            Class entityType = immutableType.getJavaClass();
            if (!entityType.isInterface() || entityType.getAnnotation(Entity.class) == null && entityType.getAnnotation(MappedSuperclass.class) == null) {
                throw new IllegalArgumentException("Illegal draft processor type \"" + processor.getClass().getName() + "\", it extends \"" + DraftPreProcessor.class.getName() + "\" but the processed entity type \"" + entityType + "\" is not interface type decorated by \"@" + Entity.class.getName() + "\" or \"@" + MappedSuperclass.class.getName() + "\"");
            }
            processorMap.computeIfAbsent(immutableType, it -> new ArrayList()).add(processor);
        }
        this.processorMap = processorMap;
    }

    public DraftPreProcessor<?> get(ImmutableType type) {
        return (DraftPreProcessor)this.cache.get(type);
    }

    private DraftPreProcessor<?> create(ImmutableType type) {
        final ArrayList processors = new ArrayList();
        Set allTypes = type.getAllTypes();
        for (Object t : allTypes) {
            List<DraftPreProcessor<?>> list = this.processorMap.get(t);
            if (list == null) continue;
            processors.addAll(list);
        }
        if (processors.isEmpty()) {
            return null;
        }
        boolean ignoreIdOnly = false;
        for (DraftPreProcessor draftPreProcessor : processors) {
            ignoreIdOnly |= draftPreProcessor.ignoreIdOnly();
        }
        final boolean mergedIgnoreIdOnly = ignoreIdOnly;
        return new DraftPreProcessor<Draft>(){

            @Override
            public void beforeSave(@NotNull Draft draft) {
                for (DraftPreProcessor processor : processors) {
                    processor.beforeSave(draft);
                }
            }

            @Override
            public boolean ignoreIdOnly() {
                return mergedIgnoreIdOnly;
            }

            @Override
            public boolean ignoreKeyOnly(@NotNull KeyMatcher.Group group) {
                for (DraftPreProcessor processor : processors) {
                    if (!processor.ignoreKeyOnly(group)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

