/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.PropConfig;
import org.babyfish.jimmer.dto.compiler.SimplePropType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class PropConfigBuilder<T extends BaseType, P extends BaseProp> {
    private final CompilerContext<T, P> ctx;
    private final P baseProp;
    private final String funcName;
    private final boolean recursive;
    private PropConfig.Predicate predicate;
    private List<PropConfig.OrderItem<P>> orderItems = Collections.emptyList();
    private String filterClassName;
    private String recursionClassName;
    private String fetchType = "AUTO";
    private int limit = Integer.MAX_VALUE;
    private int offset;
    private int batch;
    private int depth = Integer.MAX_VALUE;
    private boolean modified;

    PropConfigBuilder(CompilerContext<T, P> ctx, P baseProp, String funcName, boolean recursive) {
        this.ctx = ctx;
        this.baseProp = baseProp;
        this.funcName = funcName;
        this.recursive = recursive;
    }

    public void setPredicate(DtoParser.WhereContext where) {
        if (this.filterClassName != null) {
            throw this.ctx.exception(where.start.getLine(), where.start.getCharPositionInLine(), "Cannot specify \"!where\" when \"!filter\" exists");
        }
        if (!this.baseProp.isAssociation(true)) {
            throw this.ctx.exception(where.start.getLine(), where.start.getCharPositionInLine(), "Cannot be specify \"!where\" when the property is not association");
        }
        if (this.baseProp.isReference() && !this.baseProp.isNullable()) {
            throw this.ctx.exception(where.start.getLine(), where.start.getCharPositionInLine(), "Cannot be specify \"!where\" when the property is non-null reference");
        }
        this.predicate = this.createPredicate(where.predicate());
        this.modified = true;
    }

    void setOrderItems(DtoParser.OrderByContext orderBy) {
        if (this.filterClassName != null) {
            throw this.ctx.exception(orderBy.start.getLine(), orderBy.start.getCharPositionInLine(), "Cannot specify \"!orderBy\" when \"!filter\" exists");
        }
        if (!this.baseProp.isAssociation(true) || !this.baseProp.isList()) {
            throw this.ctx.exception(orderBy.start.getLine(), orderBy.start.getCharPositionInLine(), "Cannot be specify \"!orderBy\" when the property is not associated list");
        }
        List<DtoParser.OrderByItemContext> orderItems = orderBy.items;
        ArrayList items = new ArrayList(orderItems.size());
        for (DtoParser.OrderByItemContext item : orderItems) {
            String mode;
            Token modeToken = item.orderMode;
            String string = mode = modeToken != null ? modeToken.getText() : null;
            if (mode != null && !"asc".equals(mode) && !"desc".equals(mode)) {
                throw this.ctx.exception(modeToken.getLine(), modeToken.getCharPositionInLine(), "The order mode is neither \"asc\" nor \"desc\"");
            }
            items.add(new OrderItemImpl(this.createPropPath(item.propPath()), "desc".equals(mode)));
        }
        this.orderItems = Collections.unmodifiableList(items);
        this.modified = true;
    }

    void setFilterClassName(DtoParser.FilterContext filter) {
        if (this.predicate != null) {
            throw this.ctx.exception(filter.start.getLine(), filter.start.getCharPositionInLine(), "Cannot specify \"!filter\" when \"!where\" exists");
        }
        if (!this.orderItems.isEmpty()) {
            throw this.ctx.exception(filter.start.getLine(), filter.start.getCharPositionInLine(), "Cannot specify \"!filter\" when \"!orderBy\" exists");
        }
        if (!this.baseProp.isAssociation(true) || !this.baseProp.isList()) {
            throw this.ctx.exception(filter.start.getLine(), filter.start.getCharPositionInLine(), "Cannot be specify \"!filter\" when the property is not associated list");
        }
        String qualifiedName = filter.qualifiedName().parts.stream().map(Token::getText).collect(Collectors.joining("."));
        this.filterClassName = this.ctx.resolve(qualifiedName, filter.qualifiedName().start.getLine(), filter.qualifiedName().start.getCharPositionInLine());
        this.modified = true;
    }

    void setRecursionClassName(DtoParser.RecursionContext recursion) {
        if (this.depth != Integer.MAX_VALUE) {
            throw this.ctx.exception(recursion.start.getLine(), recursion.start.getCharPositionInLine(), "Cannot specify \"!recursion\" when \"!depth\" exists");
        }
        if (!this.recursive) {
            throw this.ctx.exception(recursion.start.getLine(), recursion.start.getCharPositionInLine(), "\"!recursion\" can only be applied for recursive property");
        }
        String qualifiedName = recursion.qualifiedName().parts.stream().map(Token::getText).collect(Collectors.joining("."));
        this.recursionClassName = this.ctx.resolve(qualifiedName, recursion.qualifiedName().start.getLine(), recursion.qualifiedName().start.getCharPositionInLine());
        this.modified = true;
    }

    void setFetchType(DtoParser.FetchTypeContext fetchType) {
        if (!this.baseProp.isAssociation(true) || this.baseProp.isList()) {
            throw this.ctx.exception(fetchType.start.getLine(), fetchType.start.getCharPositionInLine(), "Cannot be specify \"!fetchType\" when the property is not associated reference");
        }
        switch (this.fetchType = fetchType.fetchMode.getText()) {
            case "SELECT": 
            case "JOIN_IF_NO_CACHE": 
            case "JOIN_ALWAYS": {
                break;
            }
            default: {
                throw this.ctx.exception(fetchType.fetchMode.getLine(), fetchType.fetchMode.getCharPositionInLine(), "The fetch mode can only be \"SELECT\", \"JOIN_IF_NO_CACHE\" or \"JOIN_ALWAYS\"");
            }
        }
        this.modified = true;
    }

    void setLimit(DtoParser.LimitContext limit) {
        if (!this.baseProp.isAssociation(true) || !this.baseProp.isList()) {
            throw this.ctx.exception(limit.start.getLine(), limit.start.getCharPositionInLine(), "Cannot be specify \"!limit\" when the property is not associated list");
        }
        int limitValue = Integer.parseInt(limit.limitArg.getText());
        if (limitValue < 1) {
            throw this.ctx.exception(limit.limitArg.getLine(), limit.limitArg.getCharPositionInLine(), "The limit cannot be less than 1");
        }
        int offsetValue = 0;
        if (limit.offsetArg != null && (offsetValue = Integer.parseInt(limit.offsetArg.getText())) < 0) {
            throw this.ctx.exception(limit.offsetArg.getLine(), limit.offsetArg.getCharPositionInLine(), "The offset cannot be less than 0");
        }
        this.limit = limitValue;
        this.offset = offsetValue;
        this.modified = true;
    }

    void setBatch(DtoParser.BatchContext batch) {
        int value = Integer.parseInt(batch.IntegerLiteral().getText());
        if (value < 1) {
            throw this.ctx.exception(batch.start.getLine(), batch.start.getCharPositionInLine(), "The batch cannot be less than 1");
        }
        this.batch = value;
        this.modified = true;
    }

    void setDepth(DtoParser.RecursionDepthContext depth) {
        if (this.recursionClassName != null) {
            throw this.ctx.exception(depth.start.getLine(), depth.start.getCharPositionInLine(), "Cannot specify \"!depth\" when \"!recursion\" exists");
        }
        if (!this.recursive) {
            throw this.ctx.exception(depth.start.getLine(), depth.start.getCharPositionInLine(), "\"!depth\" can only be applied for recursive property");
        }
        int value = Integer.parseInt(depth.IntegerLiteral().getText());
        if (value < 0) {
            throw this.ctx.exception(depth.start.getLine(), depth.start.getCharPositionInLine(), "The offset cannot be less than 0");
        }
        this.depth = value;
        this.modified = true;
    }

    PropConfig<P> build() {
        if (!this.modified) {
            return null;
        }
        return new PropConfigImpl(this.predicate, this.orderItems, this.filterClassName, this.recursionClassName, this.fetchType, this.limit, this.offset, this.batch, this.depth);
    }

    private PropConfig.Predicate createPredicate(DtoParser.PredicateContext predicate) {
        ArrayList<PropConfig.Predicate> predicates = new ArrayList<PropConfig.Predicate>(predicate.subPredicates.size());
        for (DtoParser.AndPredicateContext p : predicate.subPredicates) {
            predicates.add(this.createPredicate(p));
        }
        return OrPredicateImpl.of(predicates);
    }

    private PropConfig.Predicate createPredicate(DtoParser.AndPredicateContext predicate) {
        ArrayList<PropConfig.Predicate> predicates = new ArrayList<PropConfig.Predicate>(predicate.subPredicates.size());
        for (DtoParser.AtomPredicateContext p : predicate.subPredicates) {
            predicates.add(this.createPredicate(p));
        }
        return AndPredicateImpl.of(predicates);
    }

    private PropConfig.Predicate createPredicate(DtoParser.AtomPredicateContext predicate) {
        if (predicate.cmpPredicate() != null) {
            return this.createPredicate(predicate.cmpPredicate());
        }
        if (predicate.nullityPredicate() != null) {
            return this.createPredicate(predicate.nullityPredicate());
        }
        return this.createPredicate(predicate.predicate());
    }

    private PropConfig.Predicate createPredicate(DtoParser.NullityPredicateContext predicate) {
        return new NullityPredicate<P>(this.createPropPath(predicate.propPath()), predicate.not != null);
    }

    private PropConfig.Predicate createPredicate(DtoParser.CmpPredicateContext predicate) {
        List<PropConfig.PathNode<P>> path;
        PropConfig.PathNode<P> lastProp;
        SimplePropType simplePropType;
        if (predicate.op.getType() == 54) {
            String opText;
            switch (opText = predicate.op.getText()) {
                case "like": 
                case "ilike": {
                    break;
                }
                default: {
                    throw this.ctx.exception(predicate.op.getLine(), predicate.op.getCharPositionInLine(), "The infix operator must \"like\" or \"ilike\"");
                }
            }
        }
        if ((simplePropType = this.ctx.getSimpleType(lastProp = (path = this.createPropPath(predicate.propPath())).get(path.size() - 1))) == SimplePropType.NONE) {
            List<Token> parts = predicate.propPath().parts;
            Token lastPart = parts.get(parts.size() - 1);
            throw this.ctx.exception(lastPart.getLine(), lastPart.getCharPositionInLine(), "The \"!where\" in DTO must be simple predicate so that the last property \"" + lastProp + "\" must be boolean, number, string");
        }
        String op = predicate.op.getText();
        if (simplePropType != SimplePropType.STRING && (op.equals("like") || op.equals("ilike"))) {
            throw this.ctx.exception(predicate.op.getLine(), predicate.op.getCharPositionInLine(), "The operator \"" + op + "\" is not allowed here because the left operand is not string");
        }
        Object value = this.createPropValue(predicate.right, simplePropType);
        return new CmpPredicate<P>(path, predicate.op.getText(), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PropConfig.PathNode<P>> createPropPath(DtoParser.PropPathContext propPath) {
        T baseType = this.ctx.getTargetType(this.baseProp);
        int size = propPath.parts.size();
        ArrayList<PropConfig.PathNode<P>> pathNodes = new ArrayList<PropConfig.PathNode<P>>(size + 1);
        for (int i = 0; i < size; ++i) {
            BaseProp referenceProp;
            Token part = propPath.parts.get(i);
            BaseProp baseProp = (BaseProp)this.ctx.getProps(baseType).get(part.getText());
            if (baseProp == null) {
                if (!part.getText().endsWith("Id")) throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "There is no property \"" + part.getText() + "\" in type \"" + baseType.getQualifiedName() + "\"");
                String referenceName = part.getText().substring(0, part.getText().length() - 2);
                BaseProp referenceProp2 = (BaseProp)this.ctx.getProps(baseType).get(referenceName);
                if (referenceProp2 == null || !referenceProp2.isReference() || !referenceProp2.isAssociation(true)) throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "There is no property \"" + part.getText() + "\" in type \"" + baseType.getQualifiedName() + "\"");
                pathNodes.add(new AssociatedIdPathNodeImpl<BaseProp>(referenceProp2, this.ctx.getIdProp(this.ctx.getTargetType(referenceProp2)).getName()));
                T targetType = this.ctx.getTargetType(referenceProp2);
                P p = this.ctx.getIdProp(targetType);
                baseType = this.ctx.getTargetType(p);
                continue;
            }
            if (baseProp.getIdViewBaseProp() != null && !(referenceProp = baseProp.getIdViewBaseProp()).isList()) {
                pathNodes.add(new AssociatedIdPathNodeImpl<BaseProp>(referenceProp, this.ctx.getIdProp(this.ctx.getTargetType(referenceProp)).getName()));
                T targetType = this.ctx.getTargetType(referenceProp);
                P idProp = this.ctx.getIdProp(targetType);
                baseType = this.ctx.getTargetType(idProp);
                continue;
            }
            if (baseProp.isAssociation(true)) {
                if (!baseProp.isReference()) throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "There property \"" + baseProp + "\" cannot be supported because join is forbidden by fetcher field predicate");
                if (i + 1 >= size) throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "Please replace \"" + baseProp.getName() + "\" to \"" + baseProp.getName() + "Id\"");
                String idPropName = this.ctx.getIdProp(this.ctx.getTargetType(baseProp)).getName();
                if (propPath.parts.get(i + 1).getText().equals(idPropName)) {
                    throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "Please replace \"" + baseProp.getName() + "." + idPropName + "\" to \"" + baseProp.getName() + "Id\"");
                }
            } else if (i + 1 < size && !baseProp.isEmbedded()) {
                throw this.ctx.exception(part.getLine(), part.getCharPositionInLine(), "There property \"" + baseProp + "\" is not last property but it is not embedded object");
            }
            pathNodes.add(new SimplePathNodeImpl<BaseProp>(baseProp));
            baseType = this.ctx.getTargetType(baseProp);
        }
        return pathNodes;
    }

    private Object createPropValue(DtoParser.PropValueContext value, SimplePropType simplePropType) {
        if (value.stringToken != null) {
            if (simplePropType != SimplePropType.STRING) {
                throw this.ctx.exception(value.start.getLine(), value.start.getCharPositionInLine(), "Illegal string literal, the left operand is not string");
            }
            String text = value.stringToken.getText();
            return text.substring(1, text.length() - 1);
        }
        if (value.booleanToken != null) {
            if (simplePropType != SimplePropType.BOOLEAN) {
                throw this.ctx.exception(value.start.getLine(), value.start.getCharPositionInLine(), "Illegal string literal, the left operand is not boolean");
            }
            return "true".equals(value.booleanToken.getText());
        }
        if (value.characterToken != null) {
            if (simplePropType != SimplePropType.STRING) {
                throw this.ctx.exception(value.start.getLine(), value.start.getCharPositionInLine(), "Illegal char literal, the left operand is not string");
            }
            String text = value.characterToken.getText();
            return text.substring(1, text.length() - 1);
        }
        if (value.integerToken != null) {
            switch (simplePropType) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    long l = Long.parseLong(value.integerToken.getText());
                    if (value.negative != null) {
                        l = -l;
                    }
                    return l;
                }
                case BIG_INTEGER: {
                    BigInteger bi = new BigInteger(value.integerToken.getText());
                    if (value.negative != null) {
                        bi = bi.negate();
                    }
                    return bi;
                }
            }
            if (simplePropType != SimplePropType.STRING) {
                throw this.ctx.exception(value.start.getLine(), value.start.getCharPositionInLine(), "Illegal integer literal, the left operand is not integer");
            }
        }
        switch (simplePropType) {
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: {
                BigDecimal bc = new BigDecimal(value.floatingPointToken.getText());
                if (value.negative != null) {
                    bc = bc.negate();
                }
                return bc;
            }
        }
        throw this.ctx.exception(value.start.getLine(), value.start.getCharPositionInLine(), "Illegal float/decimal literal, the left operand is neither float nor decimal");
    }

    private static class OrderItemImpl<P extends BaseProp>
    extends PathHolder<P>
    implements PropConfig.OrderItem<P> {
        private final boolean desc;

        private OrderItemImpl(List<PropConfig.PathNode<P>> path, boolean desc) {
            super(path);
            this.desc = desc;
        }

        @Override
        public boolean isDesc() {
            return this.desc;
        }

        public String toString() {
            return this.path() + (this.desc ? " desc" : " asc");
        }
    }

    private static class PropConfigImpl<P extends BaseProp>
    implements PropConfig<P> {
        private final PropConfig.Predicate predicate;
        private final List<PropConfig.OrderItem<P>> orderItems;
        private final String filterClassName;
        private final String recursionClassName;
        private final String fetchType;
        private final int limit;
        private final int offset;
        private final int batch;
        private final int depth;

        private PropConfigImpl(PropConfig.Predicate predicate, List<PropConfig.OrderItem<P>> orderItems, String filterClassName, String recursionClassName, String fetchType, int limit, int offset, int batch, int depth) {
            this.predicate = predicate;
            this.orderItems = orderItems;
            this.filterClassName = filterClassName;
            this.recursionClassName = recursionClassName;
            this.fetchType = fetchType;
            this.limit = limit;
            this.offset = offset;
            this.batch = batch;
            this.depth = depth;
        }

        @Override
        @Nullable
        public PropConfig.Predicate getPredicate() {
            return this.predicate;
        }

        @Override
        public List<PropConfig.OrderItem<P>> getOrderItems() {
            return this.orderItems;
        }

        @Override
        @Nullable
        public String getFilterClassName() {
            return this.filterClassName;
        }

        @Override
        @Nullable
        public String getRecursionClassName() {
            return this.recursionClassName;
        }

        @Override
        @Nullable
        public String getFetchType() {
            return this.fetchType;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getBatch() {
            return this.batch;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.predicate != null) {
                builder.append("!where(").append(this.predicate).append(") ");
            }
            if (!this.orderItems.isEmpty()) {
                builder.append("!orderBy(");
                boolean addComma = false;
                for (PropConfig.OrderItem<P> item : this.orderItems) {
                    if (addComma) {
                        builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    builder.append(item);
                }
                builder.append(") ");
            }
            if (this.filterClassName != null) {
                builder.append("!filter(").append(this.filterClassName).append(") ");
            }
            if (this.recursionClassName != null) {
                builder.append("!recursion(").append(this.recursionClassName).append(") ");
            }
            if (!"AUTO".equals(this.fetchType)) {
                builder.append("!fetchType(").append(this.fetchType).append(") ");
            }
            if (this.limit != Integer.MAX_VALUE) {
                if (this.offset != 0) {
                    builder.append("!limit(").append(this.limit).append(", ").append(this.offset).append(") ");
                } else {
                    builder.append("!limit(").append(this.limit).append(") ");
                }
            }
            if (this.batch != 0) {
                builder.append("!batch(").append(this.batch).append(") ");
            }
            if (this.depth != Integer.MAX_VALUE) {
                builder.append("!depth(").append(this.depth).append(") ");
            }
            return builder.toString();
        }
    }

    private static class OrPredicateImpl
    extends CompositePredicate
    implements PropConfig.Predicate.Or {
        private OrPredicateImpl(List<PropConfig.Predicate> predicates) {
            super(predicates);
        }

        static PropConfig.Predicate of(List<PropConfig.Predicate> predicates) {
            if (predicates.size() == 1) {
                return predicates.get(0);
            }
            return new OrPredicateImpl(predicates);
        }

        @Override
        String separator() {
            return " or ";
        }
    }

    private static class AndPredicateImpl
    extends CompositePredicate
    implements PropConfig.Predicate.And {
        private AndPredicateImpl(List<PropConfig.Predicate> predicates) {
            super(predicates);
        }

        static PropConfig.Predicate of(List<PropConfig.Predicate> predicates) {
            if (predicates.size() == 1) {
                return predicates.get(0);
            }
            return new AndPredicateImpl(predicates);
        }

        @Override
        String separator() {
            return " and ";
        }
    }

    private static class NullityPredicate<P extends BaseProp>
    extends PathHolder<P>
    implements PropConfig.Predicate.Nullity<P> {
        private final boolean negative;

        NullityPredicate(List<PropConfig.PathNode<P>> path, boolean negative) {
            super(path);
            this.negative = negative;
        }

        @Override
        public boolean isNegative() {
            return this.negative;
        }

        public String toString() {
            return this.path() + (this.negative ? " is not null" : " is null");
        }
    }

    private static class CmpPredicate<P extends BaseProp>
    extends PathHolder<P>
    implements PropConfig.Predicate.Cmp<P> {
        private final String operator;
        private final Object value;

        CmpPredicate(List<PropConfig.PathNode<P>> path, String operator, Object value) {
            super(path);
            this.operator = "!=".equals(operator) ? "<>" : operator;
            this.value = value;
        }

        @Override
        public String getOperator() {
            return this.operator;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.path() + " " + this.operator + " " + (this.value instanceof String ? "\"" + this.value + "\"" : this.value);
        }
    }

    private static class AssociatedIdPathNodeImpl<P extends BaseProp>
    implements PropConfig.PathNode<P> {
        private final P prop;
        private final String idPropName;

        AssociatedIdPathNodeImpl(P prop, String idPropName) {
            this.prop = prop;
            this.idPropName = idPropName;
        }

        @Override
        public P getProp() {
            return this.prop;
        }

        @Override
        public boolean isAssociatedId() {
            return true;
        }

        public String toString() {
            return this.prop + "." + this.idPropName;
        }
    }

    private static class SimplePathNodeImpl<P extends BaseProp>
    implements PropConfig.PathNode<P> {
        private final P prop;

        SimplePathNodeImpl(P prop) {
            this.prop = prop;
        }

        @Override
        public P getProp() {
            return this.prop;
        }

        @Override
        public boolean isAssociatedId() {
            return false;
        }

        public String toString() {
            return this.prop.toString();
        }
    }

    private static abstract class PathHolder<P extends BaseProp> {
        final List<PropConfig.PathNode<P>> path;

        PathHolder(List<PropConfig.PathNode<P>> path) {
            this.path = path.size() == 1 ? Collections.singletonList(path.get(0)) : Collections.unmodifiableList(path);
        }

        public List<PropConfig.PathNode<P>> getPath() {
            return this.path;
        }

        String path() {
            StringBuilder builder = new StringBuilder();
            boolean addComma = false;
            for (PropConfig.PathNode<P> pathNode : this.path) {
                if (addComma) {
                    builder.append('.');
                } else {
                    addComma = true;
                }
                builder.append(pathNode.getProp().getName());
                if (!pathNode.isAssociatedId()) continue;
                builder.append("Id");
            }
            return builder.toString();
        }
    }

    private static abstract class CompositePredicate
    implements PropConfig.Predicate.Or {
        private final List<PropConfig.Predicate> predicates;

        CompositePredicate(List<PropConfig.Predicate> predicates) {
            this.predicates = Collections.unmodifiableList(predicates);
        }

        @Override
        public List<PropConfig.Predicate> getPredicates() {
            return this.predicates;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean addSeparator = false;
            String separator = this.separator();
            builder.append('(');
            for (PropConfig.Predicate predicate : this.predicates) {
                if (addSeparator) {
                    builder.append(separator);
                } else {
                    addSeparator = true;
                }
                builder.append(predicate);
            }
            builder.append(')');
            return builder.toString();
        }

        abstract String separator();
    }
}

