/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public interface OsFile {
    public String getAbsolutePath();

    public Reader openReader() throws IOException;

    public static OsFile of(final File file) {
        return new OsFile(){

            @Override
            public String getAbsolutePath() {
                return file.getAbsolutePath();
            }

            @Override
            public Reader openReader() throws IOException {
                return new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            }
        };
    }
}

