/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.PropConfig;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtoType<T extends BaseType, P extends BaseProp> {
    private final T baseType;
    private final String packageName;
    private final Set<DtoModifier> modifiers;
    private final List<Anno> annotations;
    private final List<TypeRef> superInterfaces;
    @Nullable
    private final String name;
    @NotNull
    private final DtoFile dtoFile;
    @Nullable
    private final String doc;
    private final boolean focusedRecursion;
    private List<AbstractProp> props;
    private List<DtoProp<T, P>> dtoProps;
    private List<UserProp> userProps;
    private List<DtoProp<T, P>> hiddenFlatProps;

    DtoType(T baseType, @Nullable String packageName, Set<DtoModifier> modifiers, List<Anno> annotations, List<TypeRef> superInterfaces, @Nullable String name, @NotNull DtoFile dtoFile, @Nullable String doc) {
        this.baseType = baseType;
        this.packageName = packageName != null ? packageName : DtoType.defaultPackageName(baseType.getPackageName());
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.superInterfaces = superInterfaces;
        this.name = name;
        this.dtoFile = dtoFile;
        this.doc = doc;
        this.focusedRecursion = false;
    }

    private DtoType(DtoType<T, P> original, DtoProp<T, P> recursionProp) {
        this.baseType = original.baseType;
        this.packageName = original.packageName;
        this.modifiers = original.modifiers;
        this.annotations = original.annotations;
        this.superInterfaces = original.superInterfaces;
        this.name = null;
        this.dtoFile = original.dtoFile;
        this.doc = original.doc;
        this.focusedRecursion = true;
        ArrayList<AbstractProp> props = new ArrayList<AbstractProp>(original.props.size());
        for (AbstractProp prop : original.props) {
            DtoProp dtoProp;
            if (prop instanceof DtoProp && (dtoProp = (DtoProp)prop).isRecursive() && dtoProp != recursionProp) continue;
            props.add(prop);
        }
        this.props = Collections.unmodifiableList(props);
    }

    public T getBaseType() {
        return this.baseType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getDoc() {
        return this.doc;
    }

    public Set<DtoModifier> getModifiers() {
        return this.modifiers;
    }

    public List<Anno> getAnnotations() {
        return this.annotations;
    }

    public List<TypeRef> getSuperInterfaces() {
        return this.superInterfaces;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public DtoFile getDtoFile() {
        return this.dtoFile;
    }

    public List<AbstractProp> getProps() {
        return this.props;
    }

    public List<DtoProp<T, P>> getDtoProps() {
        List<DtoProp<T, P>> list = this.dtoProps;
        if (list == null) {
            list = new ArrayList<DtoProp<T, P>>();
            for (AbstractProp prop : this.props) {
                if (!(prop instanceof DtoProp)) continue;
                list.add((DtoProp)prop);
            }
            this.dtoProps = list;
        }
        return list;
    }

    public List<UserProp> getUserProps() {
        List<UserProp> list = this.userProps;
        if (list == null) {
            list = new ArrayList<UserProp>();
            for (AbstractProp prop : this.props) {
                if (!(prop instanceof UserProp)) continue;
                list.add((UserProp)prop);
            }
            this.userProps = list;
        }
        return list;
    }

    public List<DtoProp<T, P>> getHiddenFlatProps() {
        List<DtoProp<T, P>> hfps = this.hiddenFlatProps;
        if (hfps == null) {
            FlatDtoBuilder<T, P> builder = new FlatDtoBuilder<T, P>(this.packageName, this.modifiers, null);
            for (DtoProp<T, P> prop : this.getDtoProps()) {
                if (prop.getNextProp() == null) continue;
                builder.add(prop);
            }
            this.hiddenFlatProps = hfps = builder.build().getDtoProps();
        }
        return hfps;
    }

    DtoType<T, P> recursiveOne(DtoProp<T, P> recursionProp) {
        return new DtoType<T, P>(this, recursionProp);
    }

    void setProps(List<AbstractProp> props) {
        if (props == null) {
            throw new IllegalArgumentException("`props` cannot be null");
        }
        if (this.props != null) {
            throw new IllegalArgumentException("`props` has already been set");
        }
        this.props = props;
        this.props = DtoType.standardProps(props);
    }

    public boolean isFocusedRecursion() {
        return this.focusedRecursion;
    }

    public String toString() {
        return this.toString(null);
    }

    String toString(@Nullable PropConfig config) {
        StringBuilder builder = new StringBuilder();
        if (this.doc != null) {
            builder.append("@doc(").append(this.doc.replace("\n", "\\n")).append(") ");
        }
        for (Anno anno : this.annotations) {
            builder.append(anno).append(' ');
        }
        for (DtoModifier dtoModifier : this.modifiers) {
            builder.append(dtoModifier.name().toLowerCase()).append(' ');
        }
        if (this.name != null) {
            builder.append(this.name).append(' ');
        }
        if (!this.superInterfaces.isEmpty()) {
            String separator = "implements ";
            for (TypeRef typeRef : this.superInterfaces) {
                builder.append(separator);
                separator = ", ";
                builder.append(typeRef);
            }
            builder.append(' ');
        }
        builder.append('{');
        boolean addComma = false;
        boolean bl = this.modifiers.contains((Object)DtoModifier.INPUT);
        if (config != null) {
            builder.append(config);
            addComma = true;
        }
        for (AbstractProp prop : this.props) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            if (bl && prop.isNullable() && prop instanceof DtoProp) {
                builder.append(((DtoPropImpl)prop).toString(((DtoProp)prop).getInputModifier()));
                continue;
            }
            builder.append(prop);
        }
        builder.append('}');
        return builder.toString();
    }

    private static String defaultPackageName(String entityPackageName) {
        if (entityPackageName == null || entityPackageName.isEmpty()) {
            return "dto";
        }
        return entityPackageName + ".dto";
    }

    private static <T extends BaseType, P extends BaseProp> List<AbstractProp> standardProps(List<AbstractProp> props) {
        ArrayList<DtoProp> recursiveProps = new ArrayList<DtoProp>();
        for (AbstractProp prop : props) {
            DtoProp dtoProp;
            if (!(prop instanceof DtoProp) || !(dtoProp = (DtoProp)prop).isRecursive()) continue;
            recursiveProps.add(dtoProp);
        }
        if (recursiveProps.size() <= 1) {
            return props;
        }
        ArrayList<AbstractProp> newProps = new ArrayList<AbstractProp>(props.size());
        for (AbstractProp prop : props) {
            DtoProp dtoProp;
            if (prop instanceof DtoProp && (dtoProp = (DtoProp)prop).isRecursive()) {
                newProps.add(new DtoPropImpl(dtoProp));
                continue;
            }
            newProps.add(prop);
        }
        return newProps;
    }

    private class FlatDtoBuilder<T extends BaseType, P extends BaseProp> {
        private final String packageName;
        private final Set<DtoModifier> modifiers;
        private final DtoProp<T, P> prop;
        private final Map<String, Object> childNodes = new LinkedHashMap<String, Object>();

        FlatDtoBuilder(String packageName, Set<DtoModifier> modifiers, DtoProp<T, P> prop) {
            this.packageName = packageName;
            this.modifiers = modifiers;
            this.prop = prop;
        }

        public void add(DtoProp<T, P> prop) {
            String baseName = prop.getBaseProp().getName();
            if (prop.getNextProp() == null) {
                this.childNodes.put(baseName, prop);
            } else {
                FlatDtoBuilder<T, P> child = (FlatDtoBuilder<T, P>)this.childNodes.get(baseName);
                if (child == null) {
                    child = new FlatDtoBuilder<T, P>(this.packageName, this.modifiers, prop);
                    this.childNodes.put(baseName, child);
                }
                child.add(prop.getNextProp());
            }
        }

        public DtoType<T, P> build() {
            List<AbstractProp> props;
            if (this.childNodes.isEmpty()) {
                props = Collections.emptyList();
            } else {
                props = new ArrayList();
                for (Object child : this.childNodes.values()) {
                    if (child instanceof DtoProp) {
                        props.add((DtoProp)child);
                        continue;
                    }
                    FlatDtoBuilder builder = (FlatDtoBuilder)child;
                    DtoPropImpl<T, P> prop = new DtoPropImpl<T, P>(builder.prop, builder.build());
                    props.add(prop);
                }
                props = Collections.unmodifiableList(props);
            }
            DtoType dtoType = new DtoType(null, this.packageName, this.modifiers, DtoType.this.annotations, Collections.emptyList(), null, DtoType.this.dtoFile, null);
            dtoType.setProps(props);
            return dtoType;
        }
    }
}

