/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import org.babyfish.jimmer.dto.compiler.DtoFile;

public class DtoAstException
extends RuntimeException {
    private final String absolutePath;
    private final String path;
    private final int lineNumber;
    private final int colNumber;

    public DtoAstException(DtoFile file, int lineNumber, int colNumber, String message) {
        super(file.getAbsolutePath() + ':' + lineNumber + " : " + message + DtoAstException.positionString(file, lineNumber, colNumber));
        this.absolutePath = file.getAbsolutePath();
        this.path = file.getPath();
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String positionString(DtoFile dtoFile, int lineNumber, int colNumber) {
        try (BufferedReader reader = new BufferedReader(dtoFile.openReader());){
            int lineNo = 1;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return "";
                }
                if (lineNo == lineNumber) {
                    StringBuilder builder = new StringBuilder();
                    builder.append('\n').append(line).append('\n');
                    int i = colNumber;
                    while (true) {
                        if (i <= 0) {
                            builder.append('^');
                            String string = builder.toString();
                            return string;
                        }
                        builder.append(' ');
                        --i;
                    }
                }
                ++lineNo;
            }
        }
        catch (IOException ex) {
            return "";
        }
    }
}

