/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.Docs;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoCompiler;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeBuilder;
import org.babyfish.jimmer.dto.compiler.Importing;
import org.babyfish.jimmer.dto.compiler.PropConfig;
import org.babyfish.jimmer.dto.compiler.SimplePropType;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class CompilerContext<T extends BaseType, P extends BaseProp> {
    private final DtoCompiler<T, P> compiler;
    private final Importing importing;
    private final Map<String, DtoTypeBuilder<T, P>> typeBuilderMap = new LinkedHashMap<String, DtoTypeBuilder<T, P>>();

    public CompilerContext(DtoCompiler<T, P> compiler) {
        this.compiler = compiler;
        this.importing = new Importing(this);
    }

    public DtoTypeBuilder<T, P> get(String name) {
        return this.typeBuilderMap.get(name);
    }

    public void importStatement(DtoParser.ImportStatementContext statement) {
        this.importing.add(statement);
    }

    public DtoTypeBuilder<T, P> add(DtoParser.DtoTypeContext type) {
        String name = type.name.getText();
        if (this.typeBuilderMap.containsKey(name)) {
            throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "Duplicated dto type name \"" + name + "\"");
        }
        AbstractSet modifiers = EnumSet.noneOf(DtoModifier.class);
        for (Token token : type.modifiers) {
            DtoModifier dtoModifier;
            switch (token.getText()) {
                case "input": {
                    dtoModifier = DtoModifier.INPUT;
                    break;
                }
                case "specification": {
                    dtoModifier = DtoModifier.SPECIFICATION;
                    break;
                }
                case "unsafe": {
                    dtoModifier = DtoModifier.UNSAFE;
                    break;
                }
                case "fixed": {
                    dtoModifier = DtoModifier.FIXED;
                    break;
                }
                case "static": {
                    dtoModifier = DtoModifier.STATIC;
                    break;
                }
                case "dynamic": {
                    dtoModifier = DtoModifier.DYNAMIC;
                    break;
                }
                case "fuzzy": {
                    dtoModifier = DtoModifier.FUZZY;
                    break;
                }
                default: {
                    throw this.exception(token.getLine(), token.getCharPositionInLine(), "If the modifier of dto type is specified, it must be 'input', 'specification', 'unsafe', 'fixed', 'static', 'dynamic' or 'fuzzy'");
                }
            }
            if (modifiers.add(dtoModifier)) continue;
            throw this.exception(token.getLine(), token.getCharPositionInLine(), "Duplicated modifier \"" + token.getText() + "\"");
        }
        if (modifiers.contains((Object)DtoModifier.INPUT) && modifiers.contains((Object)DtoModifier.SPECIFICATION)) {
            throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "The modifiers 'input' and 'specification' cannot appear at the same time");
        }
        if (modifiers.contains((Object)DtoModifier.UNSAFE) && modifiers.contains((Object)DtoModifier.SPECIFICATION)) {
            throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "The modifier 'unsafe' cannot be used with specification");
        }
        if (modifiers.contains((Object)DtoModifier.SPECIFICATION) && !this.compiler.getBaseType().isEntity()) {
            throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "The modifier 'specification' can only be used to decorate entity type");
        }
        if (!modifiers.contains((Object)DtoModifier.INPUT)) {
            for (DtoModifier dtoModifier : modifiers) {
                if (!dtoModifier.isInputStrategy()) continue;
                throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "The modifier '" + dtoModifier.name().toLowerCase() + "' can only be used for input");
            }
        }
        DtoModifier inputStrategyModifier = null;
        for (DtoModifier modifier : modifiers) {
            if (!modifier.isInputStrategy()) continue;
            if (inputStrategyModifier == null) {
                inputStrategyModifier = modifier;
                continue;
            }
            throw this.exception(type.name.getLine(), type.name.getCharPositionInLine(), "The modifiers '" + inputStrategyModifier.name().toLowerCase() + "' and '" + modifier.name().toLowerCase() + "' cannot appear at the same time");
        }
        if (modifiers.contains((Object)DtoModifier.INPUT) && !modifiers.stream().anyMatch(DtoModifier::isInputStrategy)) {
            modifiers.add(this.compiler.getDefaultNullableInputModifier());
        }
        if (!modifiers.isEmpty()) {
            ArrayList<DtoModifier> arrayList = new ArrayList<DtoModifier>(modifiers);
            Collections.sort(arrayList, Comparator.comparing(DtoModifier::getOrder));
            modifiers = new LinkedHashSet<DtoModifier>(arrayList);
        }
        DtoTypeBuilder dtoTypeBuilder = new DtoTypeBuilder(null, this.compiler.getBaseType(), type.body, type.name, Docs.parse(type.doc), modifiers, type.annotations, type.superInterfaces, this);
        this.typeBuilderMap.put(name, dtoTypeBuilder);
        return dtoTypeBuilder;
    }

    public List<DtoType<T, P>> getDtoTypes() {
        ArrayList<DtoType<T, P>> types = new ArrayList<DtoType<T, P>>(this.typeBuilderMap.size());
        for (DtoTypeBuilder<T, P> builder : this.typeBuilderMap.values()) {
            DtoType<T, P> type = builder.build();
            types.add(type);
        }
        return types;
    }

    public Map<String, P> getProps(T baseType) {
        return this.compiler.getProps(baseType);
    }

    public Map<String, P> getDeclaredProps(T baseType) {
        return this.compiler.getDeclaredProps(baseType);
    }

    public boolean isImplicitId(P baseProp, Set<DtoModifier> modifiers) {
        if (modifiers.contains((Object)DtoModifier.INPUT) || modifiers.contains((Object)DtoModifier.SPECIFICATION)) {
            return baseProp.isId() && this.compiler.isGeneratedValue(baseProp);
        }
        return false;
    }

    public T getTargetType(P baseProp) {
        return this.compiler.getTargetType(baseProp);
    }

    @Nullable
    public P getIdProp(T baseType) {
        return this.compiler.getIdProp(baseType);
    }

    public boolean isSameType(P baseProp1, P baseProp2) {
        return this.compiler.isSameType(baseProp1, baseProp2);
    }

    public SimplePropType getSimpleType(P baseProp) {
        return this.compiler.getSimplePropType(baseProp);
    }

    public SimplePropType getSimpleType(PropConfig.PathNode<P> pathNode) {
        return this.compiler.getSimplePropType(pathNode);
    }

    public DtoFile getDtoFile() {
        return this.compiler.getDtoFile();
    }

    public String getTargetPackageName() {
        return this.compiler.getTargetPackageName();
    }

    public T getBaseType() {
        return this.compiler.getBaseType();
    }

    public Collection<T> getSuperTypes(T baseType) {
        return this.compiler.getSuperTypes(baseType);
    }

    public List<String> getEnumConstants(P baseProp) {
        return this.compiler.getEnumConstants(baseProp);
    }

    public TypeRef resolve(DtoParser.TypeRefContext ctx) {
        return this.importing.resolve(ctx, this.compiler);
    }

    public String resolve(DtoParser.QualifiedNameContext ctx) {
        return this.importing.resolve(ctx);
    }

    public String resolve(String qualifiedName, int qualifiedNameLine, int qualifiedNameCol) {
        return this.importing.resolve(qualifiedName, qualifiedNameLine, qualifiedNameCol);
    }

    public DtoAstException exception(int line, int col, String message) {
        return this.compiler.exception(line, col, message);
    }
}

