/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoParser;

public class AliasPattern {
    private final CompilerContext<?, ?> ctx;
    private final boolean isPrefix;
    private final boolean isSuffix;
    private final String original;
    private final String replacement;

    public AliasPattern(CompilerContext<?, ?> ctx, DtoParser.AliasPatternContext pattern) {
        this.ctx = ctx;
        if (pattern.prefix != null && pattern.suffix != null) {
            throw ctx.exception(pattern.suffix.getLine(), pattern.suffix.getCharPositionInLine(), "The `^` and `$` cannot appear at the same time");
        }
        if (pattern.original == null && pattern.replacement == null) {
            throw ctx.exception(pattern.translator.getLine(), pattern.translator.getCharPositionInLine(), "There is no identifier to the left or right of the converter '->'");
        }
        if (pattern.prefix == null && pattern.original == null && pattern.suffix == null) {
            throw ctx.exception(pattern.translator.getLine(), pattern.translator.getCharPositionInLine(), "There is nothing to the left of the converter '->', which is not allowed");
        }
        this.isPrefix = pattern.prefix != null;
        this.isSuffix = pattern.suffix != null;
        this.original = pattern.original != null ? pattern.original.getText() : null;
        this.replacement = pattern.replacement != null ? pattern.replacement.getText() : null;
    }

    public String alias(Token token) {
        return this.alias(token.getText(), token.getLine(), token.getCharPositionInLine());
    }

    public String alias(String text, int line, int col) {
        if (this.original == null) {
            if (this.isPrefix) {
                return AliasPattern.join(this.replacement, text);
            }
            if (this.isSuffix) {
                return AliasPattern.join(text, this.replacement);
            }
            throw new AssertionError((Object)"Internal bug of DTO compiler");
        }
        if (this.isPrefix) {
            if (text.startsWith(this.original)) {
                String right = text.substring(this.original.length());
                return this.replacement != null ? AliasPattern.join(this.replacement, right) : right;
            }
            if (line == 0) {
                return text;
            }
            throw this.ctx.exception(line, col, "The property \"" + text + "\" does not match the alias pattern \"" + this + "\", it must start with \"" + this.original + "\"");
        }
        if (this.isSuffix) {
            if (text.endsWith(this.original)) {
                String left = text.substring(0, text.length() - this.original.length());
                return this.replacement != null ? AliasPattern.join(left, this.replacement) : left;
            }
            if (line == 0) {
                return text;
            }
            throw this.ctx.exception(line, col, "The property \"" + text + "\" does not match the alias pattern \"" + this + "\", it must end with \"" + this.original + "\"");
        }
        int index = text.indexOf(this.original);
        if (index != -1) {
            String left = text.substring(0, index);
            String right = text.substring(index + this.original.length());
            return this.replacement != null ? AliasPattern.join(left, this.replacement, right) : AliasPattern.join(left, right);
        }
        if (line == 0) {
            return text;
        }
        throw this.ctx.exception(line, col, "The property \"" + text + "\" does not match the alias pattern \"" + this + "\", it must contains \"" + this.original + "\"");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isPrefix) {
            builder.append('^');
        }
        if (this.original != null) {
            builder.append(this.original);
        }
        if (this.isSuffix) {
            builder.append('$');
        }
        builder.append(" -> ");
        if (this.replacement != null) {
            builder.append(this.replacement);
        }
        return builder.toString();
    }

    static String join(String ... parts) {
        StringBuilder builder = new StringBuilder();
        boolean prevPartEndsWithLower = false;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (prevPartEndsWithLower) {
                if (Character.isUpperCase(part.charAt(0))) {
                    builder.append(part);
                } else {
                    builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
                }
            } else if (Character.isLowerCase(part.charAt(0))) {
                builder.append(part);
            } else {
                char[] arr = part.toCharArray();
                for (int i = 0; i < arr.length && !Character.isLowerCase(arr[i]); ++i) {
                    arr[i] = Character.toLowerCase(arr[i]);
                }
                builder.append(arr);
            }
            prevPartEndsWithLower = Character.isLowerCase(part.charAt(part.length() - 1));
        }
        return builder.toString();
    }
}

