/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.util;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jetbrains.annotations.Nullable;

public class ClassNames {
    private static final String[] EMPTY_STRING_ARR = new String[0];

    public static ClassName of(TypeElement typeElement, @Nullable Function<String, String> simpleNameConverter) {
        Collector collector = new Collector();
        ClassNames.collect(typeElement, collector);
        if (simpleNameConverter != null) {
            int index = collector.simpleNames.size() - 1;
            collector.simpleNames.set(index, simpleNameConverter.apply(collector.simpleNames.get(index)));
        }
        return ClassName.get((String)collector.packageName, (String)collector.simpleNames.get(0), (String[])collector.simpleNames.subList(1, collector.simpleNames.size()).toArray(EMPTY_STRING_ARR));
    }

    public static ClassName of(ClassName className, Function<String, String> simpleNameConverter) {
        ArrayList<String> simpleNames = new ArrayList<String>(className.simpleNames());
        simpleNames.set(simpleNames.size() - 1, simpleNameConverter.apply((String)simpleNames.get(simpleNames.size() - 1)));
        return ClassName.get((String)className.packageName(), (String)((String)simpleNames.get(0)), (String[])simpleNames.subList(1, simpleNames.size()).toArray(EMPTY_STRING_ARR));
    }

    private static void collect(Element element, Collector collector) {
        if (element instanceof PackageElement) {
            collector.packageName = ((PackageElement)element).getQualifiedName().toString();
            return;
        }
        collector.simpleNames.add(0, element.getSimpleName().toString());
        ClassNames.collect(element.getEnclosingElement(), collector);
    }

    private static class Collector {
        String packageName;
        final List<String> simpleNames = new ArrayList<String>();

        private Collector() {
        }
    }
}

