/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.PropsGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.apt.util.SuppressAnnotation;
import org.babyfish.jimmer.impl.util.StringUtil;

public class TableGenerator {
    private final Context context;
    private final ImmutableType type;
    private final boolean isTableEx;
    private TypeSpec.Builder typeBuilder;

    public TableGenerator(Context context, ImmutableType type, boolean isTableEx) {
        this.context = context;
        this.type = type;
        this.isTableEx = isTableEx;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateTable()).indent("    ").build().writeTo(this.context.getFiler());
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate " + (this.isTableEx ? "tableEx" : "table") + "class for '%s'", this.type.getName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateTable() {
        TypeSpec.Builder oldTypeBuilder = this.typeBuilder;
        this.typeBuilder = TypeSpec.classBuilder((String)(this.isTableEx ? this.type.getTableExClassName().simpleName() : this.type.getTableClassName().simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type));
        if (!this.isTableEx) {
            this.typeBuilder.addSuperinterface((TypeName)this.type.getPropsClassName());
        }
        if (this.isTableEx) {
            this.typeBuilder.superclass((TypeName)this.type.getTableClassName());
            this.typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_EX_PROXY_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName(), this.type.getTableClassName()}));
        } else {
            this.typeBuilder.superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPED_TABLE_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        }
        this.addInstanceField();
        this.addDefaultConstructor();
        this.addDelayedConstructor();
        this.addWrapperConstructor();
        this.addDisableJoinConstructor();
        this.addBaseTableOwnerConstructor();
        try {
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (prop.isDsl(this.isTableEx)) {
                    this.addProperty(prop, false);
                    this.addProperty(prop, true);
                }
                this.addExists(prop);
                this.addIdProperty(prop, this.type.getIdPropName(prop.getName()));
            }
            this.addAsTableEx();
            this.addDisableJoin();
            this.addBaseTableOwner();
            this.addWeakJoin(false);
            this.addWeakJoin(true);
            this.addLambdaWeakJoin(false);
            this.addLambdaWeakJoin(true);
            this.addBaseTableLambdaWeakJoin(false);
            this.addBaseTableLambdaWeakJoin(true);
            this.addRemote();
            TypeSpec typeSpec = this.typeBuilder.build();
            return typeSpec;
        }
        finally {
            this.typeBuilder = oldTypeBuilder;
        }
    }

    private void addInstanceField() {
        ClassName className = this.isTableEx ? this.type.getTableExClassName() : this.type.getTableClassName();
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)className, (String)"$", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        if (this.isTableEx) {
            builder.initializer("new $T($T.$L, (String)null)", new Object[]{className, this.type.getTableClassName(), "$"});
        } else {
            builder.initializer("new $T()", new Object[]{className});
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isTableEx) {
            builder.addStatement("super()", new Object[0]);
        } else {
            builder.addStatement("super($T.class)", new Object[]{this.type.getClassName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDelayedConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.DELAYED_OPERATION_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "delayedOperation", new Modifier[0]);
        if (this.isTableEx) {
            builder.addStatement("super(delayedOperation)", new Object[0]);
        } else {
            builder.addStatement("super($T.class, delayedOperation)", new Object[]{this.type.getClassName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addWrapperConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterizedTypeName tableTypeName = ParameterizedTypeName.get((ClassName)Constants.TABLE_IMPLEMENTOR_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()});
        builder.addParameter((TypeName)tableTypeName, "table", new Modifier[0]).addStatement("super(table)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDisableJoinConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.type.getTableClassName(), "base", new Modifier[0]).addParameter(String.class, "joinDisabledReason", new Modifier[0]).addStatement("super(base, joinDisabledReason)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBaseTableOwnerConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.type.getTableClassName(), "base", new Modifier[0]).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).addStatement("super(base, baseTableOwner)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProperty(ImmutableProp prop, boolean withJoinType) {
        MethodSpec propertyMethod = PropsGenerator.property(this.context, this.isTableEx, prop, withJoinType, true);
        if (propertyMethod != null) {
            this.typeBuilder.addMethod(propertyMethod);
        }
    }

    private void addExists(ImmutableProp prop) {
        MethodSpec existsMethod = PropsGenerator.exists(prop, true);
        if (existsMethod != null) {
            this.typeBuilder.addMethod(existsMethod);
        }
    }

    private void addIdProperty(ImmutableProp prop, String idPropName) {
        MethodSpec method = PropsGenerator.associatedIdProperty(this.context, this.isTableEx, prop, idPropName, true);
        if (method != null) {
            this.typeBuilder.addMethod(method);
        }
    }

    private void addAsTableEx() {
        ClassName tableExClassName = this.type.getTableExClassName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"asTableEx").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)tableExClassName);
        if (this.isTableEx) {
            builder.addStatement("return this", new Object[0]);
        } else {
            builder.addStatement("return new $T(this, (String)null)", new Object[]{tableExClassName});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDisableJoin() {
        ClassName selfClassName = this.isTableEx ? this.type.getTableExClassName() : this.type.getTableClassName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__disableJoin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)selfClassName).addParameter(String.class, "reason", new Modifier[0]).addStatement("return new $T(this, reason)", new Object[]{selfClassName});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBaseTableOwner() {
        ClassName selfClassName = this.isTableEx ? this.type.getTableExClassName() : this.type.getTableClassName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__baseTableOwner").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)selfClassName).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).addStatement("return new $T(this, baseTableOwner)", new Object[]{selfClassName});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addWeakJoin(boolean withJoinType) {
        if (!this.isTableEx) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"weakJoin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"TT", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})})).addTypeVariable(TypeVariableName.get((String)"WJ", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)Constants.WEAK_JOIN_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getTableClassName(), TypeVariableName.get((String)"TT")})})).returns((TypeName)TypeVariableName.get((String)"TT")).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.CLASS_CLASS_NAME, (TypeName[])new TypeName[]{TypeVariableName.get((String)"WJ")}), (String)"weakJoinType", (Modifier[])new Modifier[0]).build());
        if (withJoinType) {
            builder.addParameter(ParameterSpec.builder((TypeName)Constants.JOIN_TYPE_CLASS_NAME, (String)"joinType", (Modifier[])new Modifier[0]).build());
            builder.addAnnotation(SuppressAnnotation.suppressAllAnnotation());
        }
        if (withJoinType) {
            builder.addStatement("__beforeJoin()", new Object[0]).beginControlFlow("if (raw != null)", new Object[0]).addStatement("return (TT)$T.wrap(raw.weakJoinImplementor(weakJoinType, joinType))", new Object[]{Constants.TABLE_PROXIES_CLASS_NAME}).endControlFlow().addStatement("return (TT)$T.fluent(joinOperation(weakJoinType, joinType))", new Object[]{Constants.TABLE_PROXIES_CLASS_NAME});
        } else {
            builder.addStatement("return weakJoin(weakJoinType, JoinType.INNER)", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addLambdaWeakJoin(boolean withJoinType) {
        if (!this.isTableEx) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"weakJoin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"TT", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})})).returns((TypeName)TypeVariableName.get((String)"TT")).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.CLASS_CLASS_NAME, (TypeName[])new TypeName[]{TypeVariableName.get((String)"TT")}), (String)"targetTableType", (Modifier[])new Modifier[0]).build());
        if (withJoinType) {
            builder.addParameter(ParameterSpec.builder((TypeName)Constants.JOIN_TYPE_CLASS_NAME, (String)"joinType", (Modifier[])new Modifier[0]).build());
            builder.addAnnotation(SuppressAnnotation.suppressAllAnnotation());
        }
        builder.addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.WEAK_JOIN_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getTableClassName(), TypeVariableName.get((String)"TT")}), (String)"weakJoinLambda", (Modifier[])new Modifier[0]).build());
        if (withJoinType) {
            builder.addStatement("__beforeJoin()", new Object[0]).beginControlFlow("if (raw != null)", new Object[0]).addStatement("return (TT)$T.wrap(raw.weakJoinImplementor(targetTableType, joinType, weakJoinLambda))", new Object[]{Constants.TABLE_PROXIES_CLASS_NAME}).endControlFlow().addStatement("return (TT)$T.fluent(joinOperation(targetTableType, joinType, weakJoinLambda))", new Object[]{Constants.TABLE_PROXIES_CLASS_NAME});
        } else {
            builder.addStatement("return weakJoin(targetTableType, JoinType.INNER, weakJoinLambda)", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBaseTableLambdaWeakJoin(boolean withJoinType) {
        if (!this.isTableEx) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"weakJoin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"TT", (TypeName[])new TypeName[]{Constants.BASE_TABLE_CLASS_NAME})).returns((TypeName)TypeVariableName.get((String)"TT")).addParameter((TypeName)TypeVariableName.get((String)"TT"), "targetBaseTable", new Modifier[0]);
        if (withJoinType) {
            builder.addParameter((TypeName)Constants.JOIN_TYPE_CLASS_NAME, "joinType", new Modifier[0]);
        }
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.WEAK_JOIN_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getTableClassName(), TypeVariableName.get((String)"TT")}), "weakJoinLambda", new Modifier[0]);
        if (!withJoinType) {
            builder.addStatement("return weakJoin(targetBaseTable, $T.INNER, weakJoinLambda)", new Object[]{Constants.JOIN_TYPE_CLASS_NAME});
        } else {
            CodeBlock.Builder cb = CodeBlock.builder();
            cb.addStatement("$T lambda = $T.get(weakJoinLambda)", new Object[]{Constants.WEAK_JOIN_LAMBDA_CLASS_NAME, Constants.J_WEAK_JOIN_LAMBDA_FACTORY_CLASS_NAME});
            cb.add("$T handle = $T.of($>\n", new Object[]{Constants.WEAK_JOIN_HANDLE_CLASS_NAME, Constants.WEAK_JOIN_HANDLE_CLASS_NAME});
            cb.add("lambda,\n", new Object[0]);
            cb.add("true,\n", new Object[0]);
            cb.add("true,\n", new Object[0]);
            cb.add("($T)($T) weakJoinLambda\n$<", new Object[]{ParameterizedTypeName.get((ClassName)Constants.WEAK_JOIN_CLASS_NAME, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)Constants.TABLE_LIKE_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), ParameterizedTypeName.get((ClassName)Constants.TABLE_LIKE_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})}), ParameterizedTypeName.get((ClassName)Constants.WEAK_JOIN_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT), WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})});
            cb.addStatement(")", new Object[0]);
            cb.addStatement("return ($T) $T.of(($T) targetBaseTable, this, handle, joinType)", new Object[]{TypeVariableName.get((String)"TT"), Constants.BASE_TABLE_SYMBOLS_CLASS_NAME, Constants.BASE_TABLE_SYMBOL_CLASS_NAME});
            builder.addCode(cb.build());
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addRemote() {
        if (this.isTableEx) {
            return;
        }
        TypeSpec.Builder tmpTypeBuilder = this.typeBuilder;
        this.typeBuilder = TypeSpec.classBuilder((String)"Remote").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPED_TABLE_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        this.addRemoteConstructors();
        this.addRemoteIdProp();
        this.addRemoteAsTableEx();
        this.addRemoteDisableJoin();
        this.addRemoteBaseTableOwner();
        tmpTypeBuilder.addType(this.typeBuilder.build());
        this.typeBuilder = tmpTypeBuilder;
    }

    private void addRemoteConstructors() {
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Constants.DELAYED_OPERATION_CLASS_NAME, "delayedOperation", new Modifier[0]).addStatement("super($T.class, delayedOperation)", new Object[]{this.type.getClassName()}).build());
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_IMPLEMENTOR_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "table", new Modifier[0]).addStatement("super(table)", new Object[]{this.type.getClassName()}).build());
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.type.getRemoteTableClassName(), "base", new Modifier[0]).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).addStatement("super(base, baseTableOwner)", new Object[]{this.type.getClassName()}).build());
    }

    private void addRemoteIdProp() {
        TypeName returnType = PropsGenerator.returnTypeName(this.context, false, this.type.getIdProp());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.type.getIdProp().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addStatement("return ($L)this.<$T>get($T.$L.unwrap())", new Object[]{returnType, this.type.getIdProp().getTypeName().box(), this.type.getPropsClassName(), StringUtil.snake((String)this.type.getIdProp().getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addRemoteAsTableEx() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"asTableEx").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(Deprecated.class).returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_EX_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()})).addStatement("throw new UnsupportedOperationException()", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addRemoteDisableJoin() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__disableJoin").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)Constants.STRING_CLASS_NAME, "reason", new Modifier[0]).returns((TypeName)this.type.getRemoteTableClassName()).addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addRemoteBaseTableOwner() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__baseTableOwner").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).returns((TypeName)this.type.getRemoteTableClassName()).addStatement("return new Remote(this, baseTableOwner)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

