/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.PropsGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;

public class PropExpressionGenerator {
    private final Context context;
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    public PropExpressionGenerator(Context context, ImmutableType type) {
        this.context = context;
        this.type = type;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateImpl()).indent("    ").build().writeTo(this.context.getFiler());
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate embedded prop expression class for '%s'", this.type.getName()), ex);
        }
    }

    private TypeSpec generateImpl() {
        TypeSpec.Builder builder;
        this.typeBuilder = builder = TypeSpec.classBuilder((ClassName)this.type.getPropExpressionClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPED_EMBEDDED_PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        try {
            this.addConstructor();
            this.addBaseTableConstructor();
            this.addProps();
            this.addBaseTableOwner();
        }
        finally {
            this.typeBuilder = null;
        }
        return builder.build();
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.EMBEDDED_PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "raw", new Modifier[0]).addStatement("super(raw)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBaseTableConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.type.getPropExpressionClassName(), "base", new Modifier[0]).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).addStatement("super(base, baseTableOwner)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProps() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.typeBuilder.addMethod(PropsGenerator.property(this.context, false, prop, false, true, true));
        }
    }

    private void addBaseTableOwner() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__baseTableOwner").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)Constants.BASE_TABLE_OWNER_CLASS_NAME, "baseTableOwner", new Modifier[0]).returns((TypeName)this.type.getPropExpressionClassName()).addStatement("return new $T(this, baseTableOwner)", new Object[]{this.type.getPropExpressionClassName()});
        this.typeBuilder.addMethod(builder.build());
    }
}

