/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.dto.DtoGenerator;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.impl.util.StringUtil;

public class SerializerGenerator {
    private final DtoGenerator parentGenerator;
    private final DtoType<ImmutableType, ImmutableProp> dtoType;

    public SerializerGenerator(DtoGenerator parentGenerator) {
        this.parentGenerator = parentGenerator;
        this.dtoType = parentGenerator.dtoType;
    }

    public void generate() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Serializer").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.JSON_SERIALIZER_CLASS_NAME, (TypeName[])new TypeName[]{this.parentGenerator.getDtoClassName(null)}));
        builder.addMethod(this.newSerialize());
        this.parentGenerator.getTypeBuilder().addType(builder.build());
    }

    private MethodSpec newSerialize() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.parentGenerator.getDtoClassName(null), "input", new Modifier[0]).addParameter((TypeName)ClassName.get(JsonGenerator.class), "gen", new Modifier[0]).addParameter((TypeName)ClassName.get(SerializerProvider.class), "provider", new Modifier[0]).addException(IOException.class);
        builder.addStatement("gen.writeStartObject()", new Object[0]);
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            DtoModifier inputModifier = prop.getInputModifier();
            if (inputModifier == DtoModifier.DYNAMIC) {
                builder.beginControlFlow("if (input.$L())", new Object[]{StringUtil.identifier((String[])new String[]{"is", prop.getName(), "Loaded"})});
                builder.addStatement("provider.defaultSerializeField($S, input.$L(), gen)", new Object[]{prop.getName(), this.parentGenerator.getterName((AbstractProp)prop)});
                builder.endControlFlow();
                continue;
            }
            builder.addStatement("provider.defaultSerializeField($S, input.$L(), gen)", new Object[]{prop.getName(), this.parentGenerator.getterName((AbstractProp)prop)});
        }
        builder.addStatement("gen.writeEndObject()", new Object[0]);
        return builder.build();
    }
}

