/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.client.DocMetadata;
import org.babyfish.jimmer.apt.dto.DtoException;
import org.babyfish.jimmer.apt.dto.DtoInterfaces;
import org.babyfish.jimmer.apt.dto.InputBuilderGenerator;
import org.babyfish.jimmer.apt.dto.SerializerGenerator;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.ConverterMetadata;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.apt.util.GenericParser;
import org.babyfish.jimmer.client.ApiIgnore;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.EnumType;
import org.babyfish.jimmer.dto.compiler.LikeOption;
import org.babyfish.jimmer.dto.compiler.PropConfig;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Id;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtoGenerator {
    private static final String[] EMPTY_STR_ARR = new String[0];
    private static final String JSON_DESERIALIZE_TYPE_NAME = JsonDeserialize.class.getName();
    private static final String KOTLIN_DTO_TYPE_NAME = "org.babyfish.jimmer.kt.dto.KotlinDto";
    private final Context ctx;
    private final DocMetadata docMetadata;
    final DtoType<ImmutableType, ImmutableProp> dtoType;
    private final Document document;
    private final DtoGenerator parent;
    private final DtoGenerator root;
    private final String innerClassName;
    private final Set<String> interfaceMethodNames;
    private TypeSpec.Builder typeBuilder;

    public DtoGenerator(Context ctx, DocMetadata docMetadata, DtoType<ImmutableType, ImmutableProp> dtoType) {
        this(ctx, docMetadata, dtoType, null, null);
    }

    private DtoGenerator(Context ctx, DocMetadata docMetadata, DtoType<ImmutableType, ImmutableProp> dtoType, DtoGenerator parent, String innerClassName) {
        if (parent == null != (innerClassName == null)) {
            throw new IllegalArgumentException("The nullity values of `parent` and `innerClassName` must be same");
        }
        this.ctx = ctx;
        this.docMetadata = docMetadata;
        this.dtoType = dtoType;
        this.document = new Document(ctx, dtoType);
        this.parent = parent;
        this.root = parent != null ? parent.root : this;
        this.innerClassName = innerClassName;
        this.interfaceMethodNames = DtoInterfaces.abstractMethodNames(ctx, dtoType);
    }

    public void generate() {
        String doc;
        String simpleName = this.getSimpleName();
        this.typeBuilder = TypeSpec.classBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isImpl() && ((ImmutableType)this.dtoType.getBaseType()).isEntity()) {
            this.typeBuilder.addSuperinterface((TypeName)(this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION) ? ParameterizedTypeName.get((ClassName)Constants.JSPECIFICATION_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), ((ImmutableType)this.dtoType.getBaseType()).getTableClassName()}) : ParameterizedTypeName.get((ClassName)(this.dtoType.getModifiers().contains(DtoModifier.INPUT) ? Constants.INPUT_CLASS_NAME : Constants.VIEW_CLASS_NAME), (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()})));
        }
        if (this.isImpl() && ((ImmutableType)this.dtoType.getBaseType()).isEmbeddable()) {
            this.typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.EMBEDDABLE_DTO_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()}));
        }
        for (Object typeRef : this.dtoType.getSuperInterfaces()) {
            this.typeBuilder.addSuperinterface(DtoGenerator.getTypeName((TypeRef)typeRef));
        }
        if (this.isHibernateValidatorEnhancementRequired()) {
            this.typeBuilder.addSuperinterface((TypeName)Constants.HIBERNATE_VALIDATOR_ENHANCED_BEAN);
        }
        if (this.parent == null) {
            this.typeBuilder.addAnnotation(GeneratedAnnotation.generatedAnnotation(this.dtoType.getDtoFile()));
        } else {
            this.typeBuilder.addAnnotation(GeneratedAnnotation.generatedAnnotation());
        }
        if (this.isSerializerRequired()) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.JSON_SERIALIZE_CLASS_NAME).addMember("using", "$T.class", new Object[]{this.getDtoClassName("Serializer")}).build());
        }
        if (this.isBuildRequired()) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.JSON_DESERIALIZE_CLASS_NAME).addMember("builder", "$T.class", new Object[]{this.getDtoClassName("Builder")}).build());
        }
        if ((doc = this.document.get()) == null) {
            doc = this.baseDocComment();
        }
        if (doc != null && !doc.isEmpty()) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.DESCRIPTION_CLASS_NAME).addMember("value", "$S", new Object[]{doc}).build());
        }
        for (AnnotationMirror annotationMirror : ((ImmutableType)this.dtoType.getBaseType()).getTypeElement().getAnnotationMirrors()) {
            if (!DtoGenerator.isCopyableAnnotation(annotationMirror, this.dtoType.getAnnotations(), null)) continue;
            this.typeBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        for (Anno anno : this.dtoType.getAnnotations()) {
            if (anno.getQualifiedName().equals(KOTLIN_DTO_TYPE_NAME)) continue;
            this.typeBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (this.innerClassName != null) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
            this.addMembers();
        } else {
            this.addMembers();
        }
        if (this.innerClassName != null) {
            assert (this.parent != null);
            this.parent.typeBuilder.addType(this.typeBuilder.build());
        } else {
            try {
                JavaFile.builder((String)this.root.dtoType.getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.ctx.getFiler());
            }
            catch (IOException ex) {
                throw new GeneratorException(String.format("Cannot generate dto type '%s' for '%s'", this.dtoType.getName(), ((ImmutableType)this.dtoType.getBaseType()).getQualifiedName()), ex);
            }
        }
    }

    public String getSimpleName() {
        return this.innerClassName != null ? this.innerClassName : this.dtoType.getName();
    }

    private ClassName getDtoClassName() {
        return this.getDtoClassName(null);
    }

    ClassName getDtoClassName(String nestedClassName) {
        if (this.innerClassName != null) {
            ArrayList<String> list = new ArrayList<String>();
            this.collectNames(list);
            List<String> simpleNames = list.subList(1, list.size());
            if (nestedClassName != null) {
                simpleNames = new ArrayList(simpleNames);
                simpleNames.add(nestedClassName);
            }
            return ClassName.get((String)this.root.dtoType.getPackageName(), (String)((String)list.get(0)), (String[])simpleNames.toArray(EMPTY_STR_ARR));
        }
        if (nestedClassName == null) {
            return ClassName.get((String)this.root.dtoType.getPackageName(), (String)this.dtoType.getName(), (String[])new String[0]);
        }
        return ClassName.get((String)this.root.dtoType.getPackageName(), (String)this.dtoType.getName(), (String[])new String[]{nestedClassName});
    }

    private void addMembers() {
        boolean isSpecification = this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION);
        if (!isSpecification) {
            this.addMetadata();
        }
        if (!this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
            for (DtoProp prop : this.dtoType.getDtoProps()) {
                this.addAccessorField((DtoProp<ImmutableType, ImmutableProp>)prop);
            }
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addField((DtoProp<ImmutableType, ImmutableProp>)prop);
            this.addStateField((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addField((UserProp)prop);
        }
        this.addDefaultConstructor();
        if (!isSpecification) {
            this.addConverterConstructor();
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addAccessors((AbstractProp)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addAccessors((AbstractProp)prop);
        }
        if (this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
            this.addEntityType();
            this.addApplyTo();
        } else {
            this.addToEntity(false);
            this.addToEntity(true);
        }
        this.addHashCode();
        this.addEquals();
        this.addToString();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addSpecificationConverter((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            DtoType targetType = prop.getTargetType();
            if (targetType == null || prop.isRecursive() && !targetType.isFocusedRecursion()) continue;
            new DtoGenerator(this.ctx, this.docMetadata, (DtoType<ImmutableType, ImmutableProp>)targetType, this, this.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)prop)).generate();
        }
        if (this.isSerializerRequired()) {
            new SerializerGenerator(this).generate();
        }
        if (this.isBuildRequired()) {
            new InputBuilderGenerator(this).generate();
        }
        if (this.isHibernateValidatorEnhancementRequired()) {
            this.addHibernateValidatorEnhancement(false);
            this.addHibernateValidatorEnhancement(true);
        }
    }

    private void addMetadata() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.DTO_METADATA_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName()}), (String)"METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder().indent().add("\n", new Object[0]).add("new $T<$T, $T>(\n", new Object[]{Constants.DTO_METADATA_CLASS_NAME, ((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName()}).indent().add("$T.$L", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getFetcherClassName(), "$"}).indent();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getNextProp() != null) continue;
            this.addFetcherField((DtoProp<ImmutableType, ImmutableProp>)prop, cb);
        }
        for (DtoProp hiddenProp : this.dtoType.getHiddenFlatProps()) {
            if (((ImmutableProp)hiddenProp.getBaseProp()).isId()) continue;
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)hiddenProp, cb);
        }
        cb.add(",\n", new Object[0]).unindent().add("$T::new\n", new Object[]{this.getDtoClassName()}).unindent().unindent().add(")", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (((ImmutableProp)prop.getBaseProp()).getAnnotation(Id.class) == null) {
            PropConfig config = prop.getConfig();
            if (prop.getTargetType() != null) {
                if (prop.isRecursive()) {
                    cb.add("\n.$N(", new Object[]{StringUtil.identifier((String[])new String[]{"recursive", ((ImmutableProp)prop.getBaseProp()).getName()})});
                } else {
                    cb.add("\n.$N(", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
                }
                if (config != null) {
                    cb.add("\n$>", new Object[0]);
                }
                if (!prop.isRecursive()) {
                    cb.add("$T.METADATA.getFetcher()", new Object[]{this.getPropElementName(prop)});
                    if (config != null) {
                        cb.add(", \n", new Object[0]);
                    }
                }
            } else {
                cb.add("\n.$N(", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
            }
            if (config != null) {
                this.addConfigLambda(cb, prop);
                cb.add("$<\n", new Object[0]);
            }
            cb.add(")", new Object[0]);
        }
    }

    private void addConfigLambda(CodeBlock.Builder cb, DtoProp<ImmutableType, ImmutableProp> prop) {
        PropConfig cfg = prop.getConfig();
        assert (cfg != null);
        cb.add("cfg -> cfg$>", new Object[0]);
        if (cfg.getPredicate() != null || !cfg.getOrderItems().isEmpty()) {
            cb.add("\n.filter(it -> it$>\n", new Object[0]);
            List<Object> realPredicates = cfg.getPredicate() instanceof PropConfig.Predicate.And ? ((PropConfig.Predicate.And)cfg.getPredicate()).getPredicates() : (cfg.getPredicate() != null ? Collections.singletonList(cfg.getPredicate()) : Collections.emptyList());
            for (Object realPredicate : realPredicates) {
                cb.add(".where(\n$>", new Object[0]);
                this.addConfigPredicate(cb, (PropConfig.Predicate)realPredicate);
                cb.add("$<\n)", new Object[0]);
            }
            if (!cfg.getOrderItems().isEmpty()) {
                cb.add(".orderBy(\n$>", new Object[0]);
                boolean addComma = false;
                for (PropConfig.OrderItem orderItem : cfg.getOrderItems()) {
                    if (addComma) {
                        cb.add(",\n", new Object[0]);
                    } else {
                        addComma = true;
                    }
                    this.addPropPath(cb, orderItem.getPath());
                    cb.add(orderItem.isDesc() ? ".desc()" : ".asc()", new Object[0]);
                }
                cb.add("$<\n)", new Object[0]);
            }
            cb.add("$<\n)", new Object[0]);
        }
        if (!cfg.getFetchType().equals("AUTO")) {
            cb.add("\n.fetchType($T.$L)", new Object[]{Constants.REFERENCE_FETCH_TYPE_CLASS_NAME, cfg.getFetchType()});
        }
        if (cfg.getFilterClassName() != null) {
            String filterClassName = cfg.getFilterClassName();
            TypeElement filterTypeElement = this.ctx.getElements().getTypeElement(filterClassName);
            if (filterTypeElement == null) {
                throw new DtoException("There is no filter class: " + filterClassName);
            }
            new GenericParser("filter", filterTypeElement, "org.babyfish.jimmer.sql.fetcher.FieldFilter").parse();
            cb.add("\n.filter(new $T())", new Object[]{filterTypeElement});
        }
        if (cfg.getRecursionClassName() != null) {
            String recursionClassName = cfg.getRecursionClassName();
            TypeElement recursionTypeElement = this.ctx.getElements().getTypeElement(recursionClassName);
            if (recursionTypeElement == null) {
                throw new DtoException("There is no recursion class: " + recursionClassName);
            }
            TypeName entityTypeName = new GenericParser((String)"recursion", (TypeElement)recursionTypeElement, (String)"org.babyfish.jimmer.sql.fetcher.RecursionStrategy").parse().argumentTypeNames.get(0);
            ClassName associatedEntityTypeName = ((ImmutableType)prop.getTargetType().getBaseType()).getClassName();
            if (!associatedEntityTypeName.equals((Object)entityTypeName)) {
                throw new DtoException("The recursion class \"" + recursionClassName + "\" is illegal, it specify the generic type argument of \"org.babyfish.jimmer.sql.fetcher.RecursionStrategy\" as \"" + entityTypeName + "\", which is not associated entity type \"" + associatedEntityTypeName + "\"");
            }
            cb.add("\n.recursive(new $T())", new Object[]{recursionTypeElement});
        }
        if (cfg.getLimit() != Integer.MAX_VALUE) {
            if (cfg.getOffset() != 0) {
                cb.add("\n.limit($L, $L)", new Object[]{cfg.getLimit(), cfg.getOffset()});
            } else {
                cb.add("\n.limit($L)", new Object[]{cfg.getLimit()});
            }
        }
        if (cfg.getBatch() != 0) {
            cb.add("\n.batch($L)", new Object[]{cfg.getBatch()});
        }
        if (cfg.getDepth() != Integer.MAX_VALUE) {
            cb.add("\n.depth($L)", new Object[]{cfg.getDepth()});
        }
        cb.add("$<", new Object[0]);
    }

    private void addConfigPredicate(CodeBlock.Builder cb, PropConfig.Predicate predicate) {
        if (predicate instanceof PropConfig.Predicate.And) {
            cb.add("$T.and(\n$>", new Object[]{Constants.PREDICATE_CLASS_NAME});
            boolean addComma = false;
            for (PropConfig.Predicate subPredicate : ((PropConfig.Predicate.And)predicate).getPredicates()) {
                if (addComma) {
                    cb.add(",\n", new Object[0]);
                } else {
                    addComma = true;
                }
                this.addConfigPredicate(cb, subPredicate);
            }
            cb.add("$<\n)", new Object[0]);
        } else if (predicate instanceof PropConfig.Predicate.Or) {
            cb.add("$T.or(\n$>", new Object[]{Constants.PREDICATE_CLASS_NAME});
            boolean addComma = false;
            for (PropConfig.Predicate subPredicate : ((PropConfig.Predicate.Or)predicate).getPredicates()) {
                if (addComma) {
                    cb.add(",\n", new Object[0]);
                } else {
                    addComma = true;
                }
                this.addConfigPredicate(cb, subPredicate);
            }
            cb.add("$<\n)", new Object[0]);
        } else if (predicate instanceof PropConfig.Predicate.Cmp) {
            PropConfig.Predicate.Cmp cmp = (PropConfig.Predicate.Cmp)predicate;
            this.addPropPath(cb, cmp.getPath());
            switch (cmp.getOperator()) {
                case "=": {
                    cb.add(".eq(", new Object[0]);
                    break;
                }
                case "<>": {
                    cb.add(".ne(", new Object[0]);
                    break;
                }
                case "<": {
                    cb.add(".lt(", new Object[0]);
                    break;
                }
                case "<=": {
                    cb.add(".le(", new Object[0]);
                    break;
                }
                case ">": {
                    cb.add(".gt(", new Object[0]);
                    break;
                }
                case ">=": {
                    cb.add(".ge(", new Object[0]);
                    break;
                }
                case "like": {
                    cb.add(".like(", new Object[0]);
                    break;
                }
                case "ilike": {
                    cb.add(".ilike(", new Object[0]);
                    break;
                }
                default: {
                    throw new DtoException("Illegal operator: " + cmp.getOperator());
                }
            }
            if (cmp.getValue() instanceof String) {
                cb.add("$S)", new Object[]{cmp.getValue()});
            } else {
                String value = cmp.getValue().toString();
                TypeName typeName = ((ImmutableProp)((PropConfig.PathNode)cmp.getPath().get(cmp.getPath().size() - 1)).getProp()).getTypeName();
                if (typeName.isBoxedPrimitive()) {
                    typeName = typeName.unbox();
                }
                if (typeName.equals((Object)TypeName.LONG)) {
                    cb.add("$LL", new Object[]{value});
                } else if (typeName.equals((Object)TypeName.FLOAT)) {
                    cb.add("$LF", new Object[]{value});
                } else if (typeName.equals((Object)TypeName.DOUBLE)) {
                    cb.add("$LD", new Object[]{value});
                } else if (typeName.equals((Object)Constants.BIG_INTEGER_CLASS_NAME)) {
                    cb.add("new $T($S)", new Object[]{Constants.BIG_INTEGER_CLASS_NAME, cmp.getValue().toString()});
                } else if (typeName.equals((Object)Constants.BIG_DECIMAL_CLASS_NAME)) {
                    cb.add("new $T($S)", new Object[]{Constants.BIG_DECIMAL_CLASS_NAME, cmp.getValue().toString()});
                } else {
                    cb.add("$L", new Object[]{value});
                }
                cb.add(")", new Object[0]);
            }
        } else if (predicate instanceof PropConfig.Predicate.Nullity) {
            PropConfig.Predicate.Nullity nullity = (PropConfig.Predicate.Nullity)predicate;
            this.addPropPath(cb, nullity.getPath());
            cb.add(nullity.isNegative() ? ".isNotNull()" : ".isNull()", new Object[0]);
        } else {
            throw new DtoException("Illegal predicate: " + predicate.getClass().getName());
        }
    }

    private void addPropPath(CodeBlock.Builder cb, List<PropConfig.PathNode<ImmutableProp>> pathNodes) {
        cb.add("it.getTable()", new Object[0]);
        for (PropConfig.PathNode<ImmutableProp> pathNode : pathNodes) {
            if (pathNode.isAssociatedId()) {
                cb.add(".$LId()", new Object[]{((ImmutableProp)pathNode.getProp()).getName()});
                continue;
            }
            cb.add(".$L()", new Object[]{((ImmutableProp)pathNode.getProp()).getName()});
        }
    }

    private void addAccessorField(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (this.isSimpleProp(prop)) {
            return;
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)Constants.DTO_PROP_ACCESSOR_CLASS_NAME, (String)StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.add("new $T(", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME});
        cb.indent();
        DtoProp tailProp = prop.toTailProp();
        if (prop.isNullable() && (!((ImmutableProp)prop.toTailProp().getBaseProp()).isNullable() || this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION) || this.dtoType.getModifiers().contains(DtoModifier.FUZZY) || prop.getInputModifier() == DtoModifier.FUZZY)) {
            cb.add("\nfalse", new Object[0]);
        } else {
            cb.add("\ntrue", new Object[0]);
        }
        if (prop.getNextProp() == null) {
            cb.add(",\nnew int[] { $T.$L }", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getProducerClassName(), ((ImmutableProp)prop.getBaseProp()).getSlotName()});
        } else {
            cb.add(",\nnew int[] {", new Object[0]);
            cb.indent();
            boolean addComma = false;
            for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                if (addComma) {
                    cb.add(",", new Object[0]);
                } else {
                    addComma = true;
                }
                cb.add("\n$T.$L", new Object[]{((ImmutableProp)p.getBaseProp()).getDeclaringType().getProducerClassName(), ((ImmutableProp)p.getBaseProp()).getSlotName()});
            }
            cb.unindent();
            cb.add("\n}", new Object[0]);
        }
        if (prop.isIdOnly()) {
            if (this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\n$T.$L($T.class, ", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "idListGetter" : "idReferenceGetter", ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName()});
                this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, false);
                cb.add(")", new Object[0]);
                cb.add(",\n$T.$L($T.class, ", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "idListSetter" : "idReferenceSetter", ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName()});
                this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, false);
                cb.add(")", new Object[0]);
            }
        } else if (tailProp.getTargetType() != null) {
            if (this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\n$T.<$T, $T>$L($T::new)", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp), ((ImmutableProp)tailProp.getBaseProp()).isList() ? "objectListGetter" : "objectReferenceGetter", this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp)});
                cb.add(",\n$T.$L($T::$L)", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "objectListSetter" : "objectReferenceSetter", this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp), ((ImmutableType)tailProp.getTargetType().getBaseType()).isEntity() ? "toEntity" : "toImmutable"});
            }
        } else if (prop.getEnumType() != null) {
            EnumType enumType = prop.getEnumType();
            TypeName enumTypeName = ((ImmutableProp)tailProp.getBaseProp()).getTypeName();
            if (this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\narg -> {\n", new Object[0]);
                cb.indent();
                cb.beginControlFlow("switch (($T)arg)", new Object[]{enumTypeName});
                for (Map.Entry e : enumType.getValueMap().entrySet()) {
                    cb.add("case $L:\n", new Object[]{e.getKey()});
                    cb.indent();
                    cb.addStatement("return $L", new Object[]{e.getValue()});
                    cb.unindent();
                }
                cb.add("default:\n", new Object[0]);
                cb.indent();
                cb.addStatement("throw new AssertionError($S)", new Object[]{"Internal bug"});
                cb.unindent();
                cb.endControlFlow();
                cb.unindent();
                cb.add("}", new Object[0]);
            }
            cb.add(",\narg -> {\n", new Object[0]);
            cb.indent();
            this.addValueToEnum(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, "arg");
            cb.unindent();
            cb.add("}", new Object[0]);
        } else if (this.converterMetadataOf(prop) != null) {
            cb.add(",\narg -> ", new Object[0]);
            this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, true);
            cb.add(".output(arg)", new Object[0]);
            cb.add(",\narg -> ", new Object[0]);
            this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, true);
            cb.add(".input(arg)", new Object[0]);
        }
        cb.unindent();
        cb.add("\n)", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addValueToEnum(CodeBlock.Builder cb, DtoProp<ImmutableType, ImmutableProp> prop, String variableName) {
        EnumType enumType = prop.getEnumType();
        TypeName enumTypeName = ((ImmutableProp)prop.toTailProp().getBaseProp()).getTypeName();
        cb.beginControlFlow("switch (($T)$L)", new Object[]{enumType.isNumeric() ? TypeName.INT : Constants.STRING_CLASS_NAME, variableName});
        for (Map.Entry e : enumType.getConstantMap().entrySet()) {
            cb.add("case $L:\n", new Object[]{e.getKey()});
            cb.indent();
            cb.addStatement("return $T.$L", new Object[]{enumTypeName, e.getValue()});
            cb.unindent();
        }
        cb.add("default:\n", new Object[0]);
        cb.indent();
        cb.addStatement("throw new IllegalArgumentException($S + $L + $S)", new Object[]{"Illegal value `\"", variableName, "\"`for enum type: \"" + enumTypeName + "\""});
        cb.unindent();
        cb.endControlFlow();
    }

    private void addConverterLoading(CodeBlock.Builder cb, DtoProp<ImmutableType, ImmutableProp> prop, boolean forList) {
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        cb.add("$T.$L.unwrap().$L", new Object[]{baseProp.getDeclaringType().getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), ((ImmutableProp)prop.toTailProp().getBaseProp()).isAssociation(true) ? "getAssociatedIdConverter(" + forList + ")" : "getConverter()"});
    }

    private boolean isSimpleProp(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (prop.getNextProp() != null) {
            return false;
        }
        if (prop.isNullable() && (!prop.isBaseNullable() || this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) || ((ImmutableProp)prop.getBaseProp()).getConverterMetadata() != null && !this.dtoType.getModifiers().contains(DtoModifier.INPUT) && !this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
            return false;
        }
        return this.getPropTypeName(prop).equals((Object)((ImmutableProp)prop.getBaseProp()).getTypeName());
    }

    private void addHiddenFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (!"flat".equals(prop.getFuncName())) {
            this.addFetcherField(prop, cb);
            return;
        }
        DtoType targetDtoType = prop.getTargetType();
        assert (targetDtoType != null);
        cb.add("\n.$N($>", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
        cb.add("$T.$L$>", new Object[]{((ImmutableProp)prop.getBaseProp()).getTargetType().getFetcherClassName(), "$"});
        for (DtoProp childProp : targetDtoType.getDtoProps()) {
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)childProp, cb);
        }
        cb.add("$<$<\n)", new Object[0]);
    }

    private void addField(DtoProp<ImmutableType, ImmutableProp> prop) {
        TypeName typeName = this.getPropTypeName(prop);
        if (DtoGenerator.isFieldNullable(prop)) {
            typeName = typeName.box();
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{this.ctx.getDtoFieldModifier()});
        String doc = this.doc((AbstractProp)prop, true);
        if (doc != null) {
            builder.addJavadoc(doc, new Object[0]);
        }
        if (this.dtoType.getModifiers().contains(DtoModifier.INPUT) && prop.getInputModifier() == DtoModifier.FIXED) {
            builder.addAnnotation(Constants.FIXED_INPUT_FIELD_CLASS_NAME);
        }
        boolean isBuilderRequired = this.isBuildRequired();
        for (AnnotationMirror annotationMirror : ((ImmutableProp)prop.toTailProp().getBaseProp()).getAnnotations()) {
            String qualifiedName;
            if (isBuilderRequired && (qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString()).equals(JSON_DESERIALIZE_TYPE_NAME) || !DtoGenerator.isCopyableAnnotation(annotationMirror, this.dtoType.getAnnotations(), false)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        for (Anno anno : prop.getAnnotations()) {
            if (isBuilderRequired && anno.getQualifiedName().equals(JSON_DESERIALIZE_TYPE_NAME) || !this.hasElementType(anno, ElementType.FIELD)) continue;
            builder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addField(UserProp prop) {
        String doc;
        TypeName typeName = this.getPropTypeName((AbstractProp)prop);
        if (DtoGenerator.isFieldNullable((AbstractProp)prop)) {
            typeName = typeName.box();
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getAlias(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{this.ctx.getDtoFieldModifier()});
        if (prop.getDefaultValueText() != null) {
            builder.initializer(prop.getDefaultValueText(), new Object[0]);
        }
        if ((doc = this.doc((AbstractProp)prop, true)) != null) {
            builder.addJavadoc(doc, new Object[0]);
        }
        for (Anno anno : prop.getAnnotations()) {
            if (!this.hasElementType(anno, ElementType.FIELD)) continue;
            builder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addStateField(DtoProp<ImmutableType, ImmutableProp> prop) {
        String stateFieldName = this.stateFieldName((AbstractProp)prop, false);
        if (stateFieldName == null) {
            return;
        }
        this.typeBuilder.addField(TypeName.BOOLEAN, stateFieldName, new Modifier[]{this.ctx.getDtoFieldModifier()});
    }

    private void addAccessors(AbstractProp prop) {
        String doc;
        TypeName typeName = this.getPropTypeName(prop);
        String getterName = this.getterName(prop);
        String setterName = this.setterName(prop);
        String stateFieldName = this.stateFieldName(prop, false);
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName);
        if (this.interfaceMethodNames.contains(getterName)) {
            getterBuilder.addAnnotation(Override.class);
        }
        if (!(prop instanceof DtoProp && ((DtoProp)prop).getNextProp() != null || (doc = this.doc(prop, false)) == null || doc.isEmpty())) {
            getterBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.DESCRIPTION_CLASS_NAME).addMember("value", "$S", new Object[]{doc}).build());
        }
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                getterBuilder.addAnnotation(Nullable.class);
            } else {
                getterBuilder.addAnnotation(NotNull.class);
            }
        }
        boolean isBuilderRequired = this.isBuildRequired();
        if (prop instanceof DtoProp) {
            DtoProp dtoProp = (DtoProp)prop;
            for (AnnotationMirror annotationMirror : ((ImmutableProp)dtoProp.toTailProp().getBaseProp()).getAnnotations()) {
                String qualifiedName;
                if (isBuilderRequired && (qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString()).equals(JSON_DESERIALIZE_TYPE_NAME) || !DtoGenerator.isCopyableAnnotation(annotationMirror, dtoProp.getAnnotations(), true)) continue;
                getterBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
        }
        for (Anno anno : prop.getAnnotations()) {
            if (isBuilderRequired && anno.getQualifiedName().equals(JSON_DESERIALIZE_TYPE_NAME) || !this.hasElementType(anno, ElementType.METHOD)) continue;
            getterBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (stateFieldName != null) {
            getterBuilder.beginControlFlow("if ($L)", new Object[]{'!' + stateFieldName});
            getterBuilder.addStatement("throw new IllegalStateException($S)", new Object[]{"The property \"" + prop.getName() + "\" is not specified"});
            getterBuilder.endControlFlow();
        }
        if (!prop.isNullable() && DtoGenerator.isFieldNullable(prop)) {
            getterBuilder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
            if (this.dtoType.getModifiers().contains(DtoModifier.INPUT) && typeName instanceof ParameterizedTypeName && Constants.LIST_CLASS_NAME.equals((Object)((ParameterizedTypeName)typeName).rawType)) {
                getterBuilder.addComment("GraphQLInput requires `obj." + getterName + "().add(...)`", new Object[0]);
                getterBuilder.addStatement("return this.$L = new $T<>()", new Object[]{prop.getName(), Constants.ARRAY_LIST_CLASS_NAME});
            } else {
                getterBuilder.addStatement("throw new IllegalStateException($S)", new Object[]{"The property \"" + prop.getName() + "\" is not specified"});
            }
            getterBuilder.endControlFlow();
        }
        getterBuilder.addStatement("return $L", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(getterBuilder.build());
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]);
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                parameterBuilder.addAnnotation(Nullable.class);
            } else {
                parameterBuilder.addAnnotation(NotNull.class);
            }
        }
        MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)setterName).addParameter(parameterBuilder.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.interfaceMethodNames.contains(setterName)) {
            setterBuilder.addAnnotation(Override.class);
        }
        setterBuilder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
        if (stateFieldName != null) {
            setterBuilder.addStatement("this.$L = true", new Object[]{stateFieldName});
        }
        this.typeBuilder.addMethod(setterBuilder.build());
        if (stateFieldName != null) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{"is", prop.getName(), "Loaded"})).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(ApiIgnore.class).addAnnotation(JsonIgnore.class).addStatement("return this.$L", new Object[]{stateFieldName});
            this.typeBuilder.addMethod(builder.build());
            MethodSpec.Builder setLoadedBuilder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{"set", prop.getName(), "Loaded"})).addParameter(TypeName.BOOLEAN, "loaded", new Modifier[0]).addStatement("this.$L = loaded", new Object[]{stateFieldName});
            this.typeBuilder.addMethod(setLoadedBuilder.build());
        }
    }

    private String doc(AbstractProp prop, boolean contentOnly) {
        DtoProp dtoProp;
        String doc = this.document.get(prop);
        if (doc == null & prop instanceof DtoProp && (dtoProp = (DtoProp)prop).getBasePropMap().isEmpty() && dtoProp.getFuncName() == null) {
            doc = this.baseDocComment((ImmutableProp)dtoProp.toTailProp().getBaseProp());
        }
        if (doc == null) {
            return null;
        }
        if (contentOnly) {
            int index = -1;
            index = DtoGenerator.docKeyIndex(index, doc, "@param");
            index = DtoGenerator.docKeyIndex(index, doc, "@return");
            index = DtoGenerator.docKeyIndex(index, doc, "@exception");
            index = DtoGenerator.docKeyIndex(index, doc, "@throws");
            if ((index = DtoGenerator.docKeyIndex(index, doc, "@see")) != -1) {
                doc = doc.substring(0, index);
            }
        }
        return doc;
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConverterConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(NotNull.class).build());
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (this.isSimpleProp((DtoProp<ImmutableType, ImmutableProp>)prop)) {
                if (prop.isNullable()) {
                    builder.addStatement("this.$L = (($T)base).__isLoaded($T.byIndex($T.$L)) ? base.$L() : null", new Object[]{prop.getName(), ImmutableSpi.class, Constants.PROP_ID_CLASS_NAME, ((ImmutableType)this.dtoType.getBaseType()).getProducerClassName(), ((ImmutableProp)prop.getBaseProp()).getSlotName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                    continue;
                }
                builder.addStatement("this.$L = base.$L()", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                continue;
            }
            if (!prop.isNullable() && prop.isBaseNullable()) {
                builder.addStatement("this.$L = $L.get($>\nbase,\n$S\n$<)", new Object[]{prop.getName(), StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), "Cannot convert \"" + ((ImmutableType)this.dtoType.getBaseType()).getClassName() + "\" to \"" + this.getDtoClassName() + "\" because the cannot get non-null value for \"" + prop.getName() + "\""});
                continue;
            }
            builder.addStatement("this.$L = $L.get(base)", new Object[]{prop.getName(), StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToEntity(boolean withId) {
        ImmutableProp baseIdProp;
        boolean idOverridable;
        boolean bl = idOverridable = this.dtoType.getModifiers().contains(DtoModifier.INPUT) && ((ImmutableType)this.dtoType.getBaseType()).isEntity();
        if (withId && !idOverridable) {
            return;
        }
        ImmutableProp immutableProp = baseIdProp = withId ? ((ImmutableType)this.dtoType.getBaseType()).getIdProp() : null;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(((ImmutableType)this.dtoType.getBaseType()).isEntity() ? (withId ? "toEntityById" : "toEntity") : "toImmutable"));
        if (baseIdProp != null) {
            builder.addParameter(ParameterSpec.builder((TypeName)baseIdProp.getTypeName().box(), (String)"id", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        } else {
            builder.addAnnotation(Override.class);
        }
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName());
        if (!withId && idOverridable) {
            builder.addStatement("return toEntityById(null)", new Object[0]);
        } else {
            builder.addCode("return $T.$L.produce(__draft -> {$>\n", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getDraftClassName(), "$"});
            for (DtoProp prop : this.dtoType.getDtoProps()) {
                boolean fuzzy;
                if (((ImmutableProp)prop.getBaseProp()).isJavaFormula()) continue;
                String stateFieldName = this.stateFieldName((AbstractProp)prop, false);
                boolean bl2 = fuzzy = prop.getInputModifier() == DtoModifier.FUZZY && prop.isNullable();
                if (stateFieldName != null) {
                    builder.beginControlFlow("if (this.$L)", new Object[]{stateFieldName});
                } else if (fuzzy) {
                    builder.beginControlFlow("if (this.$L != null)", new Object[]{prop.getName()});
                }
                if (this.isSimpleProp((DtoProp<ImmutableType, ImmutableProp>)prop)) {
                    builder.addStatement("__draft.$L(this.$L)", new Object[]{((ImmutableProp)prop.getBaseProp()).getSetterName(), prop.getName()});
                } else {
                    ImmutableProp tailBaseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
                    if (tailBaseProp.isList() && tailBaseProp.isAssociation(true)) {
                        builder.addStatement("$L.set(__draft, this.$L != null ? this.$L : $T.emptyList())", new Object[]{StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), prop.getName(), prop.getName(), Constants.COLLECTIONS_CLASS_NAME});
                    } else {
                        builder.addStatement("$L.set(__draft, this.$L)", new Object[]{StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), prop.getName()});
                    }
                }
                if (stateFieldName == null && !fuzzy) continue;
                builder.endControlFlow();
            }
            if (baseIdProp != null) {
                builder.beginControlFlow("if (id != null)", new Object[0]);
                builder.addStatement("__draft.$L($L)", new Object[]{baseIdProp.getSetterName(), "id"});
                builder.endControlFlow();
            }
            builder.addCode("$<});\n", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEntityType() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"entityType").returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.CLASS_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T.class", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()});
        if (this.isImpl()) {
            builder.addAnnotation(Override.class);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addApplyTo() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"applyTo").addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isImpl()) {
            builder.addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.SPECIFICATION_ARGS_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), ((ImmutableType)this.dtoType.getBaseType()).getTableClassName()}), (String)"args", (Modifier[])new Modifier[0]).build());
        } else {
            builder.addParameter(ParameterSpec.builder((TypeName)Constants.PREDICATE_APPLIER_CLASS_NAME, (String)"__applier", (Modifier[])new Modifier[0]).build());
        }
        List<ImmutableProp> stack = Collections.emptyList();
        if (this.isImpl()) {
            builder.addStatement("$T __applier = args.getApplier()", new Object[]{Constants.PREDICATE_APPLIER_CLASS_NAME});
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            ArrayList<ImmutableProp> newStack = new ArrayList<ImmutableProp>(stack.size() + 2);
            DtoProp tailProp = prop.toTailProp();
            for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                if (p == tailProp && p.getTargetType() == null) continue;
                newStack.add((ImmutableProp)p.getBaseProp());
            }
            stack = this.addStackOperations(builder, stack, newStack);
            this.addPredicateOperation(builder, (DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        this.addStackOperations(builder, stack, Collections.emptyList());
        this.typeBuilder.addMethod(builder.build());
    }

    private List<ImmutableProp> addStackOperations(MethodSpec.Builder builder, List<ImmutableProp> stack, List<ImmutableProp> newStack) {
        int i;
        int size;
        int sameCount = size = Math.min(stack.size(), newStack.size());
        for (i = 0; i < size; ++i) {
            if (stack.get(i) == newStack.get(i)) continue;
            sameCount = i;
            break;
        }
        for (i = stack.size() - sameCount; i > 0; --i) {
            builder.addStatement("__applier.pop()", new Object[0]);
        }
        for (ImmutableProp prop : newStack.subList(sameCount, newStack.size())) {
            builder.addStatement("__applier.push($T.$L.unwrap())", new Object[]{prop.getDeclaringType().getPropsClassName(), StringUtil.snake((String)prop.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        return newStack;
    }

    private void addPredicateOperation(MethodSpec.Builder builder, DtoProp<ImmutableType, ImmutableProp> prop) {
        String funcName;
        String propName = prop.getName();
        DtoProp tailProp = prop.toTailProp();
        if (tailProp.getTargetType() != null) {
            builder.beginControlFlow("if (this.$L != null)", new Object[]{propName});
            if (((ImmutableType)tailProp.getTargetType().getBaseType()).isEntity()) {
                builder.addStatement("this.$L.applyTo(args.child())", new Object[]{propName});
            } else {
                builder.addStatement("this.$L.applyTo(args.getApplier())", new Object[]{propName});
            }
            builder.endControlFlow();
            return;
        }
        String javaMethodName = funcName = tailProp.getFuncName();
        if (funcName == null) {
            funcName = "eq";
            javaMethodName = "eq";
        } else if ("null".equals(funcName)) {
            javaMethodName = "isNull";
        } else if ("notNull".equals(funcName)) {
            javaMethodName = "isNotNull";
        } else if ("id".equals(funcName)) {
            funcName = "associatedIdEq";
            javaMethodName = "associatedIdEq";
        }
        CodeBlock.Builder cb = CodeBlock.builder();
        if (org.babyfish.jimmer.dto.compiler.Constants.MULTI_ARGS_FUNC_NAMES.contains(funcName)) {
            cb.add("__applier.$L(new $T[] { ", new Object[]{javaMethodName, Constants.IMMUTABLE_PROP_CLASS_NAME});
            boolean addComma = false;
            for (ImmutableProp baseProp : tailProp.getBasePropMap().values()) {
                if (addComma) {
                    cb.add(", ", new Object[0]);
                } else {
                    addComma = true;
                }
                cb.add("$T.$L.unwrap()", new Object[]{baseProp.getDeclaringType().getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
            }
            cb.add(" }, ", new Object[0]);
        } else {
            cb.add("__applier.$L($T.$L.unwrap(), ", new Object[]{funcName, ((ImmutableProp)tailProp.getBaseProp()).getDeclaringType().getPropsClassName(), StringUtil.snake((String)((ImmutableProp)tailProp.getBaseProp()).getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        if (this.isSpecificationConverterRequired((DtoProp<ImmutableType, ImmutableProp>)tailProp)) {
            cb.add("$L(this.$L)", new Object[]{StringUtil.identifier((String[])new String[]{"__convert", propName}), propName});
        } else {
            cb.add("this.$L", new Object[]{propName});
        }
        if ("like".equals(funcName) || "notLike".equals(funcName)) {
            cb.add(", ", new Object[0]);
            cb.add(tailProp.getLikeOptions().contains(LikeOption.INSENSITIVE) ? "true" : "false", new Object[0]);
            cb.add(", ", new Object[0]);
            cb.add(tailProp.getLikeOptions().contains(LikeOption.MATCH_START) ? "true" : "false", new Object[0]);
            cb.add(", ", new Object[0]);
            cb.add(tailProp.getLikeOptions().contains(LikeOption.MATCH_END) ? "true" : "false", new Object[0]);
        }
        cb.addStatement(")", new Object[0]);
        builder.addCode(cb.build());
    }

    private void addSpecificationConverter(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (!this.isSpecificationConverterRequired(prop)) {
            return;
        }
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        TypeName baseTypeName = null;
        String funcName = prop.getFuncName();
        if (funcName != null) {
            switch (funcName) {
                case "id": {
                    baseTypeName = baseProp.getTargetType().getIdProp().getTypeName();
                    if (!baseProp.isList() || this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) break;
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseTypeName.box()});
                    break;
                }
                case "null": 
                case "notNull": {
                    baseTypeName = TypeName.BOOLEAN;
                    break;
                }
                case "valueIn": 
                case "valueNotIn": {
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTypeName().box()});
                    break;
                }
                case "associatedIdEq": 
                case "associatedIdNe": {
                    baseTypeName = baseProp.getTargetType().getIdProp().getTypeName();
                    break;
                }
                case "associatedIdIn": 
                case "associatedIdNotIn": {
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTargetType().getIdProp().getTypeName().box()});
                }
            }
        }
        if (baseTypeName == null) {
            baseTypeName = baseProp.getTypeName();
        }
        baseTypeName = baseTypeName.box();
        TypeName dtoPropTypeName = this.getPropTypeName(prop);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{"__convert", prop.getName()})).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(dtoPropTypeName, "value", new Modifier[0]).returns(baseTypeName);
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
        cb.addStatement("return null", new Object[0]);
        cb.endControlFlow();
        if (prop.getEnumType() != null) {
            this.addValueToEnum(cb, prop, "value");
        } else {
            cb.addStatement("return $T.$L.unwrap().<$T, $T>$L.input(value)", new Object[]{baseProp.getDeclaringType().getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), baseTypeName, this.getPropTypeName(prop).box(), baseProp.isAssociation(true) ? "getAssociatedIdConverter(true)" : "getConverter(" + (prop.isFunc(new String[]{"valueIn", "valueNotIn"}) ? "true" : "") + ")"});
        }
        builder.addCode(cb.build());
        this.typeBuilder.addMethod(builder.build());
    }

    private void addHibernateValidatorEnhancement(boolean getter) {
        String methodName = "$$_hibernateValidator_get" + (getter ? "Getter" : "Field") + "Value";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)Constants.STRING_CLASS_NAME, "name", new Modifier[0]).returns((TypeName)TypeName.OBJECT).beginControlFlow("switch (name)", new Object[0]);
        for (AbstractProp prop : this.dtoType.getProps()) {
            builder.addStatement("case $S: return $L", new Object[]{getter ? StringUtil.identifier((String[])new String[]{this.getPropTypeName(prop) == TypeName.BOOLEAN ? "is" : "get", prop.getName()}) : prop.getName(), prop.getName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + name + $S)", new Object[]{"No " + (getter ? "getter" : "field") + " named \"", "\""}).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    public TypeName getPropTypeName(AbstractProp prop) {
        if (prop instanceof DtoProp) {
            return this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)((DtoProp)prop));
        }
        return DtoGenerator.getTypeName(((UserProp)prop).getTypeRef());
    }

    private TypeName getPropTypeName(DtoProp<ImmutableType, ImmutableProp> prop) {
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        EnumType enumType = prop.getEnumType();
        if (enumType != null) {
            if (enumType.isNumeric()) {
                return prop.isNullable() ? TypeName.INT.box() : TypeName.INT;
            }
            return Constants.STRING_CLASS_NAME;
        }
        ConverterMetadata metadata = this.converterMetadataOf(prop);
        TypeName propElementName = this.getPropElementName(prop);
        if (this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
            String funcName = prop.toTailProp().getFuncName();
            if (funcName != null) {
                switch (funcName) {
                    case "null": 
                    case "notNull": {
                        return TypeName.BOOLEAN;
                    }
                    case "valueIn": 
                    case "valueNotIn": {
                        return ParameterizedTypeName.get((ClassName)Constants.COLLECTION_CLASS_NAME, (TypeName[])new TypeName[]{metadata != null ? metadata.getTargetTypeName() : DtoGenerator.toListType(propElementName, baseProp.isList())});
                    }
                    case "id": 
                    case "associatedIdEq": 
                    case "associatedIdNe": {
                        TypeName clientTypeName = baseProp.getTargetType().getIdProp().getClientTypeName();
                        if (prop.isNullable()) {
                            return clientTypeName.box();
                        }
                        return clientTypeName;
                    }
                    case "associatedIdIn": 
                    case "associatedIdNotIn": {
                        return ParameterizedTypeName.get((ClassName)Constants.COLLECTION_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTargetType().getIdProp().getClientTypeName().box()});
                    }
                }
            }
            if (baseProp.isAssociation(true)) {
                return propElementName;
            }
        }
        if (metadata != null) {
            return metadata.getTargetTypeName();
        }
        return DtoGenerator.toListType(propElementName, baseProp.isList() && (!(propElementName instanceof ParameterizedTypeName) || !((ParameterizedTypeName)propElementName).rawType.equals((Object)Constants.LIST_CLASS_NAME)));
    }

    private static TypeName toListType(TypeName typeName, boolean isList) {
        return isList ? ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()}) : typeName;
    }

    private static TypeName getTypeName(@Nullable TypeRef typeRef) {
        return DtoGenerator.getTypeName(typeRef, false);
    }

    private static TypeName getTypeName(@Nullable TypeRef typeRef, boolean toBoxType) {
        ClassName typeName;
        if (typeRef == null) {
            return WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT);
        }
        switch (typeRef.getTypeName()) {
            case "Boolean": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.BOOLEAN.box() : TypeName.BOOLEAN;
                break;
            }
            case "Char": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.CHAR.box() : TypeName.CHAR;
                break;
            }
            case "Byte": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.BYTE.box() : TypeName.BYTE;
                break;
            }
            case "Short": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.SHORT.box() : TypeName.SHORT;
                break;
            }
            case "Int": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.INT.box() : TypeName.INT;
                break;
            }
            case "Long": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.LONG.box() : TypeName.LONG;
                break;
            }
            case "Float": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.FLOAT.box() : TypeName.FLOAT;
                break;
            }
            case "Double": {
                typeName = toBoxType || typeRef.isNullable() ? TypeName.DOUBLE.box() : TypeName.DOUBLE;
                break;
            }
            case "Any": {
                typeName = TypeName.OBJECT;
                break;
            }
            case "String": {
                typeName = Constants.STRING_CLASS_NAME;
                break;
            }
            case "Array": {
                typeName = ArrayTypeName.of((TypeName)(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef() == null ? TypeName.OBJECT : DtoGenerator.getTypeName(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef(), false)));
                break;
            }
            case "Iterable": 
            case "MutableIterable": {
                typeName = ClassName.get(Iterable.class);
                break;
            }
            case "Collection": 
            case "MutableCollection": {
                typeName = ClassName.get(Collection.class);
                break;
            }
            case "List": 
            case "MutableList": {
                typeName = ClassName.get(List.class);
                break;
            }
            case "Set": 
            case "MutableSet": {
                typeName = ClassName.get(Set.class);
                break;
            }
            case "Map": 
            case "MutableMap": {
                typeName = ClassName.get(Map.class);
                break;
            }
            default: {
                typeName = ClassName.bestGuess((String)typeRef.getTypeName());
            }
        }
        int argCount = typeRef.getArguments().size();
        if (argCount == 0 || typeName instanceof ArrayTypeName) {
            return typeName;
        }
        TypeName[] argTypeNames = new TypeName[argCount];
        for (int i = 0; i < argCount; ++i) {
            TypeRef.Argument arg = (TypeRef.Argument)typeRef.getArguments().get(i);
            TypeName argTypeName = DtoGenerator.getTypeName(arg.getTypeRef(), true);
            if (arg.isIn()) {
                argTypeName = WildcardTypeName.supertypeOf((TypeName)argTypeName);
            } else if (arg.getTypeRef() != null && (arg.isOut() || DtoGenerator.isForceOut(typeRef.getTypeName()))) {
                argTypeName = WildcardTypeName.subtypeOf((TypeName)argTypeName);
            }
            argTypeNames[i] = argTypeName;
        }
        return ParameterizedTypeName.get((ClassName)typeName, (TypeName[])argTypeNames);
    }

    private void addHashCode() {
        TypeName typeName;
        CodeBlock.Builder cb;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.INT);
        boolean first = true;
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            cb = CodeBlock.builder();
            if (first) {
                cb.add("int hash = ", new Object[0]);
                first = false;
            } else {
                cb.add("hash = hash * 31 + ", new Object[0]);
            }
            typeName = this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)prop);
            if (typeName.isPrimitive()) {
                cb.add("$T.hashCode($L)", new Object[]{typeName.box(), prop.getName().equals("hash") ? "this." + prop.getName() : prop.getName()});
            } else if (typeName instanceof ArrayTypeName) {
                cb.add("$T.hashCode($L)", new Object[]{Arrays.class, prop.getName()});
            } else {
                cb.add("$T.hashCode($L)", new Object[]{Objects.class, prop.getName()});
            }
            builder.addStatement(cb.build());
            String stateFieldName = this.stateFieldName((AbstractProp)prop, false);
            if (stateFieldName == null) continue;
            builder.addStatement("hash = hash * 31 + Boolean.hashCode($L)", new Object[]{stateFieldName});
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            cb = CodeBlock.builder();
            if (first) {
                cb.add("int hash = ", new Object[0]);
                first = false;
            } else {
                cb.add("hash = hash * 31 + ", new Object[0]);
            }
            typeName = DtoGenerator.getTypeName(prop.getTypeRef());
            if (typeName.isPrimitive()) {
                cb.add("$T.hashCode($L)", new Object[]{typeName.box(), prop.getAlias().equals("hash") ? "this." + prop.getAlias() : prop.getAlias()});
            } else if (typeName instanceof ArrayTypeName) {
                cb.add("$T.hashCode($L)", new Object[]{Arrays.class, prop.getName()});
            } else {
                cb.add("$T.hashCode($L)", new Object[]{Objects.class, prop.getAlias()});
            }
            builder.addStatement(cb.build());
        }
        builder.addStatement(first ? "return 0" : "return hash", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEquals() {
        String propName;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeName.OBJECT, "o", new Modifier[0]).addAnnotation(Override.class).returns(TypeName.BOOLEAN);
        builder.beginControlFlow("if (o == null || this.getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow();
        builder.addStatement("$L other = ($L) o", new Object[]{this.getSimpleName(), this.getSimpleName()});
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            propName = prop.getName();
            String stateFieldName = this.stateFieldName((AbstractProp)prop, false);
            if (stateFieldName != null) {
                builder.beginControlFlow("if ($L != other.$L)", new Object[]{stateFieldName, stateFieldName});
                builder.addStatement("return false", new Object[0]);
                builder.endControlFlow();
            }
            String thisProp = propName.equals("o") || propName.equals("other") ? "this" + propName : propName;
            TypeName typeName = this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)prop);
            if (stateFieldName != null) {
                if (typeName.isPrimitive() && !DtoGenerator.isFieldNullable((AbstractProp)prop)) {
                    builder.beginControlFlow("if ($L && $L != other.$L)", new Object[]{stateFieldName, thisProp, propName});
                } else {
                    builder.beginControlFlow("if ($L && !$T.equals($L, other.$L))", new Object[]{stateFieldName, Objects.class, thisProp, propName});
                }
            } else if (typeName.isPrimitive() && !DtoGenerator.isFieldNullable((AbstractProp)prop)) {
                builder.beginControlFlow("if ($L != other.$L)", new Object[]{thisProp, propName});
            } else if (typeName instanceof ArrayTypeName) {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Arrays.class, thisProp, propName});
            } else {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Objects.class, thisProp, propName});
            }
            builder.addStatement("return false", new Object[0]);
            builder.endControlFlow();
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            propName = prop.getAlias();
            String thisProp = propName.equals("o") || propName.equals("other") ? "this" + propName : propName;
            TypeName typeName = DtoGenerator.getTypeName(prop.getTypeRef());
            if (typeName.isPrimitive() && !DtoGenerator.isFieldNullable((AbstractProp)prop)) {
                builder.beginControlFlow("if ($L != other.$L)", new Object[]{thisProp, propName});
            } else if (typeName instanceof ArrayTypeName) {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Arrays.class, thisProp, propName});
            } else {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Objects.class, thisProp, propName});
            }
            builder.addStatement("return false", new Object[0]);
            builder.endControlFlow();
        }
        builder.addStatement("return true", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Constants.STRING_CLASS_NAME);
        builder.addStatement("StringBuilder builder = new StringBuilder()", new Object[0]);
        builder.addStatement("builder.append($S).append('(')", new Object[]{this.simpleNamePath()});
        String separator = "\"\"";
        boolean dynamicSeparator = this.dtoType.getDtoProps().stream().anyMatch(prop -> this.stateFieldName((AbstractProp)prop, false) != null || prop.getInputModifier() == DtoModifier.FUZZY && prop.isNullable());
        if (dynamicSeparator) {
            builder.addStatement("String _sp = \"\"", new Object[0]);
        }
        for (DtoProp prop2 : this.dtoType.getDtoProps()) {
            boolean fuzzy;
            String stateFieldName = this.stateFieldName((AbstractProp)prop2, false);
            boolean bl = fuzzy = prop2.getInputModifier() == DtoModifier.FUZZY && prop2.isNullable();
            if (stateFieldName != null) {
                builder.beginControlFlow("if ($L)", new Object[]{stateFieldName});
            } else if (fuzzy) {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop2.getName()});
            }
            if (prop2.getName().equals("builder")) {
                builder.addStatement("builder.append($L).append($S).append(this.$L)", new Object[]{separator, prop2.getName() + '=', prop2.getName()});
            } else {
                builder.addStatement("builder.append($L).append($S).append($L)", new Object[]{separator, prop2.getName() + '=', prop2.getName()});
            }
            if (dynamicSeparator) {
                builder.addStatement("_sp = \", \"", new Object[0]);
                separator = "_sp";
            } else {
                separator = "\", \"";
            }
            if (stateFieldName == null && !fuzzy) continue;
            builder.endControlFlow();
        }
        for (DtoProp prop2 : this.dtoType.getUserProps()) {
            if (prop2.getAlias().equals("builder")) {
                builder.addStatement("builder.append($L).append($S).append(this.$L)", new Object[]{separator, prop2.getAlias() + '=', prop2.getAlias()});
            } else {
                builder.addStatement("builder.append($L).append($S).append($L)", new Object[]{separator, prop2.getAlias() + '=', prop2.getAlias()});
            }
            if (dynamicSeparator) {
                builder.addStatement("_sp = \", \"", new Object[0]);
                separator = "_sp";
                continue;
            }
            separator = "\", \"";
        }
        builder.addStatement("builder.append(')')", new Object[0]);
        builder.addStatement("return builder.toString()", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private String simpleNamePath() {
        String name = this.getSimpleName();
        if (this.parent != null) {
            return this.parent.simpleNamePath() + '.' + name;
        }
        return name;
    }

    public TypeName getPropElementName(DtoProp<ImmutableType, ImmutableProp> prop) {
        DtoProp tailProp = prop.toTailProp();
        DtoType targetType = tailProp.getTargetType();
        if (targetType != null) {
            if (tailProp.isRecursive() && !targetType.isFocusedRecursion()) {
                return this.getDtoClassName();
            }
            if (targetType.getName() == null) {
                ArrayList<String> list = new ArrayList<String>();
                this.collectNames(list);
                if (!tailProp.isRecursive() || targetType.isFocusedRecursion()) {
                    list.add(this.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)tailProp));
                }
                return ClassName.get((String)this.root.dtoType.getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
            }
            return ClassName.get((String)this.root.dtoType.getPackageName(), (String)targetType.getName(), (String[])new String[0]);
        }
        ImmutableProp baseProp = (ImmutableProp)tailProp.getBaseProp();
        TypeName typeName = tailProp.isIdOnly() ? ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getIdProp().getTypeName() : (baseProp.getIdViewBaseProp() != null ? baseProp.getIdViewBaseProp().getTargetType().getIdProp().getClientTypeName() : ((ImmutableProp)tailProp.getBaseProp()).getClientTypeName());
        if (typeName.isPrimitive() && prop.isNullable()) {
            return typeName.box();
        }
        return typeName;
    }

    private void collectNames(List<String> list) {
        if (this.parent == null) {
            list.add(this.dtoType.getName());
        } else {
            this.parent.collectNames(list);
            list.add(this.innerClassName);
        }
    }

    private String targetSimpleName(DtoProp<ImmutableType, ImmutableProp> prop) {
        DtoType targetType = prop.getTargetType();
        if (targetType == null) {
            throw new IllegalArgumentException("prop is not association");
        }
        if (targetType.getName() != null) {
            return targetType.getName();
        }
        if (prop.isRecursive() && !targetType.isFocusedRecursion()) {
            return this.innerClassName != null ? this.innerClassName : this.dtoType.getName();
        }
        return this.standardTargetSimpleName("TargetOf_" + prop.getName());
    }

    private String standardTargetSimpleName(String targetSimpleName) {
        boolean conflict = false;
        DtoGenerator generator = this;
        while (generator != null) {
            if (generator.getSimpleName().equals(targetSimpleName)) {
                conflict = true;
                break;
            }
            generator = generator.parent;
        }
        if (!conflict) {
            return targetSimpleName;
        }
        for (int i = 2; i < 100; ++i) {
            conflict = false;
            String newTargetSimpleName = targetSimpleName + '_' + i;
            DtoGenerator generator2 = this;
            while (generator2 != null) {
                if (generator2.getSimpleName().equals(newTargetSimpleName)) {
                    conflict = true;
                    break;
                }
                generator2 = generator2.parent;
            }
            if (conflict) continue;
            return newTargetSimpleName;
        }
        throw new AssertionError((Object)"Dto is too deep");
    }

    private boolean isSpecificationConverterRequired(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (!this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
            return false;
        }
        return prop.getEnumType() != null || this.converterMetadataOf(prop) != null;
    }

    private ConverterMetadata converterMetadataOf(DtoProp<ImmutableType, ImmutableProp> prop) {
        String funcName = prop.getFuncName();
        if ("null".equals(funcName) || "notNull".equals(funcName)) {
            return null;
        }
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        ConverterMetadata metadata = baseProp.getConverterMetadata();
        if (metadata != null) {
            return metadata;
        }
        if ("id".equals(funcName)) {
            metadata = baseProp.getTargetType().getIdProp().getConverterMetadata();
            if (metadata != null && baseProp.isList() && !this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION)) {
                metadata = metadata.toListMetadata(baseProp.context());
            }
            return metadata;
        }
        if ("associatedInEq".equals(funcName) || "associatedInNe".equals(funcName)) {
            return baseProp.getTargetType().getIdProp().getConverterMetadata();
        }
        if (("associatedIdIn".equals(funcName) || "associatedIdNotIn".equals(funcName)) && (metadata = baseProp.getTargetType().getIdProp().getConverterMetadata()) != null) {
            return metadata.toListMetadata(baseProp.context());
        }
        if (baseProp.getIdViewBaseProp() != null && (metadata = baseProp.getIdViewBaseProp().getTargetType().getIdProp().getConverterMetadata()) != null) {
            return baseProp.isList() ? metadata.toListMetadata(baseProp.context()) : metadata;
        }
        return null;
    }

    private boolean hasElementType(Anno anno, ElementType elementType) {
        TypeElement annoElement = this.ctx.getElements().getTypeElement(anno.getQualifiedName());
        if (annoElement == null) {
            throw new DtoException("Cannot find the annotation declaration whose type is \"" + anno.getQualifiedName() + "\"");
        }
        Target target = annoElement.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType et : target.value()) {
                if (et != elementType) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCopyableAnnotation(AnnotationMirror annotationMirror, Collection<Anno> dtoAnnotations, Boolean forMethod) {
        String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
        if (qualifiedName.startsWith(KOTLIN_DTO_TYPE_NAME)) {
            return false;
        }
        if (qualifiedName.startsWith("org.babyfish.jimmer.") && !qualifiedName.startsWith("org.babyfish.jimmer.client.")) {
            return false;
        }
        if (DtoGenerator.isNullityAnnotation(qualifiedName)) {
            return false;
        }
        if (forMethod != null) {
            boolean accept = false;
            Target target = annotationMirror.getAnnotationType().asElement().getAnnotation(Target.class);
            if (target != null) {
                if (Arrays.stream(target.value()).anyMatch(it -> it == ElementType.METHOD)) {
                    accept = forMethod;
                } else if (!forMethod.booleanValue()) {
                    accept = Arrays.stream(target.value()).anyMatch(it -> it == ElementType.FIELD);
                }
            }
            if (!accept) {
                return false;
            }
        }
        for (Anno dtoAnno : dtoAnnotations) {
            if (!dtoAnno.getQualifiedName().endsWith(qualifiedName)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNullityAnnotation(String qualifiedName) {
        int lastDotIndex = qualifiedName.lastIndexOf(46);
        String simpleName = lastDotIndex != -1 ? qualifiedName.substring(lastDotIndex + 1) : qualifiedName;
        switch (simpleName) {
            case "Null": 
            case "Nullable": 
            case "NotNull": 
            case "NonNull": {
                return true;
            }
        }
        return qualifiedName.equals(Constants.T_NULLABLE_QUALIFIED_NAME);
    }

    static AnnotationSpec annotationOf(Anno anno) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)anno.getQualifiedName()));
        for (Map.Entry e : anno.getValueMap().entrySet()) {
            String name = (String)e.getKey();
            Anno.Value value = (Anno.Value)e.getValue();
            builder.addMember(name, DtoGenerator.codeBlockOf(value));
        }
        return builder.build();
    }

    private static CodeBlock codeBlockOf(Anno.Value value) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (value instanceof Anno.ArrayValue) {
            builder.add("{\n$>", new Object[0]);
            boolean addSeparator = false;
            for (Anno.Value element : ((Anno.ArrayValue)value).elements) {
                if (addSeparator) {
                    builder.add(", \n", new Object[0]);
                } else {
                    addSeparator = true;
                }
                builder.add("$L", new Object[]{DtoGenerator.codeBlockOf(element)});
            }
            builder.add("$<\n}", new Object[0]);
        } else if (value instanceof Anno.AnnoValue) {
            builder.add("$L", new Object[]{DtoGenerator.annotationOf(((Anno.AnnoValue)value).anno)});
        } else if (value instanceof Anno.TypeRefValue) {
            builder.add("$T.class", new Object[]{DtoGenerator.getTypeName(((Anno.TypeRefValue)value).typeRef)});
        } else if (value instanceof Anno.EnumValue) {
            builder.add("$T.$L", new Object[]{ClassName.bestGuess((String)((Anno.EnumValue)value).qualifiedName), ((Anno.EnumValue)value).constant});
        } else if (value instanceof Anno.LiteralValue) {
            builder.add(((Anno.LiteralValue)value).value.replace("$", "$$"), new Object[0]);
        }
        return builder.build();
    }

    private static boolean isForceOut(String typeName) {
        switch (typeName) {
            case "Iterable": 
            case "Collection": 
            case "List": 
            case "Set": 
            case "Map": {
                return true;
            }
        }
        return false;
    }

    String getterName(AbstractProp prop) {
        String suffix;
        TypeName typeName = prop instanceof DtoProp ? this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)((DtoProp)prop)) : DtoGenerator.getTypeName(((UserProp)prop).getTypeRef());
        String string = suffix = prop instanceof DtoProp ? prop.getName() : prop.getAlias();
        if (suffix.startsWith("is") && suffix.length() > 2 && Character.isUpperCase(suffix.charAt(2)) && typeName.equals((Object)TypeName.BOOLEAN)) {
            suffix = suffix.substring(2);
        }
        return StringUtil.identifier((String[])new String[]{typeName.equals((Object)TypeName.BOOLEAN) ? "is" : "get", suffix});
    }

    private String setterName(AbstractProp prop) {
        String suffix;
        TypeName typeName = prop instanceof DtoProp ? this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)((DtoProp)prop)) : DtoGenerator.getTypeName(((UserProp)prop).getTypeRef());
        String string = suffix = prop instanceof DtoProp ? prop.getName() : prop.getAlias();
        if (suffix.startsWith("is") && suffix.length() > 2 && Character.isUpperCase(suffix.charAt(2)) && typeName.equals((Object)TypeName.BOOLEAN)) {
            suffix = suffix.substring(2);
        }
        return StringUtil.identifier((String[])new String[]{"set", suffix});
    }

    private static int docKeyIndex(int originalIndex, String doc, String key) {
        int index = doc.indexOf(key);
        if (index == -1 || originalIndex != -1 && originalIndex < index) {
            return originalIndex;
        }
        if (doc.length() == index + key.length()) {
            return index;
        }
        if (Character.isWhitespace(doc.charAt(index + key.length()))) {
            return index;
        }
        return originalIndex;
    }

    private boolean isImpl() {
        return ((ImmutableType)this.dtoType.getBaseType()).isEntity() || !this.dtoType.getModifiers().contains(DtoModifier.SPECIFICATION);
    }

    TypeSpec.Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    @Nullable
    String stateFieldName(AbstractProp prop, boolean builder) {
        if (!prop.isNullable()) {
            return null;
        }
        if (!(prop instanceof DtoProp)) {
            return null;
        }
        if (!this.dtoType.getModifiers().contains(DtoModifier.INPUT)) {
            return null;
        }
        DtoModifier modifier = ((DtoProp)prop).getInputModifier();
        if (modifier == DtoModifier.FIXED && !builder) {
            return null;
        }
        if (modifier == DtoModifier.STATIC || modifier == DtoModifier.FUZZY) {
            return null;
        }
        return StringUtil.identifier((String[])new String[]{"_is", prop.getName(), "Loaded"});
    }

    private static boolean isFieldNullable(AbstractProp prop) {
        if (prop instanceof DtoProp) {
            String funcName = ((DtoProp)prop).getFuncName();
            return !"null".equals(funcName) && !"notNull".equals(funcName);
        }
        return true;
    }

    private boolean isSerializerRequired() {
        if (!this.dtoType.getModifiers().contains(DtoModifier.INPUT)) {
            return false;
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            DtoModifier inputModifier = prop.getInputModifier();
            if (inputModifier != DtoModifier.DYNAMIC) continue;
            return true;
        }
        return false;
    }

    private boolean isBuildRequired() {
        if (!this.dtoType.getModifiers().contains(DtoModifier.INPUT)) {
            return false;
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            DtoModifier inputModifier = prop.getInputModifier();
            if (inputModifier != DtoModifier.FIXED && inputModifier != DtoModifier.DYNAMIC) continue;
            return true;
        }
        return false;
    }

    private boolean isHibernateValidatorEnhancementRequired() {
        return this.ctx.isHibernateValidatorEnhancement() && this.dtoType.getDtoProps().stream().anyMatch(it -> it.getInputModifier() == DtoModifier.DYNAMIC);
    }

    private String baseDocComment() {
        return this.docMetadata.getString(((ImmutableType)this.dtoType.getBaseType()).getTypeElement());
    }

    private String baseDocComment(ImmutableProp prop) {
        return this.docMetadata.getString(prop.toElement());
    }

    private class Document {
        private final Context ctx;
        private final Doc dtoTypeDoc;
        private final Doc baseTypeDoc;
        private String result;

        public Document(Context ctx, DtoType<ImmutableType, ImmutableProp> dtoType) {
            this.ctx = ctx;
            this.dtoTypeDoc = Doc.parse((String)dtoType.getDoc());
            this.baseTypeDoc = Doc.parse((String)DtoGenerator.this.baseDocComment());
        }

        public String get() {
            String ret = this.result;
            if (ret == null) {
                ret = this.dtoTypeDoc != null ? this.dtoTypeDoc.toString() : (this.baseTypeDoc != null ? this.baseTypeDoc.toString() : "");
                this.result = ret = ret.replace("$", "$$");
            }
            return ret.isEmpty() ? null : ret;
        }

        public String get(AbstractProp prop) {
            String value = this.getImpl(prop);
            if (value == null) {
                return null;
            }
            return value.replace("$", "$$");
        }

        private String getImpl(AbstractProp prop) {
            Object doc;
            ImmutableProp baseProp = prop instanceof DtoProp ? (ImmutableProp)((DtoProp)prop).toTailProp().getBaseProp() : null;
            if (prop.getDoc() != null && (doc = Doc.parse((String)prop.getDoc())) != null) {
                return doc.toString();
            }
            if (this.dtoTypeDoc != null) {
                String doc2;
                String name = prop.getAlias();
                if (name == null) {
                    assert (baseProp != null);
                    name = baseProp.getName();
                }
                if ((doc2 = (String)this.dtoTypeDoc.getParameterValueMap().get(name)) != null) {
                    return doc2;
                }
            }
            if (baseProp != null && (doc = Doc.parse((String)DtoGenerator.this.baseDocComment(baseProp))) != null) {
                return doc.toString();
            }
            if (this.baseTypeDoc != null && baseProp != null && (doc = (String)this.baseTypeDoc.getParameterValueMap().get(baseProp.getName())) != null) {
                return doc;
            }
            return null;
        }
    }
}

