/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.DtoCompiler;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.PropConfig;
import org.babyfish.jimmer.dto.compiler.SimplePropType;
import org.babyfish.jimmer.sql.GeneratedValue;
import org.jetbrains.annotations.Nullable;

public class AptDtoCompiler
extends DtoCompiler<ImmutableType, ImmutableProp> {
    private static final Map<TypeName, SimplePropType> SIMPLE_PROP_TYPE_MAP;
    private final Elements elements;
    private final DtoModifier defaultNullableInputModifier;

    public AptDtoCompiler(DtoFile dtoFile, Elements elements, DtoModifier defaultNullableInputModifier) throws IOException {
        super(dtoFile);
        this.elements = elements;
        this.defaultNullableInputModifier = defaultNullableInputModifier;
    }

    public DtoModifier getDefaultNullableInputModifier() {
        return this.defaultNullableInputModifier;
    }

    protected Collection<ImmutableType> getSuperTypes(ImmutableType baseType) {
        return baseType.getSuperTypes();
    }

    protected Map<String, ImmutableProp> getDeclaredProps(ImmutableType baseType) {
        return baseType.getDeclaredProps();
    }

    protected Map<String, ImmutableProp> getProps(ImmutableType baseType) {
        return baseType.getProps();
    }

    protected ImmutableType getTargetType(ImmutableProp baseProp) {
        return baseProp.getTargetType();
    }

    @Nullable
    protected ImmutableProp getIdProp(ImmutableType baseType) {
        return baseType.getIdProp();
    }

    protected boolean isGeneratedValue(ImmutableProp baseProp) {
        return baseProp.toElement().getAnnotation(GeneratedValue.class) != null;
    }

    protected SimplePropType getSimplePropType(ImmutableProp baseProp) {
        TypeName typeName = baseProp.getTypeName();
        SimplePropType simplePropType = SIMPLE_PROP_TYPE_MAP.get(typeName);
        if (simplePropType == null) {
            return SimplePropType.NONE;
        }
        return simplePropType;
    }

    protected SimplePropType getSimplePropType(PropConfig.PathNode<ImmutableProp> pathNode) {
        TypeName typeName = pathNode.isAssociatedId() ? ((ImmutableProp)pathNode.getProp()).getTargetType().getIdProp().getTypeName() : ((ImmutableProp)pathNode.getProp()).getTypeName();
        SimplePropType simplePropType = SIMPLE_PROP_TYPE_MAP.get(typeName);
        if (simplePropType == null) {
            return SimplePropType.NONE;
        }
        return simplePropType;
    }

    protected boolean isSameType(ImmutableProp baseProp1, ImmutableProp baseProp2) {
        return baseProp1.getClientTypeName().equals((Object)baseProp2.getClientTypeName());
    }

    protected List<String> getEnumConstants(ImmutableProp baseProp) {
        if (baseProp.isList() || !baseProp.context().isEnum(baseProp.getElementType())) {
            return null;
        }
        Element element = ((DeclaredType)baseProp.toElement().getReturnType()).asElement();
        if (!(element instanceof TypeElement)) {
            return null;
        }
        ArrayList<String> constants = new ArrayList<String>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
            constants.add(element2.getSimpleName().toString());
        }
        return constants;
    }

    protected Integer getGenericTypeCount(String qualifiedName) {
        TypeElement typeElement = this.elements.getTypeElement(qualifiedName);
        if (typeElement == null) {
            return null;
        }
        return typeElement.getTypeParameters().size();
    }

    static {
        HashMap<TypeName, SimplePropType> map = new HashMap<TypeName, SimplePropType>();
        map.put(TypeName.BOOLEAN, SimplePropType.BOOLEAN);
        map.put(TypeName.BOOLEAN.box(), SimplePropType.BOOLEAN);
        map.put(TypeName.BYTE, SimplePropType.BYTE);
        map.put(TypeName.BYTE.box(), SimplePropType.BYTE);
        map.put(TypeName.SHORT, SimplePropType.SHORT);
        map.put(TypeName.SHORT.box(), SimplePropType.SHORT);
        map.put(TypeName.INT, SimplePropType.INT);
        map.put(TypeName.INT.box(), SimplePropType.INT);
        map.put(TypeName.LONG, SimplePropType.LONG);
        map.put(TypeName.LONG.box(), SimplePropType.LONG);
        map.put(TypeName.FLOAT, SimplePropType.FLOAT);
        map.put(TypeName.FLOAT.box(), SimplePropType.FLOAT);
        map.put(TypeName.DOUBLE, SimplePropType.DOUBLE);
        map.put(TypeName.DOUBLE.box(), SimplePropType.DOUBLE);
        map.put((TypeName)ClassName.get(BigInteger.class), SimplePropType.BIG_INTEGER);
        map.put((TypeName)ClassName.get(BigDecimal.class), SimplePropType.BIG_DECIMAL);
        map.put((TypeName)ClassName.get(String.class), SimplePropType.STRING);
        SIMPLE_PROP_TYPE_MAP = map;
    }
}

