/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.client.ExportDoc;
import org.babyfish.jimmer.impl.util.StringUtil;

public class ExportDocProcessor {
    private static final String JIMMER_DOC = "META-INF/jimmer/doc.properties";
    private final Context context;

    public ExportDocProcessor(Context context) {
        this.context = context;
    }

    public void process(RoundEnvironment roundEnv) {
        Pkg pkg = this.pkg(roundEnv);
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            PackageElement packageElement = (PackageElement)element.getEnclosingElement();
            this.collectTypeElements(pkg.isExported(packageElement.getQualifiedName().toString()), element, typeElements);
        }
        if (typeElements.isEmpty()) {
            return;
        }
        this.writeDoc(typeElements);
    }

    private void collectTypeElements(boolean parentExport, Element element, List<TypeElement> typeElements) {
        TypeElement typeElement;
        if (element instanceof TypeElement && ((typeElement = (TypeElement)element).getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.INTERFACE || typeElement.getKind() == ElementKind.ENUM)) {
            ExportDoc exportDoc = typeElement.getAnnotation(ExportDoc.class);
            boolean export = exportDoc != null ? !exportDoc.excluded() : parentExport;
            if (export) {
                typeElements.add(typeElement);
            }
            for (Element element2 : typeElement.getEnclosedElements()) {
                this.collectTypeElements(export, element2, typeElements);
            }
        }
    }

    private Pkg pkg(RoundEnvironment roundEnv) {
        Pkg pkg = new Pkg("", null);
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            pkg.set((PackageElement)element.getEnclosingElement());
        }
        return pkg;
    }

    private void writeDoc(List<TypeElement> typeElements) {
        FileObject fileObject;
        try {
            fileObject = this.context.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", JIMMER_DOC);
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot read file \"META-INF/jimmer/doc.properties\" generated in previous compilation", ex);
        }
        File docFile = new File(fileObject.getName());
        Properties properties = new Properties();
        if (docFile.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(docFile.toPath(), StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException ex) {
                throw new GeneratorException("Cannot read exists file \"META-INF/jimmer/doc.properties\"", ex);
            }
        }
        for (TypeElement typeElement : typeElements) {
            this.addProperties(properties, typeElement);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(docFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            properties.store(writer, "Generated by @" + ExportDoc.class.getName());
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot write generated file \"META-INF/jimmer/doc.properties\"", ex);
        }
    }

    private void addProperties(Properties properties, TypeElement typeElement) {
        String typeName = typeElement.getQualifiedName().toString();
        String doc = ExportDocProcessor.standardComment(this.context.getElements().getDocComment(typeElement));
        if (doc != null) {
            properties.put(typeName, doc);
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || (doc = ExportDocProcessor.standardComment(this.context.getElements().getDocComment(element))) == null) continue;
            properties.put(typeName + '.' + element.getSimpleName().toString(), doc);
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement methodElement;
            if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC) || (methodElement = (ExecutableElement)element).getReturnType().getKind() == TypeKind.VOID || !methodElement.getParameters().isEmpty() || (doc = ExportDocProcessor.standardComment(this.context.getElements().getDocComment(element))) == null) continue;
            String propName = StringUtil.propName((String)methodElement.getSimpleName().toString(), (methodElement.getReturnType().getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0);
            properties.put(typeName + '.' + propName, doc);
        }
    }

    private static String standardComment(String comment) {
        if (comment == null) {
            return null;
        }
        if ((comment = comment.trim()).isEmpty()) {
            return null;
        }
        return comment;
    }

    private static class Pkg {
        private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
        private final String name;
        private final Pkg parent;
        private Map<String, Pkg> childMap;
        private Boolean export;

        public Pkg(String name, Pkg parent) {
            this.name = name;
            this.parent = parent;
            this.childMap = null;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getExport() {
            return this.export;
        }

        public void setExport(Boolean export) {
            this.export = export;
        }

        public boolean isExported(String packageName) {
            Pkg pkg = this.sub(packageName, false);
            do {
                if (pkg.export == null) continue;
                return pkg.export;
            } while ((pkg = pkg.parent) != null);
            return false;
        }

        public void set(PackageElement packageElement) {
            ExportDoc exportDoc = packageElement.getAnnotation(ExportDoc.class);
            if (exportDoc == null) {
                return;
            }
            Pkg pkg = this.sub(packageElement.getQualifiedName().toString(), true);
            pkg.export = !exportDoc.excluded();
        }

        public Pkg sub(String packageName, boolean autoCreate) {
            Pkg pkg = this;
            for (String name : DOT_PATTERN.split(packageName)) {
                Pkg childPkg = pkg.child(name, autoCreate);
                if (childPkg == null) {
                    return pkg;
                }
                pkg = childPkg;
            }
            return pkg;
        }

        private Pkg child(String name, boolean autoCreate) {
            if (!autoCreate && this.childMap == null) {
                return null;
            }
            if (this.childMap == null) {
                this.childMap = new LinkedHashMap<String, Pkg>();
            }
            if (!autoCreate) {
                return this.childMap.get(name);
            }
            return this.childMap.computeIfAbsent(name, k -> new Pkg((String)k, this));
        }
    }
}

