/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.Specification;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class Context {
    private static final Class<? extends Annotation>[] SQL_TYPE_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private final Elements elements;
    private final Types types;
    private final Filer filer;
    private final TypeMirror objectType;
    private final TypeMirror numberType;
    private final TypeMirror dateType;
    private final TypeMirror temporalType;
    private final TypeMirror comparableType;
    private final TypeMirror viewType;
    private final TypeMirror inputType;
    private final TypeMirror specificationType;
    private final TypeElement enumElement;
    private final Map<TypeElement, ImmutableType> immutableTypeMap = new HashMap<TypeElement, ImmutableType>();
    private final boolean keepIsPrefix;
    private final String[] includes;
    private final String[] excludes;
    private final String immutablesTypeName;
    private final String tablesTypeName;
    private final String tableExesTypeName;
    private final String fetchersTypeName;
    private final boolean hibernateValidatorEnhancement;
    private final boolean buddyIgnoreResourceGeneration;
    private final Modifier dtoFieldModifier;

    Context(Elements elements, Types types, Filer filer, boolean keepIsPrefix, String[] includes, String[] excludes, String immutablesTypeName, String tablesTypeName, String tableExesTypeName, String fetchersTypeName, boolean hibernateValidatorEnhancement, boolean buddyIgnoreResourceGeneration, Modifier dtoFieldModifier) {
        this.elements = elements;
        this.types = types;
        this.filer = filer;
        this.keepIsPrefix = keepIsPrefix;
        this.includes = includes;
        this.excludes = excludes;
        this.objectType = elements.getTypeElement(Object.class.getName()).asType();
        this.numberType = elements.getTypeElement(Number.class.getName()).asType();
        this.dateType = elements.getTypeElement(Date.class.getName()).asType();
        this.temporalType = elements.getTypeElement(Temporal.class.getName()).asType();
        this.viewType = elements.getTypeElement(View.class.getName()).asType();
        this.inputType = elements.getTypeElement(Input.class.getName()).asType();
        this.specificationType = elements.getTypeElement(Specification.class.getName()).asType();
        this.immutablesTypeName = immutablesTypeName != null && !immutablesTypeName.isEmpty() ? immutablesTypeName : "Immutables";
        this.tablesTypeName = tablesTypeName != null && !tablesTypeName.isEmpty() ? tablesTypeName : "Tables";
        this.tableExesTypeName = tableExesTypeName != null && !tableExesTypeName.isEmpty() ? tableExesTypeName : "TableExes";
        this.fetchersTypeName = fetchersTypeName != null && !fetchersTypeName.isEmpty() ? fetchersTypeName : "Fetchers";
        this.hibernateValidatorEnhancement = hibernateValidatorEnhancement;
        this.buddyIgnoreResourceGeneration = buddyIgnoreResourceGeneration;
        this.dtoFieldModifier = dtoFieldModifier;
        this.comparableType = types.getDeclaredType(elements.getTypeElement(Comparable.class.getName()), types.getWildcardType(null, null));
        this.enumElement = elements.getTypeElement(Enum.class.getName());
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        Immutable annotation = typeElement.getAnnotation(Immutable.class);
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_TYPE_ANNOTATION_TYPES) {
            Annotation newSqlAnnotation = typeElement.getAnnotation(sqlAnnotationType);
            if (newSqlAnnotation == null) continue;
            if (sqlAnnotation != null) {
                throw new MetaException(typeElement, "it can not be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + newSqlAnnotation.annotationType().getName());
            }
            sqlAnnotation = newSqlAnnotation;
        }
        if (sqlAnnotation != null) {
            return sqlAnnotation.annotationType();
        }
        if (annotation != null) {
            return annotation.annotationType();
        }
        return null;
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        return this.getImmutableAnnotationType((TypeElement)element);
    }

    public boolean isObject(TypeMirror typeMirror) {
        return this.types.isAssignable(typeMirror, this.objectType);
    }

    public boolean isImmutable(TypeElement type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isImmutable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isEntity(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Entity.class;
    }

    public boolean isMappedSuperclass(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == MappedSuperclass.class;
    }

    public boolean isEmbeddable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Embeddable.class;
    }

    public boolean isCollection(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement element = (TypeElement)declaredType.asElement();
            if (element.getQualifiedName().toString().equals("java.util.Collection")) {
                return true;
            }
            if (element.getSuperclass() != null && this.isCollection(element.getSuperclass())) {
                return true;
            }
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (!this.isCollection(typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isListStrictly(TypeMirror type) {
        Element element = this.types.asElement(type);
        return element != null && element.toString().equals("java.util.List");
    }

    public boolean isEnum(TypeMirror type) {
        return this.types.isSubtype(type, this.types.getDeclaredType(this.enumElement, type));
    }

    public boolean isSubType(TypeMirror type, TypeMirror superType) {
        return this.types.isSubtype(type, superType);
    }

    public ImmutableType getImmutableType(TypeElement typeElement) {
        ImmutableType type = this.immutableTypeMap.get(typeElement);
        if (type == null && !this.immutableTypeMap.containsKey(typeElement)) {
            if (this.isImmutable(typeElement)) {
                type = new ImmutableType(this, typeElement);
            }
            this.immutableTypeMap.put(typeElement, type);
        }
        return type;
    }

    public ImmutableType getImmutableType(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.types.asElement(type);
        return this.getImmutableType(typeElement);
    }

    public boolean isNumber(TypeMirror type) {
        return this.types.isSubtype(type, this.numberType);
    }

    public boolean isDate(TypeMirror type) {
        return this.types.isSubtype(type, this.dateType);
    }

    public boolean isTemporal(TypeMirror type) {
        return this.types.isSubtype(type, this.temporalType);
    }

    public boolean isComparable(TypeMirror type) {
        return this.types.isSubtype(type, this.comparableType);
    }

    public boolean isDto(TypeMirror type) {
        return this.types.isSubtype(type, this.viewType) || this.types.isSubtype(type, this.inputType) || this.types.isSubtype(type, this.specificationType);
    }

    public Elements getElements() {
        return this.elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public Filer getFiler() {
        return this.filer;
    }

    public boolean keepIsPrefix() {
        return this.keepIsPrefix;
    }

    public boolean include(TypeElement typeElement) {
        if (typeElement.getAnnotation(Metadata.class) != null) {
            return false;
        }
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (this.includes != null) {
            for (String include : this.includes) {
                if (!qualifiedName.startsWith(include)) continue;
                return true;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!qualifiedName.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public String getImmutablesTypeName() {
        return this.immutablesTypeName;
    }

    public String getTablesTypeName() {
        return this.tablesTypeName;
    }

    public String getTableExesTypeName() {
        return this.tableExesTypeName;
    }

    public String getFetchersTypeName() {
        return this.fetchersTypeName;
    }

    public boolean isHibernateValidatorEnhancement() {
        return this.hibernateValidatorEnhancement;
    }

    public boolean isBuddyIgnoreResourceGeneration() {
        return this.buddyIgnoreResourceGeneration;
    }

    public Modifier getDtoFieldModifier() {
        return this.dtoFieldModifier;
    }
}

