/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v0_10;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;
import org.apache.qpid.url.AMQBindingURL;

@PluggableService
public class MessageConverter_0_8_to_0_10
implements MessageConverter<AMQMessage, MessageTransferMessage> {
    public Class<AMQMessage> getInputClass() {
        return AMQMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(AMQMessage message_0_8, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(message_0_8), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final AMQMessage message_0_8) {
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(message_0_8);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return message_0_8.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return message_0_8.getContent(offset, length);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(AMQMessage message_0_8) {
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        int size = (int)message_0_8.getSize();
        BasicContentHeaderProperties properties = message_0_8.getContentHeaderBody().getProperties();
        AMQShortString exchange = message_0_8.getMessagePublishInfo().getExchange();
        if (exchange != null) {
            deliveryProps.setExchange(exchange.toString());
        }
        deliveryProps.setExpiration(message_0_8.getExpiration());
        deliveryProps.setImmediate(message_0_8.isImmediate());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)properties.getPriority()));
        deliveryProps.setRoutingKey(message_0_8.getInitialRoutingAddress());
        deliveryProps.setTimestamp(properties.getTimestamp());
        messageProps.setContentEncoding(properties.getEncodingAsString());
        messageProps.setContentLength((long)size);
        if (properties.getAppId() != null) {
            messageProps.setAppId(properties.getAppId().getBytes());
        }
        messageProps.setContentType(properties.getContentTypeAsString());
        if (properties.getCorrelationId() != null) {
            messageProps.setCorrelationId(properties.getCorrelationId().getBytes());
        }
        if (properties.getReplyTo() != null && properties.getReplyTo().length() != 0) {
            String origReplyToString = properties.getReplyTo().toString();
            ReplyTo replyTo = new ReplyTo();
            try {
                String exchangeName;
                AMQBindingURL burl = new AMQBindingURL(origReplyToString);
                String routingKey = burl.getRoutingKey();
                if (routingKey != null) {
                    replyTo.setRoutingKey(routingKey);
                }
                if ((exchangeName = burl.getExchangeName()) != null) {
                    replyTo.setExchange(exchangeName);
                }
            }
            catch (URISyntaxException e) {
                replyTo.setRoutingKey(origReplyToString);
            }
            messageProps.setReplyTo(replyTo);
        }
        if (properties.getMessageId() != null) {
            try {
                String messageIdAsString = properties.getMessageIdAsString();
                if (messageIdAsString.startsWith("ID:")) {
                    messageIdAsString = messageIdAsString.substring(3);
                }
                UUID uuid = UUID.fromString(messageIdAsString);
                messageProps.setMessageId(uuid);
            }
            catch (IllegalArgumentException messageIdAsString) {
                // empty catch block
            }
        }
        if (properties.getUserId() != null) {
            messageProps.setUserId(properties.getUserId().getBytes());
        }
        FieldTable fieldTable = properties.getHeaders();
        Map appHeaders = FieldTable.convertToMap((FieldTable)fieldTable);
        if (properties.getType() != null) {
            appHeaders.put("x-jms-type", properties.getTypeAsString());
        }
        messageProps.setApplicationHeaders(appHeaders);
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, message_0_8.getArrivalTime());
    }

    public String getType() {
        return "v0-8 to v0-10";
    }
}

