/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaYammerMetrics;
import kafka.network.RequestChannel;
import kafka.server.BrokerTopicStats;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkData$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.BuildFrom$;
import scala.collection.Factory;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.immutable.WrappedString;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Properties$;

public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$ = new TestUtils$();
    private static final Random random = TestUtils.RANDOM;
    private static final int RandomPort = 0;
    private static final int IncorrectBrokerPort = 225;
    private static final int MockZkPort = 1;
    private static final String MockZkConnect = new java.lang.StringBuilder(10).append("127.0.0.1:").append(MODULE$.MockZkPort()).toString();
    private static final String SslCertificateCn = "localhost";
    private static final String kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
    private static final byte[] kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
    private static final byte[] kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$((Logging)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String logIdent() {
        return logIdent;
    }

    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Random random() {
        return random;
    }

    public int RandomPort() {
        return RandomPort;
    }

    public int IncorrectBrokerPort() {
        return IncorrectBrokerPort;
    }

    public int MockZkPort() {
        return MockZkPort;
    }

    public String MockZkConnect() {
        return MockZkConnect;
    }

    public String SslCertificateCn() {
        return SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory(null, null);
    }

    public String tempTopic() {
        return new java.lang.StringBuilder(9).append("testTopic").append(this.random().nextInt(1000000)).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> new File(parentDir, new java.lang.StringBuilder(6).append("kafka-").append(MODULE$.random().nextInt(1000000)).toString())).take(attempts).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdir())).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(42).append("Failed to create directory after ").append(attempts).append(" attempts").toString()));
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return FileChannel.open(TestUtils.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public KafkaServer createServer(KafkaConfig config, Time time) {
        None$ createServer_threadNamePrefix = None$.MODULE$;
        return this.createServer(config, time, (Option<String>)createServer_threadNamePrefix, false);
    }

    public KafkaServer createServer(KafkaConfig config, Option<String> threadNamePrefix) {
        Time createServer_time = Time.SYSTEM;
        return this.createServer(config, createServer_time, threadNamePrefix, false);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        return this.createServer(config, time, threadNamePrefix, false);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix, boolean enableForwarding) {
        KafkaServer server = new KafkaServer(config, time, threadNamePrefix, enableForwarding);
        server.startup();
        return server;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Tuple2<Broker, Object> createBrokerAndEpoch(int id, String host, int port, SecurityProtocol securityProtocol, long epoch) {
        return new Tuple2((Object)new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (Object)BoxesRunTime.boxToLong((long)epoch));
    }

    public SecurityProtocol createBrokerAndEpoch$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public long createBrokerAndEpoch$default$5() {
        return 0L;
    }

    public scala.collection.Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor, int startingIdNumber) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startingIdNumber), numConfigs).map((Function1 & Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken, numPartitions, defaultReplicationFactor, BoxesRunTime.unboxToInt((Object)node)));
    }

    public String getBrokerListStrFromServers(scala.collection.Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((IterableOnceOps)servers.map((Function1 & Serializable)s -> Utils.formatAddress((String)((EndPoint)s.config().advertisedListeners().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$getBrokerListStrFromServers$2(protocol, x$2))).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(47).append("Could not find listener with security protocol ").append(protocol).toString()))).host(), (Integer)Predef$.MODULE$.int2Integer(MODULE$.boundPort((KafkaServer)s, protocol))))).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(scala.collection.Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((IterableOnceOps)servers.map((Function1 & Serializable)s -> Utils.formatAddress((String)((EndPoint)s.config().advertisedListeners().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$3))).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(34).append("Could not find listener with name ").append(listenerName.value()).toString()))).host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName))))).mkString(",");
    }

    public void shutdownServers(scala.collection.Seq<KafkaServer> servers) {
        Future future = Future$.MODULE$.traverse(servers, (Function1 & Serializable)s -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            s.shutdown();
            CoreUtils$.MODULE$.delete(s.config().logDirs());
        }, ExecutionContext.Implicits$.MODULE$.global()), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)future, (Duration)FiniteDuration$.MODULE$.apply(5L, TimeUnit.MINUTES));
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port)));
        }
        if (enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort)));
        }
        if (enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort)));
        }
        if (enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort)));
        }
        String listeners = ((IterableOnceOps)protocolAndPorts.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            SecurityProtocol protocol = (SecurityProtocol)x0$1._1();
            int port = x0$1._2$mcI$sp();
            String string = new java.lang.StringBuilder(13).append(protocol.name).append("://localhost:").append(port).toString();
            return string;
        })).mkString(",");
        Properties props = new Properties();
        if (nodeId >= 0) {
            props.put(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(nodeId));
        }
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        if (logDirCount > 1) {
            String logDirs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1 & Serializable)i -> TestUtils$.$anonfun$createBrokerConfig$4(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
            props.put(KafkaConfig$.MODULE$.LogDirsProp(), logDirs);
        } else {
            props.put(KafkaConfig$.MODULE$.LogDirProp(), TestUtils.tempDirectory(null, null).getAbsolutePath());
        }
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(enableControlledShutdown));
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), Boolean.toString(enableDeleteTopic));
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        if (!props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())) {
            props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5");
        }
        if (!props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp())) {
            props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        }
        rack.foreach((Function1 & Serializable)x$5 -> props.put(KafkaConfig$.MODULE$.RackProp(), x$5));
        if (protocolAndPorts.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$6(x0$2)))) {
            new Implicits.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(Mode.SERVER, false, trustStoreFile, new java.lang.StringBuilder(6).append("server").append(nodeId).toString(), this.SslCertificateCn(), TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS));
        }
        if (protocolAndPorts.exists((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$7(x0$3)))) {
            new Implicits.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable)protocol -> props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name));
        if (enableToken) {
            props.put(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), "secretkey");
        }
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(numPartitions));
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), Short.toString(defaultReplicationFactor));
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$13() {
        return 1;
    }

    public boolean createBrokerConfigs$default$14() {
        return false;
    }

    public int createBrokerConfigs$default$15() {
        return 1;
    }

    public short createBrokerConfigs$default$16() {
        return 1;
    }

    public int createBrokerConfigs$default$17() {
        return 0;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return true;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$17() {
        return 1;
    }

    public boolean createBrokerConfig$default$18() {
        return false;
    }

    public int createBrokerConfig$default$19() {
        return 1;
    }

    public short createBrokerConfig$default$20() {
        return 1;
    }

    public void setIbpAndMessageFormatVersions(Properties config, ApiVersion version) {
        config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.version());
        if (!version.$greater$eq((Object)KAFKA_3_0_IV1$.MODULE$)) {
            config.setProperty(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), version.version());
        }
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, int numPartitions, int replicationFactor, scala.collection.Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$createTopic$1(adminZkClient, topic, numPartitions, replicationFactor, topicConfig)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$createTopic$2(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = this.waitForAllPartitionsMetadata(servers, topic, numPartitions);
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.leader())).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new java.lang.StringBuilder(81).append("Cannot get the partition leader for topic: ").append(topic$1).append(", partition: ").append(i).append(" in server metadata cache").toString());
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, scala.collection.Seq<Object>> partitionReplicaAssignment, scala.collection.Seq<KafkaServer> servers) {
        return this.createTopic(zkClient, topic, partitionReplicaAssignment, servers, new Properties());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, scala.collection.Seq<Object>> partitionReplicaAssignment, scala.collection.Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$createTopic$6(adminZkClient, topic, topicConfig, partitionReplicaAssignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$createTopic$7(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = this.waitForAllPartitionsMetadata(servers, topic, partitionReplicaAssignment.size());
        return ((IterableOnceOps)partitionReplicaAssignment.keySet().map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.leader())).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new java.lang.StringBuilder(81).append("Cannot get the partition leader for topic: ").append(topic$2).append(", partition: ").append(i).append(" in server metadata cache").toString());
        })))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(KafkaZkClient zkClient, scala.collection.Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkClient, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$), magicValue, codec, -1L, (short)-1, -1, 0L, -1);
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1 & Serializable)value -> new SimpleRecord(value))), magicValue, codec, -1L, (short)-1, -1, 0L, -1);
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        void builder_isTransactional;
        void builder_logAppendTime;
        MemoryRecordsBuilder memoryRecordsBuilder;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        boolean bl = false;
        long l = System.currentTimeMillis();
        TimestampType builder_timestampType = TimestampType.CREATE_TIME;
        MemoryRecordsBuilder memoryRecordsBuilder2 = memoryRecordsBuilder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)sequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        Object var13_12 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder2;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assertions.assertEquals((int)(b1.limit() - b1.position()), (int)(b2.limit() - b2.position()), (String)"Buffers should have equal length");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((byte)b1.get(b1.position() + i), (byte)b2.get(b1.position() + i), (String)new java.lang.StringBuilder(21).append("byte ").append(i).append(" byte not equal.").toString()));
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assertions.assertEquals((int)expectedLength, (int)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assertions.assertEquals(s1.next(), s2.next());
        }
        Assertions.assertFalse((boolean)s1.hasNext(), (String)"Iterators have uneven length--first has more");
        Assertions.assertFalse((boolean)s2.hasNext(), (String)"Iterators have uneven length--second has more");
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<T> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<T> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<T> filterImpl(Function1<T, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<T> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<T> distinctBy(Function1<T, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<T, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<T, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<T, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<T> tapEach(Function1<T, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<T, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<T, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<T> find(Function1<T, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public <B> T min(Ordering<B> ord) {
                return (T)IterableOnceOps.min$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public <B> T max(Ordering<B> ord) {
                return (T)IterableOnceOps.max$((IterableOnceOps)this, ord);
            }

            public <B> Option<T> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)IterableOnceOps.maxBy$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<T> maxByOption(Function1<T, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)IterableOnceOps.minBy$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<T> minByOption(Function1<T, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<T, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<T, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<T> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<T> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<T> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<T, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<T> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<T> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<T> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$2.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1 & Serializable)i -> builder.append(String.format("%x", buffer.get(buffer.position() + BoxesRunTime.unboxToInt((Object)i)))));
        return builder.toString();
    }

    public Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, String certCn, Option<Properties> saslProperties, String tlsProtocol, Option<Object> needsClientCert) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            boolean addClientCert = BoxesRunTime.unboxToBoolean((Object)needsClientCert.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                SecurityProtocol securityProtocol = securityProtocol;
                SecurityProtocol securityProtocol2 = SecurityProtocol.SSL;
                return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
            }));
            new Implicits.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(mode, addClientCert, trustStoreFile, certAlias, certCn, tlsProtocol));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            new Implicits.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public String securityConfigs$default$7() {
        return TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS;
    }

    public Option<Object> securityConfigs$default$8() {
        return None$.MODULE$;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", this.SslCertificateCn(), saslProperties, TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Option<Object>)None$.MODULE$);
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean enableIdempotence) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", Integer.toString(acks));
        producerProps.put("max.block.ms", Long.toString(maxBlockMs));
        producerProps.put("buffer.memory", Long.toString(bufferSize));
        producerProps.put("retries", Integer.toString(retries));
        producerProps.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        producerProps.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        producerProps.put("linger.ms", Integer.toString(lingerMs));
        producerProps.put("batch.size", Integer.toString(batchSize));
        producerProps.put("compression.type", compressionType);
        producerProps.put("enable.idempotence", Boolean.toString(enableIdempotence));
        new Implicits.PropertiesOps(producerProps).$plus$plus$eq(this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public <K, V> boolean createProducer$default$16() {
        return false;
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", this.SslCertificateCn(), saslProperties, TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Option<Object>)None$.MODULE$);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", this.SslCertificateCn(), saslProperties, TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Option<Object>)None$.MODULE$);
    }

    public <K, V> KafkaConsumer<K, V> createConsumer(String brokerList, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", Boolean.toString(enableAutoCommit));
        consumerProps.put("max.poll.records", Integer.toString(maxPollRecords));
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        new Implicits.PropertiesOps(consumerProps).$plus$plus$eq(this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$2() {
        return "group";
    }

    public <K, V> String createConsumer$default$3() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$4() {
        return true;
    }

    public <K, V> boolean createConsumer$default$5() {
        return false;
    }

    public <K, V> int createConsumer$default$6() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$7() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$8() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$10() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public scala.collection.Seq<Broker> createBrokersInZk(KafkaZkClient zkClient, scala.collection.Seq<Object> ids) {
        return this.createBrokersInZk((scala.collection.Seq<BrokerMetadata>)((scala.collection.Seq)ids.map((Function1 & Serializable)x$8 -> TestUtils$.$anonfun$createBrokersInZk$1(BoxesRunTime.unboxToInt((Object)x$8)))), zkClient);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.Seq<Broker> createBrokersInZk(scala.collection.Seq<BrokerMetadata> brokerMetadatas, KafkaZkClient zkClient) {
        void var3_3;
        zkClient.makeSurePersistentPathExists(BrokerIdsZNode$.MODULE$.path());
        scala.collection.Seq brokers = (scala.collection.Seq)brokerMetadatas.map((Function1 & Serializable)b -> {
            SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
            return Broker$.MODULE$.apply(b.id(), (scala.collection.Seq)new .colon.colon((Object)new EndPoint("localhost", 6667, listenerName, protocol), (List)Nil$.MODULE$), b.rack());
        });
        brokers.foreach((Function1 & Serializable)b -> BoxesRunTime.boxToLong((long)zkClient.registerBroker(BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(b.id(), b.endPoints(), b.rack()), ApiVersion$.MODULE$.latestVersion(), -1))));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable)i -> TestUtils$.$anonfun$getMsgStrings$1(buffer, BoxesRunTime.unboxToInt((Object)i)));
        return var2_2;
    }

    public void makeLeaderForPartition(KafkaZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        scala.collection.immutable.Map newLeaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderPerPartitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            int leader = x0$1._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)zkClient.getTopicPartitionState(topicPartition).map((Function1 & Serializable)x$9 -> x$9.leaderAndIsr().newLeader(leader)).getOrElse((Function0 & Serializable)() -> LeaderAndIsr$.MODULE$.apply(leader, (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}))));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr, controllerEpoch));
            return tuple2;
        });
        zkClient.setTopicPartitionStatesRaw((Map)newLeaderIsrAndControllerEpochs, ZkVersion$.MODULE$.MatchAnyVersion());
    }

    public int waitUntilLeaderIsElectedOrChanged(KafkaZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable)() -> "Can't define both the old and the new leader");
        long startTime = System.currentTimeMillis();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$2(topicPartition, oldLeaderOpt, newLeaderOpt);
            Object var16_9 = null;
            this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        None$ electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            leader.elem = zkClient.getLeaderForPartition(topicPartition);
            Option option = (Option)leader.elem;
            if (option instanceof Some) {
                int oldLeader;
                int l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$3(l, topicPartition);
                        Object var17_15 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (oldLeaderOpt instanceof Some && (oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$4(topicPartition, oldLeader, l);
                        Object var18_16 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$5(l, topicPartition);
                        Object var19_17 = null;
                        this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$6(topicPartition, l);
                    Object var20_18 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChanged$7(topicPartition);
                    Object var21_19 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0 & Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = new java.lang.StringBuilder(90).append("Timing out after ").append(timeoutMs).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(topicPartition).append(", leader is ").append((Option)leader$2.elem).toString();
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(96).append("Timing out after ").append(timeoutMs).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(topicPartition).append(", ").toString()).append(new java.lang.StringBuilder(10).append("leader is ").append((Option)leader$2.elem).toString()).toString();
            } else {
                string = new java.lang.StringBuilder(66).append("Timing out after ").append(timeoutMs).append(" ms since a leader was not elected for partition ").append(topicPartition).toString();
            }
            throw new AssertionError((Object)string);
        }));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        long l = 1L;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                if (System.currentTimeMillis() - startTime > maxWaitMs) {
                    throw e;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new java.lang.StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_6 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void pollUntilTrue(Consumer<?, ?> consumer, Function0<Object> action, Function0<String> msg, long waitTimeMs) {
        long waitUntilTrue_pause = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(java.time.Duration.ofMillis(100L));
            if (action.apply$mcZ$sp()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public long pollUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> void pollRecordsUntilTrue(Consumer<K, V> consumer, Function1<ConsumerRecords<K, V>, Object> action, Function0<String> msg, long waitTimeMs) {
        long waitUntilTrue_pause = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            ConsumerRecords $anonfun$pollRecordsUntilTrue$1_records = consumer.poll(java.time.Duration.ofMillis(100L));
            Object var10_7 = null;
            if (BoxesRunTime.unboxToBoolean((Object)action.apply((Object)$anonfun$pollRecordsUntilTrue$1_records))) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public <K, V> long pollRecordsUntilTrue$default$4() {
        return 15000L;
    }

    public void subscribeAndWaitForRecords(String topic, KafkaConsumer<byte[], byte[]> consumer, long waitTimeMs) {
        consumer.subscribe(Collections.singletonList(topic));
        long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$subscribeAndWaitForRecords$1(consumer.poll(java.time.Duration.ofMillis(100L)))) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)"Expected records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pollRecordsUntilTrue_waitUntilTrue_pause));
        }
    }

    public long subscribeAndWaitForRecords$default$3() {
        return 15000L;
    }

    public <T> T awaitValue(Function0<Option<T>> func, Function0<String> msg, long waitTimeMs) {
        Option option;
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = (Option)func.apply()).isDefined()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), l));
        }
        return (T)option.get();
    }

    public <T> long awaitValue$default$3() {
        return 15000L;
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTimeMs, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    public void tryUntilNoAssertionError(long waitTime, long pause, Function0<BoxedUnit> assertions) {
        Tuple2 tuple2;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            None$ none$;
            try {
                assertions.apply$mcV$sp();
                none$ = None$.MODULE$;
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                none$ = new Some((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_6 = null;
            None$ computeUntilTrue_result = none$;
            if (((Option)computeUntilTrue_result).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        Tuple2 tuple22 = tuple2;
        Object var10_5 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Option error = (Option)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        if (!bl) {
            void var7_10;
            throw (Throwable)var7_10.get();
        }
    }

    public long tryUntilNoAssertionError$default$1() {
        return 15000L;
    }

    public long tryUntilNoAssertionError$default$2() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().onlinePartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$isLeaderLocalOnBroker$1(x$12)));
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        return ((Partition)servers.find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findLeaderEpoch$1(brokerId, x$13))).flatMap((Function1 & Serializable)x$14 -> x$14.replicaManager().onlinePartition(topicPartition)).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new java.lang.StringBuilder(42).append("Failed to find expected replica on broker ").append(brokerId).toString());
        })).getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        return BoxesRunTime.unboxToInt((Object)servers.find((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findFollowerId$1(topicPartition, server))).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$findFollowerId$2(x$15))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new java.lang.StringBuilder(30).append("Unable to locate follower for ").append(topicPartition).toString());
        }));
    }

    public void waitUntilBrokerMetadataIsPropagated(scala.collection.Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((IterableOnceOps)servers.map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$16)))).toSet();
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$3(expectedBrokerIds$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)"Timed out waiting for broker metadata to propagate to all servers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), l));
        }
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> waitForAllPartitionsMetadata(scala.collection.Seq<KafkaServer> servers, String topic, int expectedNumPartitions) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForAllPartitionsMetadata$2(topic$4, expectedNumPartitions$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForAllPartitionsMetadata$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), expectedNumPartitions).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))), ((KafkaServer)servers.head()).metadataCache().getPartitionInfo(topic, BoxesRunTime.unboxToInt((Object)i)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new java.lang.StringBuilder(56).append("Cannot get topic: ").append(topic$4).append(", partition: ").append(i).append(" in server metadata cache").toString());
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState waitForPartitionMetadata(scala.collection.Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForPartitionMetadata$2(topic$5, partition$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), l));
        }
        return (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)servers.head()).metadataCache().getPartitionInfo(topic, partition).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new java.lang.StringBuilder(56).append("Cannot get topic: ").append(topic).append(", partition: ").append(partition).append(" in server metadata cache").toString());
        });
    }

    public long waitForPartitionMetadata$default$4() {
        return 15000L;
    }

    /*
     * WARNING - void declaration
     */
    public int waitUntilControllerElected(KafkaZkClient zkClient, long timeout) {
        void var5_8;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = zkClient.getControllerId()).isDefined()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + timeout) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), l));
        }
        Tuple2 tuple22 = tuple2;
        Object var8_5 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Option controllerId = (Option)tuple23._1();
        return BoxesRunTime.unboxToInt((Object)var5_8.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new java.lang.StringBuilder(32).append("Controller not elected after ").append(timeout).append(" ms").toString());
        }));
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public int awaitLeaderChange(scala.collection.Seq<KafkaServer> servers, TopicPartition tp, int oldLeader, long timeout) {
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$awaitLeaderChange$4(servers, oldLeader, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$awaitLeaderChange$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), l));
        }
        return BoxesRunTime.unboxToInt((Object)TestUtils$.newLeaderExists$1(servers, oldLeader, tp).get());
    }

    public long awaitLeaderChange$default$4() {
        return 15000L;
    }

    public int waitUntilLeaderIsKnown(scala.collection.Seq<KafkaServer> servers, TopicPartition tp, long timeout) {
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitUntilLeaderIsKnown$4(servers, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$waitUntilLeaderIsKnown$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), l));
        }
        return BoxesRunTime.unboxToInt((Object)TestUtils$.leaderIfExists$1(servers, tp).get());
    }

    public long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> file.writeByte(MODULE$.random().nextInt(255)));
        file.close();
    }

    public void appendNonsenseToFile(File file, int size) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$24 -> outputStream.write(MODULE$.random().nextInt(255)));
        }
    }

    public void checkForPhantomInSyncReplicas(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, scala.collection.Seq<Object> assignedReplicas) {
        Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Assertions.assertTrue((boolean)((Set)((IterableOnceOps)inSyncReplicas.get()).toSet().$minus$minus((IterableOnce)assignedReplicas.toSet())).isEmpty(), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})));
    }

    public void ensureNoUnderReplicatedPartitions(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, scala.collection.Seq<Object> assignedReplicas, scala.collection.Seq<KafkaServer> servers) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionToBeReassigned);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$1(zkClient, topicPartition, assignedReplicas)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            leader.elem = zkClient.getLeaderForPartition(topicPartition);
            if (((Option)leader.elem).isDefined()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(((KafkaServer)((IterableOps)servers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$6(leader$3, s)))).head()).replicaManager().underReplicatedPartitionCount() == 0)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader.elem).get()})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
    }

    public void assertNoNonDaemonThreads(String threadNamePrefix) {
        int threadCount = CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().count((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$assertNoNonDaemonThreads$1(threadNamePrefix, t)));
        Assertions.assertEquals((int)0, (int)threadCount);
    }

    public String allThreadStackTraces() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(Thread.getAllStackTraces()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Thread thread = (Thread)x0$1._1();
            Object[] stackTrace = (StackTraceElement[])x0$1._2();
            String string = new java.lang.StringBuilder(2).append(thread.getName()).append("\n\t").append(Predef$.MODULE$.wrapRefArray(stackTrace).toList().map((Function1 & Serializable)x$25 -> x$25.toString()).mkString("\n\t")).toString();
            return string;
        })).mkString("\n");
    }

    public LogManager createLogManager(scala.collection.Seq<File> logDirs, LogConfig defaultConfig, ConfigRepository configRepository, CleanerConfig cleanerConfig, MockTime time, ApiVersion interBrokerProtocolVersion) {
        scala.collection.Seq x$10 = (scala.collection.Seq)logDirs.map((Function1 & Serializable)x$26 -> x$26.getAbsoluteFile());
        ArraySeq.ofRef x$11 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        MockScheduler x$21 = time.scheduler();
        BrokerTopicStats x$23 = new BrokerTopicStats();
        LogDirFailureChannel x$24 = new LogDirFailureChannel(logDirs.size());
        return new LogManager(x$10, (scala.collection.Seq)x$11, configRepository, defaultConfig, cleanerConfig, 4, 1000L, 10000L, 10000L, 1000L, 3600000, interBrokerProtocolVersion, (Scheduler)x$21, x$23, x$24, (Time)time, true);
    }

    public scala.collection.Seq<File> createLogManager$default$1() {
        return (scala.collection.Seq)Seq$.MODULE$.empty();
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public ConfigRepository createLogManager$default$3() {
        return new MockConfigRepository();
    }

    public CleanerConfig createLogManager$default$4() {
        String string;
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        return new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9);
    }

    public MockTime createLogManager$default$5() {
        return new MockTime();
    }

    public ApiVersion createLogManager$default$6() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    public TestUtils.MockAlterIsrManager createAlterIsrManager() {
        return new TestUtils.MockAlterIsrManager();
    }

    public TestUtils.MockIsrChangeListener createIsrChangeListener() {
        return new TestUtils.MockIsrChangeListener();
    }

    public void produceMessages(scala.collection.Seq<KafkaServer> servers, scala.collection.Seq<ProducerRecord<byte[], byte[]>> records, int acks) {
        try (KafkaProducer producer = this.createProducer(this.getBrokerListStrFromServers(servers, SecurityProtocol.PLAINTEXT), acks, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer(), false);){
            ((scala.collection.Seq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$27 -> (RecordMetadata)x$27.get());
        }
        scala.collection.Seq topics = (scala.collection.Seq)((SeqOps)records.map((Function1 & Serializable)x$28 -> x$28.topic())).distinct();
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$produceMessages$4(records, topics);
            Object var7_7 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            return;
        }
    }

    public scala.collection.Seq<String> generateAndProduceMessages(scala.collection.Seq<KafkaServer> servers, String topic, int numMessages, int acks) {
        IndexedSeq values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable)x -> TestUtils$.$anonfun$generateAndProduceMessages$1(BoxesRunTime.unboxToInt((Object)x)));
        IntegerSerializer intSerializer = new IntegerSerializer();
        IndexedSeq records = (IndexedSeq)((IndexedSeqOps)values.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String v = (String)x0$1._1();
            int i = x0$1._2$mcI$sp();
            ProducerRecord producerRecord = new ProducerRecord(topic, (Object)intSerializer.serialize(topic, Predef$.MODULE$.int2Integer(i)), (Object)v.getBytes());
            return producerRecord;
        });
        this.produceMessages(servers, (scala.collection.Seq<ProducerRecord<byte[], byte[]>>)records, acks);
        return values;
    }

    public int generateAndProduceMessages$default$4() {
        return -1;
    }

    public void produceMessage(scala.collection.Seq<KafkaServer> servers, String topic, String message, Long timestamp, int deliveryTimeoutMs, int requestTimeoutMs) {
        ByteArraySerializer byteArraySerializer;
        ByteArraySerializer byteArraySerializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = this.getBrokerListStrFromServers(servers, SecurityProtocol.PLAINTEXT);
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 16384;
        String string2 = string = "none";
        string = null;
        String x$10 = string2;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$11 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$12 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$13 = none$4;
        ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
        byteArraySerializer2 = null;
        ByteArraySerializer x$14 = byteArraySerializer3;
        ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
        byteArraySerializer = null;
        ByteArraySerializer x$15 = byteArraySerializer4;
        boolean bl = false;
        try (KafkaProducer producer = this.createProducer(x$1, n, l, l2, n2, deliveryTimeoutMs, n3, n4, x$10, requestTimeoutMs, x$11, (Option<File>)x$12, (Option<Properties>)x$13, (Serializer)x$14, (Serializer)x$15, bl);){
            producer.send(new ProducerRecord(topic, null, timestamp, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
    }

    public int produceMessages$default$3() {
        return -1;
    }

    public Long produceMessage$default$4() {
        return null;
    }

    public int produceMessage$default$5() {
        return 30000;
    }

    public int produceMessage$default$6() {
        return 20000;
    }

    public void verifyTopicDeletion(KafkaZkClient zkClient, String topic, int numPartitions, scala.collection.Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)x$29 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$29)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$verifyTopicDeletion$2(zkClient, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even after a replica is restarted"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$verifyTopicDeletion$4(zkClient, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topics/%s path is deleted"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic, topic})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$8(server, tp)))))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"Replica manager's should have deleted all of this topic's partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        Assertions.assertTrue((boolean)servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$11(server, tp))))), (String)"Replica logs not deleted after delete topic is complete");
        long l7 = 15000L;
        long l8 = 100L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$14(server, tp)))))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + l7) {
                Assertions.fail((String)"Cleaner offset for deleted partition should have been removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l7), l8));
        }
        long l9 = 15000L;
        long l10 = 100L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$19(topicPartitions$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + l9) {
                Assertions.fail((String)"Failed to soft-delete the data to a delete directory");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l9), l10));
        }
        long l11 = 15000L;
        long l12 = 100L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$24(topicPartitions$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + l11) {
                Assertions.fail((String)"Failed to hard-delete the delete directory");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l11), l12));
        }
    }

    public void causeLogDirFailure(TestUtils.LogDirFailureType failureType, KafkaServer leaderServer, TopicPartition partition) {
        File logDir = leaderServer.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
        logDir.createNewFile();
        Assertions.assertTrue((boolean)logDir.isFile());
        TestUtils.LogDirFailureType logDirFailureType = failureType;
        TestUtils$Roll$ testUtils$Roll$ = TestUtils$Roll$.MODULE$;
        if (logDirFailureType != null && logDirFailureType.equals(testUtils$Roll$)) {
            Assertions.assertThrows(KafkaStorageException.class, () -> {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
            });
        } else {
            TestUtils.LogDirFailureType logDirFailureType2 = failureType;
            TestUtils$Checkpoint$ testUtils$Checkpoint$ = TestUtils$Checkpoint$.MODULE$;
            if (logDirFailureType2 != null && logDirFailureType2.equals(testUtils$Checkpoint$)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$causeLogDirFailure$3(leaderServer, logDir)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected log directory offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        Assertions.assertTrue((boolean)leaderServer.replicaManager().localLog(partition).isEmpty());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        new Implicits.PropertiesOps(copy).$plus$plus$eq(props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias, String certCn, String tlsProtocol) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0 & Serializable)() -> {
            throw new Exception("SSL enabled but no trustStoreFile provided");
        });
        java.util.Map sslConfigs = new TestSslUtils.SslConfigsBuilder(mode).useClientCert(clientCert).createNewTrustStore(trustStore).certAlias(certAlias).cn(certCn).tlsProtocol(tlsProtocol).build();
        Properties sslProps = new Properties();
        sslConfigs.forEach((k, v) -> sslProps.put(k, v));
        return sslProps;
    }

    public String sslConfigs$default$5() {
        return this.SslCertificateCn();
    }

    public String sslConfigs$default$6() {
        return TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS;
    }

    public X509TrustManager trustAllCerts() {
        return new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
    }

    public void waitAndVerifyAcls(Set<AccessControlEntry> expected, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitAndVerifyAcls$1(authorizer, filter, expected)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$waitAndVerifyAcls$3(expected, newLine, authorizer, filter));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public AccessControlEntryFilter waitAndVerifyAcls$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$isAclSecure$1(acl);
            Object var5_3 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        switch (acl.getPerms()) {
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string2 = "world";
                    if (string != null && string.equals(string2)) {
                        return true;
                    }
                }
                return false;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string3 = "sasl";
                return string != null && string.equals(string3);
            }
        }
        return false;
    }

    public boolean isAclUnsecure(ACL acl) {
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TestUtils$.$anonfun$isAclUnsecure$1(acl);
            Object var3_2 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        switch (acl.getPerms()) {
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                return string != null && string.equals(string2);
            }
        }
        return false;
    }

    private scala.collection.Seq<String> secureZkPaths(KafkaZkClient zkClient) {
        return (scala.collection.Seq)((scala.collection.Seq)ZkData$.MODULE$.SecureRootPaths().$plus$plus((IterableOnce)ZkData$.MODULE$.SensitiveRootPaths())).flatMap((Function1 & Serializable)path -> TestUtils$.subPaths$1(path, zkClient));
    }

    public void verifySecureZkAcls(KafkaZkClient zkClient, int usersWithAccess) {
        this.secureZkPaths(zkClient).foreach((Function1 & Serializable)path -> {
            TestUtils$.$anonfun$verifySecureZkAcls$1(zkClient, usersWithAccess, path);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyUnsecureZkAcls(KafkaZkClient zkClient) {
        this.secureZkPaths(zkClient).foreach((Function1 & Serializable)path -> {
            TestUtils$.$anonfun$verifyUnsecureZkAcls$1(zkClient, path);
            return BoxedUnit.UNIT;
        });
    }

    public void assertConcurrent(String message, scala.collection.Seq<Function0<Object>> functions, int timeoutMs) {
        ExecutorService threadPool = Executors.newFixedThreadPool(functions.size());
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            try {
                java.util.List runnables = CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)functions.map((Function1 & Serializable)function -> new Callable<BoxedUnit>(function){
                    private final Function0 function$1;

                    public void call() {
                        this.function$1.apply();
                    }
                    {
                        this.function$1 = function$1;
                    }
                })).asJava();
                CollectionConverters$.MODULE$.ListHasAsScala(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala().foreach((Function1 & Serializable)future -> {
                    if (future.isCancelled()) {
                        TestUtils$.failWithTimeout$1(message, timeoutMs);
                        return BoxedUnit.UNIT;
                    }
                    try {
                        return future.get();
                    }
                    catch (Exception e) {
                        return exceptions.$plus$eq((Object)e);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                TestUtils$.failWithTimeout$1(message, timeoutMs);
            }
            catch (Throwable e) {
                exceptions.$plus$eq((Object)e);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assertions.assertTrue((boolean)exceptions.isEmpty(), (String)new java.lang.StringBuilder(26).append(message).append(" failed with exception(s) ").append(exceptions).toString());
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(scala.collection.Seq<KafkaServer> servers, String topic, int numMessages, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        scala.collection.Seq<ConsumerRecord<K, V>> seq;
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        String string;
        String x$1 = this.getBrokerListStrFromServers(servers, securityProtocol);
        String string2 = string = "earliest";
        string = null;
        String x$5 = string2;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$2;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        try (KafkaConsumer<K, V> consumer = this.createConsumer(x$1, groupId, x$5, bl, bl2, n, securityProtocol, trustStoreFile, (Option<Properties>)x$9, (Deserializer<K>)x$10, (Deserializer<V>)x$11);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords((Consumer<K, V>)consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V> String consumeTopicRecords$default$4() {
        return "group";
    }

    public <K, V> SecurityProtocol consumeTopicRecords$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> consumeTopicRecords$default$6() {
        return None$.MODULE$;
    }

    public <K, V> long consumeTopicRecords$default$7() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> pollUntilAtLeastNumRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        ArrayBuffer records = new ArrayBuffer();
        long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.pollAction$1(consumer.poll(java.time.Duration.ofMillis(100L)), records, numRecords)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$pollUntilAtLeastNumRecords$2(records, numRecords));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pollRecordsUntilTrue_waitUntilTrue_pause));
        }
        return records;
    }

    public <K, V> long pollUntilAtLeastNumRecords$default$3() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        scala.collection.Seq<ConsumerRecord<K, V>> records = this.pollUntilAtLeastNumRecords(consumer, numRecords, waitTimeMs);
        Assertions.assertEquals((int)numRecords, (int)records.size(), (String)"Consumed more records than expected");
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> consumeRecordsFor(KafkaConsumer<K, V> consumer, long duration) {
        long startTime = System.currentTimeMillis();
        ArrayBuffer records = new ArrayBuffer();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$consumeRecordsFor$1(records, consumer, startTime, duration)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$consumeRecordsFor$2(duration));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        return records;
    }

    public <K, V> long consumeRecordsFor$default$2() {
        return 15000L;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, scala.collection.Seq<KafkaServer> servers, int batchSize, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs, int maxInFlight) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, SecurityProtocol.PLAINTEXT));
        props.put("acks", "all");
        props.put("batch.size", Integer.toString(batchSize));
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", Long.toString(transactionTimeoutMs));
        props.put("max.block.ms", Long.toString(maxBlockMs));
        props.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        props.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        props.put("max.in.flight.requests.per.connection", Integer.toString(maxInFlight));
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public int createTransactionalProducer$default$3() {
        return 16384;
    }

    public long createTransactionalProducer$default$4() {
        return 60000L;
    }

    public long createTransactionalProducer$default$5() {
        return 60000L;
    }

    public int createTransactionalProducer$default$6() {
        return 120000;
    }

    public int createTransactionalProducer$default$7() {
        return 30000;
    }

    public int createTransactionalProducer$default$8() {
        return 5;
    }

    public void seedTopicWithNumberedRecords(String topic, int numRecords, scala.collection.Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, SecurityProtocol.PLAINTEXT));
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(topic, (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(StandardCharsets.UTF_8))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = CollectionConverters$.MODULE$.IterableHasAsScala(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala().headOption();
        if (option instanceof Some) {
            Header header = (Header)((Some)option).value();
            byte[] asString_bytes = this.kafka$utils$TestUtils$$committedValue();
            Object var4_4 = null;
            byte[] asString_bytes2 = header.value();
            Object var5_5 = null;
            byte[] asString_bytes3 = header.value();
            Object var6_6 = null;
            Assertions.assertEquals((Object)new String(asString_bytes, StandardCharsets.UTF_8), (Object)new String(asString_bytes2, StandardCharsets.UTF_8), (String)new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(40).append("Got ").append(new String(asString_bytes3, StandardCharsets.UTF_8)).append(" but expected the value to indicate ").toString()).append("committed status.").toString());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"expected the record header to include an expected transaction status, but received nothing.");
        } else {
            throw new MatchError((Object)option);
        }
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        byte[] asString_bytes = (byte[])record.value();
        return new String(asString_bytes, StandardCharsets.UTF_8);
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                if (this.willBeCommitted$1) {
                    return TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue();
                }
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, partition, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, partition, key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        consumer.assignment().forEach(topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        scala.collection.mutable.Map committed = (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(consumer.committed(consumer.assignment())).asScala().filter((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$resetToCommittedPositions$1(x$32)))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        });
        consumer.assignment().forEach(topicPartition -> {
            if (committed.contains(topicPartition)) {
                consumer.seek(topicPartition, BoxesRunTime.unboxToLong((Object)committed.apply(topicPartition)));
                return;
            }
            consumer.seekToBeginning(Collections.singletonList(topicPartition));
        });
    }

    public AlterConfigsResult incrementalAlterConfigs(scala.collection.Seq<KafkaServer> servers, Admin adminClient, Properties props, boolean perBrokerConfig, AlterConfigOp.OpType opType) {
        Collection configEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(k, v), opType);
            return alterConfigOp;
        })).toList()).asJavaCollection();
        java.util.Map configs = perBrokerConfig ? CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)servers.map((Function1 & Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(server.config().brokerId()));
            return new Tuple2((Object)resource, (Object)configEntries);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava() : CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)configEntries)}))).asJava();
        return adminClient.incrementalAlterConfigs(configs);
    }

    public AlterConfigOp.OpType incrementalAlterConfigs$default$5() {
        return AlterConfigOp.OpType.SET;
    }

    public AlterClientQuotasResult alterClientQuotas(Admin adminClient, Map<ClientQuotaEntity, Map<String, Option<Object>>> request) {
        Collection entries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            Map alter = (Map)x0$1._2();
            Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$2._1();
                Option value = (Option)x0$2._2();
                ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> TestUtils$.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).getOrElse((Function0 & Serializable)() -> null));
                return op;
            })).asJavaCollection();
            ClientQuotaAlteration clientQuotaAlteration = new ClientQuotaAlteration(entity, ops);
            return clientQuotaAlteration;
        })).asJavaCollection();
        return adminClient.alterClientQuotas(entries);
    }

    public void assertLeader(Admin client, TopicPartition topicPartition, int expectedLeader) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)expectedLeader)));
    }

    public void assertNoLeader(Admin client, TopicPartition topicPartition) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
    }

    public void waitForLeaderToBecome(Admin client, TopicPartition topicPartition, Option<Object> leader) {
        String topic = topicPartition.topic();
        int partition = topicPartition.partition();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForLeaderToBecome$1(client, topic, partition, leader)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for leader metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public void waitForBrokersOutOfIsr(Admin client, Set<TopicPartition> partition, Set<Object> brokerIds) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersOutOfIsr$1(client, partition, brokerIds)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersOutOfIsr$6(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public void waitForBrokersInIsr(Admin client, TopicPartition partition, Set<Object> brokerIds) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersInIsr$1(client, partition, brokerIds)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersInIsr$5(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public void waitForReplicasAssigned(Admin client, TopicPartition partition, scala.collection.Seq<Object> brokerIds) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForReplicasAssigned$1(client, partition, brokerIds)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForReplicasAssigned$5(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return out.toString();
    }

    public String grabConsoleError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withErr((OutputStream)err, f);
        }
        finally {
            Console$.MODULE$.err().flush();
        }
        return err.toString();
    }

    public Tuple2<String, String> grabConsoleOutputAndError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> Console$.MODULE$.withErr((OutputStream)err, f));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)out.toString(), (Object)err.toString());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz, Option<String> expectedErrorMessage) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause();
        Assertions.assertTrue((boolean)clazz.isInstance(cause), (String)new java.lang.StringBuilder(41).append("Expected an exception of type ").append(clazz.getName()).append("; got type ").append(cause.getClass().getName()).toString());
        expectedErrorMessage.foreach((Function1 & Serializable)message -> {
            TestUtils$.$anonfun$assertFutureExceptionTypeEquals$2(cause, message);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> assertFutureExceptionTypeEquals$default$3() {
        return None$.MODULE$;
    }

    public long totalMetricValue(KafkaServer server, String metricName) {
        return this.totalMetricValue(server.metrics(), metricName);
    }

    public long totalMetricValue(Metrics metrics, String metricName) {
        java.util.Map allMetrics = metrics.metrics();
        return (long)BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(allMetrics.values()).asScala().filter((Function1 & Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$totalMetricValue$1(metricName, x$44)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(total, metric) -> BoxesRunTime.boxToDouble((double)TestUtils$.$anonfun$totalMetricValue$2(BoxesRunTime.unboxToDouble((Object)total), metric))));
    }

    public long meterCount(String metricName) {
        return ((Meter)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$meterCount$1(metricName, x0$1)))).values().headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new java.lang.StringBuilder(22).append("Unable to find metric ").append(metricName).toString()))).count();
    }

    public void clearYammerMetrics() {
        CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().foreach((Function1 & Serializable)metricName -> {
            TestUtils$.$anonfun$clearYammerMetrics$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    public String stringifyTopicPartitions(Set<TopicPartition> partitions) {
        return Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)partitions.map((Function1 & Serializable)tp -> CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))}))).asJava())).asJava())}))).asJava());
    }

    public <R extends AutoCloseable, A> A resource(R resource, Function1<R, A> func) {
        Object object;
        try {
            object = func.apply(resource);
        }
        finally {
            resource.close();
        }
        return (A)object;
    }

    public void setReplicationThrottleForPartitions(Admin admin, scala.collection.Seq<Object> brokerIds, Set<TopicPartition> partitions, int throttleBytes) {
        this.throttleAllBrokersReplication(admin, brokerIds, throttleBytes);
        this.assignThrottledPartitionReplicas(admin, (Map<TopicPartition, scala.collection.Seq<Object>>)((IterableOnceOps)partitions.map((Function1 & Serializable)x$45 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$45), (Object)brokerIds))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void removeReplicationThrottleForPartitions(Admin admin, scala.collection.Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.removePartitionReplicaThrottles(admin, partitions);
        this.throttleAllBrokersReplication(admin, brokerIds, Integer.MAX_VALUE);
    }

    public void throttleAllBrokersReplication(Admin adminClient, scala.collection.Seq<Object> brokerIds, int throttleBytes) {
        Collection throttleConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), Integer.toString(throttleBytes)), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), Integer.toString(throttleBytes)), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)brokerIds.map((Function1 & Serializable)brokerId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(BoxesRunTime.unboxToInt((Object)brokerId)))), (Object)throttleConfigs))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()).all().get();
    }

    public void resetBrokersThrottle(Admin adminClient, scala.collection.Seq<Object> brokerIds) {
        this.throttleAllBrokersReplication(adminClient, brokerIds, Integer.MAX_VALUE);
    }

    public void assignThrottledPartitionReplicas(Admin adminClient, Map<TopicPartition, scala.collection.Seq<Object>> allReplicasByPartition) {
        scala.collection.immutable.Map throttles = (scala.collection.immutable.Map)allReplicasByPartition.groupBy((Function1 & Serializable)x$46 -> ((TopicPartition)x$46._1()).topic()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            Map replicasByPartition = (Map)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), MODULE$.formatReplicaThrottles((Map<TopicPartition, scala.collection.Seq<Object>>)replicasByPartition)), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), MODULE$.formatReplicaThrottles((Map<TopicPartition, scala.collection.Seq<Object>>)replicasByPartition)), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection());
            return tuple2;
        });
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)throttles).asJava()).all().get();
    }

    public void removePartitionReplicaThrottles(Admin adminClient, Set<TopicPartition> partitions) {
        scala.collection.immutable.Map throttles = ((IterableOnceOps)partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, tp.topic())), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)throttles).asJava()).all().get();
    }

    public String formatReplicaThrottles(Map<TopicPartition, scala.collection.Seq<Object>> moves) {
        return ((IterableOnceOps)moves.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            scala.collection.Seq seq = (scala.collection.Seq)((scala.collection.Seq)x0$1._2()).map((Function1 & Serializable)replicaId -> TestUtils$.$anonfun$formatReplicaThrottles$2(tp, BoxesRunTime.unboxToInt((Object)replicaId)));
            return seq;
        })).mkString(",");
    }

    public void waitForAllReassignmentsToComplete(Admin adminClient, long pause) {
        long l = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForAllReassignmentsToComplete$1(adminClient)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"There still are ongoing reassignments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pause));
        }
    }

    public long waitForAllReassignmentsToComplete$default$2() {
        return 100L;
    }

    public void addAndVerifyAcls(KafkaServer server, Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizer = (Authorizer)server.dataPlaneRequestProcessor().authorizer().get();
        Set aclBindings = (Set)acls.map((Function1 & Serializable)acl -> new AclBinding(resource, acl));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)aclBindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$47 -> (AclCreateResult)x$47.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            TestUtils$.$anonfun$addAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        this.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(aclFilter)).asScala().map((Function1 & Serializable)x$48 -> x$48.entry())).toSet().$plus$plus(acls)), authorizer, resource, AccessControlEntryFilter.ANY);
    }

    public void removeAndVerifyAcls(KafkaServer server, Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizer = (Authorizer)server.dataPlaneRequestProcessor().authorizer().get();
        Set aclBindingFilters = (Set)acls.map((Function1 & Serializable)acl -> new AclBindingFilter(resource.toFilter(), acl.toFilter()));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.deleteAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)aclBindingFilters.toList()).asJava())).asScala().map((Function1 & Serializable)x$49 -> (AclDeleteResult)x$49.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            TestUtils$.$anonfun$removeAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        this.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(aclFilter)).asScala().map((Function1 & Serializable)x$50 -> x$50.entry())).toSet().$minus$minus(acls)), authorizer, resource, AccessControlEntryFilter.ANY);
    }

    public RequestChannel.Request buildRequestWithEnvelope(AbstractRequest request, KafkaPrincipalSerde principalSerde, RequestChannel.Metrics requestChannelMetrics, long startTimeNanos, boolean fromPrivilegedListener, boolean shouldSpyRequestContext, Option<RequestChannel.Request> envelope) {
        String clientId = "id";
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        RequestHeader requestHeader = new RequestHeader(request.apiKey(), request.version(), clientId, 0);
        ByteBuffer requestBuffer = request.serializeWithHeader(requestHeader);
        RequestHeader envelopeHeader = new RequestHeader(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion(), clientId, 0);
        ByteBuffer envelopeBuffer = new EnvelopeRequest.Builder(requestBuffer, principalSerde.serialize(KafkaPrincipal.ANONYMOUS), InetAddress.getLocalHost().getAddress()).build().serializeWithHeader(envelopeHeader);
        RequestHeader.parse((ByteBuffer)envelopeBuffer);
        RequestContext requestContext = new RequestContext(envelopeHeader, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, fromPrivilegedListener, Optional.of(principalSerde));
        if (shouldSpyRequestContext) {
            requestContext = (RequestContext)Mockito.spy((Object)requestContext);
        }
        return new RequestChannel.Request(1, requestContext, startTimeNanos, MemoryPool.NONE, envelopeBuffer, requestChannelMetrics, envelope);
    }

    public boolean buildRequestWithEnvelope$default$5() {
        return true;
    }

    public boolean buildRequestWithEnvelope$default$6() {
        return false;
    }

    public Option<RequestChannel.Request> buildRequestWithEnvelope$default$7() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(String zkConnect$1, boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int logDirCount$1, boolean enableToken$1, int numPartitions$1, short defaultReplicationFactor$1, int node) {
        int x$5 = MODULE$.RandomPort();
        Option x$13 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        int n = MODULE$.RandomPort();
        int n2 = MODULE$.RandomPort();
        int n3 = MODULE$.RandomPort();
        return MODULE$.createBrokerConfig(node, zkConnect$1, enableControlledShutdown$1, enableDeleteTopic$1, x$5, (Option<SecurityProtocol>)interBrokerSecurityProtocol$1, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProperties$1, enablePlaintext$1, enableSaslPlaintext$1, n, enableSsl$1, n2, enableSaslSsl$1, n3, (Option<String>)x$13, logDirCount$1, enableToken$1, numPartitions$1, defaultReplicationFactor$1);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerListStrFromServers$2(SecurityProtocol protocol$1, EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        return !(securityProtocol != null ? !securityProtocol.equals(protocol$1) : protocol$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$3) {
        ListenerName listenerName = x$3.listenerName();
        return !(listenerName != null ? !listenerName.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$2, SecurityProtocol x$4) {
        SecurityProtocol securityProtocol = x$4;
        return !(securityProtocol != null ? !securityProtocol.equals(protocol$2) : protocol$2 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$4))));
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfig$4(int i) {
        if (i % 2 == 0) {
            return TestUtils.tempDirectory(null, null).getAbsolutePath();
        }
        return MODULE$.tempRelativeDir("data");
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$6(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        SecurityProtocol protocol = (SecurityProtocol)x0$2._1();
        boolean bl = MODULE$.usesSslTransportLayer(protocol);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$7(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        SecurityProtocol protocol = (SecurityProtocol)x0$3._1();
        boolean bl = MODULE$.usesSaslAuthentication(protocol);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$1(AdminZkClient adminZkClient$1, String topic$1, int numPartitions$2, int replicationFactor$1, Properties topicConfig$1) {
        boolean hasSessionExpirationException = false;
        try {
            adminZkClient$1.createTopic(topic$1, numPartitions$2, replicationFactor$1, topicConfig$1, adminZkClient$1.createTopic$default$5(), adminZkClient$1.createTopic$default$6());
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            hasSessionExpirationException = true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return !hasSessionExpirationException;
    }

    public static final /* synthetic */ String $anonfun$createTopic$2(String topic$1) {
        return new java.lang.StringBuilder(19).append("Can't create topic ").append(topic$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$6(AdminZkClient adminZkClient$2, String topic$2, Properties topicConfig$2, Map partitionReplicaAssignment$1) {
        boolean hasSessionExpirationException = false;
        try {
            adminZkClient$2.createTopicWithAssignment(topic$2, topicConfig$2, partitionReplicaAssignment$1, adminZkClient$2.createTopicWithAssignment$default$4(), adminZkClient$2.createTopicWithAssignment$default$5());
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            hasSessionExpirationException = true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return !hasSessionExpirationException;
    }

    public static final /* synthetic */ String $anonfun$createTopic$7(String topic$2) {
        return new java.lang.StringBuilder(19).append("Can't create topic ").append(topic$2).toString();
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$createBrokersInZk$1(int x$8) {
        return new BrokerMetadata(x$8, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ ListBuffer $anonfun$getMsgStrings$1(ListBuffer buffer$2, int i) {
        return (ListBuffer)buffer$2.$plus$eq((Object)new java.lang.StringBuilder(3).append("msg").append(i).toString());
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$2(TopicPartition topicPartition$1, Option oldLeaderOpt$1, Option newLeaderOpt$1) {
        return new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(76).append("Waiting for leader to be elected or changed for partition ").append(topicPartition$1).append(", old leader is ").append(oldLeaderOpt$1).append(", ").toString()).append(new java.lang.StringBuilder(14).append("new leader is ").append(newLeaderOpt$1).toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$3(int l$1, TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(46).append("Expected new leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$1, int oldLeader$1, int l$1) {
        return new java.lang.StringBuilder(42).append("Leader for partition ").append(topicPartition$1).append(" is changed from ").append(oldLeader$1).append(" to ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$5(int l$1, TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(33).append("Leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$1, int l$1) {
        return new java.lang.StringBuilder(33).append("Current leader for partition ").append(topicPartition$1).append(" is ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$1) {
        return new java.lang.StringBuilder(40).append("Leader for partition ").append(topicPartition$1).append(" is not elected yet").toString();
    }

    public static final /* synthetic */ String $anonfun$retry$1(LongRef wait$1) {
        return new java.lang.StringBuilder(49).append("Attempt failed, sleeping for ").append(wait$1.elem).append(", and then retrying.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$pollUntilTrue$1(Consumer consumer$1, Function0 action$1) {
        consumer$1.poll(java.time.Duration.ofMillis(100L));
        return action$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$pollRecordsUntilTrue$1(Consumer consumer$2, Function1 action$2) {
        ConsumerRecords records = consumer$2.poll(java.time.Duration.ofMillis(100L));
        return BoxesRunTime.unboxToBoolean((Object)action$2.apply((Object)records));
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForRecords$1(ConsumerRecords records) {
        return !records.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForRecords$2() {
        return "Expected records";
    }

    public static final /* synthetic */ boolean $anonfun$awaitValue$1(ObjectRef value$1, Function0 func$1) {
        value$1.elem = (Option)func$1.apply();
        return ((Option)value$1.elem).isDefined();
    }

    public static final /* synthetic */ Option $anonfun$tryUntilNoAssertionError$1(Function0 assertions$1) {
        try {
            assertions$1.apply$mcV$sp();
            return None$.MODULE$;
        }
        catch (AssertionError ae) {
            return new Some((Object)ae);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$12) {
        return x$12.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$findLeaderEpoch$1(int brokerId$1, KafkaServer x$13) {
        return x$13.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$findFollowerId$1(TopicPartition topicPartition$3, KafkaServer server) {
        boolean bl;
        Option option = server.replicaManager().onlinePartition(topicPartition$3);
        if (option instanceof Some) {
            bl = !((Partition)((Some)option).value()).leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$findFollowerId$2(KafkaServer x$15) {
        return x$15.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaServer x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$3(Set expectedBrokerIds$1, KafkaServer server) {
        Set set = expectedBrokerIds$1;
        Set set2 = ((IterableOnceOps)server.dataPlaneRequestProcessor().metadataCache().getAliveBrokers().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$waitUntilBrokerMetadataIsPropagated$5() {
        return "Timed out waiting for broker metadata to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllPartitionsMetadata$2(String topic$4, int expectedNumPartitions$1, KafkaServer server) {
        Option option = server.metadataCache().numPartitions(topic$4);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)expectedNumPartitions$1));
        return option != null && option.equals(some);
    }

    public static final /* synthetic */ String $anonfun$waitForAllPartitionsMetadata$3(String topic$4) {
        return new java.lang.StringBuilder(47).append("Topic [").append(topic$4).append("] metadata not propagated after 60000 ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionMetadata$2(String topic$5, int partition$1, KafkaServer server) {
        boolean bl;
        Option option = server.metadataCache().getPartitionInfo(topic$5, partition$1);
        if (option instanceof Some) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((Some)option).value();
            bl = Request$.MODULE$.isValidBrokerId(partitionState.leader());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$waitUntilControllerElected$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$2(Partition x$19) {
        return x$19.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$1(int oldLeader$2, TopicPartition tp$1, KafkaServer server) {
        return server.config().brokerId() != oldLeader$2 && server.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$2(x$19)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$3(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    private static final Option newLeaderExists$1(scala.collection.Seq servers$4, int oldLeader$2, TopicPartition tp$1) {
        return servers$4.find((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$1(oldLeader$2, tp$1, server))).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$3(x$20)));
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$4(scala.collection.Seq servers$4, int oldLeader$2, TopicPartition tp$1) {
        return TestUtils$.newLeaderExists$1(servers$4, oldLeader$2, tp$1).isDefined();
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$5(TopicPartition tp$1, long timeout$3) {
        return new java.lang.StringBuilder(54).append("Did not observe leader change for partition ").append(tp$1).append(" after ").append(timeout$3).append(" ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$2(Partition x$21) {
        return x$21.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$1(TopicPartition tp$2, KafkaServer server) {
        return server.replicaManager().onlinePartition(tp$2).exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$2(x$21)));
    }

    public static final /* synthetic */ int $anonfun$waitUntilLeaderIsKnown$3(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    private static final Option leaderIfExists$1(scala.collection.Seq servers$5, TopicPartition tp$2) {
        return servers$5.find((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$1(tp$2, server))).map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(x$22)));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$4(scala.collection.Seq servers$5, TopicPartition tp$2) {
        return TestUtils$.leaderIfExists$1(servers$5, tp$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsKnown$5(TopicPartition tp$2, long timeout$4) {
        return new java.lang.StringBuilder(41).append("Partition ").append(tp$2).append(" leaders not made yet after ").append(timeout$4).append(" ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$1(KafkaZkClient zkClient$4, TopicPartition topicPartition$4, scala.collection.Seq assignedReplicas$1) {
        return ((SeqOps)zkClient$4.getInSyncReplicasForPartition(topicPartition$4).get()).size() == assignedReplicas$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$3(ObjectRef leader$3, KafkaZkClient zkClient$4, TopicPartition topicPartition$4) {
        leader$3.elem = zkClient$4.getLeaderForPartition(topicPartition$4);
        return ((Option)leader$3.elem).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$6(ObjectRef leader$3, KafkaServer s) {
        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)leader$3.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$5(scala.collection.Seq servers$6, ObjectRef leader$3) {
        return ((KafkaServer)((IterableOps)servers$6.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$6(leader$3, s)))).head()).replicaManager().underReplicatedPartitionCount() == 0;
    }

    public static final /* synthetic */ String $anonfun$ensureNoUnderReplicatedPartitions$7(String topic$6, int partitionToBeReassigned$1, ObjectRef leader$3) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic$6, BoxesRunTime.boxToInteger((int)partitionToBeReassigned$1), ((Option)leader$3.elem).get()}));
    }

    public static final /* synthetic */ boolean $anonfun$assertNoNonDaemonThreads$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$produceMessages$4(scala.collection.Seq records$1, scala.collection.Seq topics$1) {
        return new java.lang.StringBuilder(26).append("Sent ").append(records$1.size()).append(" messages for topics ").append(topics$1.mkString(",")).toString();
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$1(int x) {
        return new java.lang.StringBuilder(5).append("test-").append(x).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$8, int x$29) {
        return new TopicPartition(topic$8, x$29);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$2(KafkaZkClient zkClient$5, String topic$8) {
        return !zkClient$5.isTopicMarkedForDeletion(topic$8);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$4(KafkaZkClient zkClient$5, String topic$8) {
        return !zkClient$5.topicExists(topic$8);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$8(KafkaServer server$1, TopicPartition tp) {
        return server$1.replicaManager().onlinePartition(tp).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$9() {
        return "Replica manager's should have deleted all of this topic's partitions";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$11(KafkaServer server$2, TopicPartition tp) {
        LogManager qual$1 = server$2.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$16(TopicPartition tp$3, Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.contains((Object)tp$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$14(KafkaServer server$3, TopicPartition tp) {
        return ((scala.collection.Seq)server$3.getLogManager().liveLogDirs().map((Function1 & Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint"), null).read())).forall((Function1 & Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$16(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$17() {
        return "Cleaner offset for deleted partition should have been removed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$21(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, new java.lang.StringBuilder(1).append(tp.topic()).append("-").append(tp.partition()).toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$19(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$21(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$22() {
        return "Failed to soft-delete the data to a delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$27(TopicPartition tp$4, String[] partitionDirectoryName) {
        int x$4;
        WrappedString x$3;
        Object qual$2 = Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName);
        return ArrayOps$.MODULE$.startsWith$extension(qual$2, (IterableOnce)(x$3 = Predef$.MODULE$.wrapString(new java.lang.StringBuilder(1).append(tp$4.topic()).append("-").append(tp$4.partition()).toString())), x$4 = ArrayOps$.MODULE$.startsWith$default$2$extension(qual$2)) && ArrayOps$.MODULE$.endsWith$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName), (Iterable)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$26(String logDir$2, TopicPartition tp) {
        return !CollectionConverters$.MODULE$.ListHasAsScala(Arrays.asList(new String[][]{new File(logDir$2).list()})).asScala().exists((Function1 & Serializable)partitionDirectoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$27(tp, partitionDirectoryName)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$24(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$26(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$28() {
        return "Failed to hard-delete the delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$3(KafkaServer leaderServer$1, File logDir$3) {
        return !leaderServer$1.logManager().isLogDirOnline(logDir$3.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$4() {
        return "Expected log directory offline";
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyAcls$1(Authorizer authorizer$1, AclBindingFilter filter$1, Set expected$1) {
        Set set = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$1)).asScala().map((Function1 & Serializable)x$30 -> x$30.entry())).toSet();
        return !(set != null ? !set.equals(expected$1) : expected$1 != null);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyAcls$3(Set expected$1, String newLine$1, Authorizer authorizer$1, AclBindingFilter filter$1) {
        return new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(14).append("expected acls:").append(expected$1.mkString(new java.lang.StringBuilder(1).append(newLine$1).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine$1).append("\t").toString(), newLine$1)).toString()).append(new java.lang.StringBuilder(8).append("but got:").append(((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$1)).asScala().map((Function1 & Serializable)x$31 -> x$31.entry())).mkString(new java.lang.StringBuilder(1).append(newLine$1).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine$1).append("\t").toString(), newLine$1)).toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$isAclSecure$1(ACL acl$1) {
        return new java.lang.StringBuilder(4).append("ACL ").append(acl$1).toString();
    }

    public static final /* synthetic */ String $anonfun$isAclUnsecure$1(ACL acl$2) {
        return new java.lang.StringBuilder(4).append("ACL ").append(acl$2).toString();
    }

    private static final scala.collection.Seq subPaths$1(String path2, KafkaZkClient zkClient$6) {
        if (zkClient$6.pathExists(path2)) {
            return (scala.collection.Seq)((SeqOps)((IterableOps)zkClient$6.getChildren(path2).map((Function1 & Serializable)c -> new java.lang.StringBuilder(1).append(path2).append("/").append((String)c).toString())).flatMap((Function1 & Serializable)path -> TestUtils$.subPaths$1(path, zkClient$6))).$plus$colon((Object)path2);
        }
        return (scala.collection.Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ void $anonfun$verifySecureZkAcls$1(KafkaZkClient zkClient$7, int usersWithAccess$1, String path) {
        if (zkClient$7.pathExists(path)) {
            boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
            int aclCount = sensitive ? usersWithAccess$1 : usersWithAccess$1 + 1;
            scala.collection.Seq acls = zkClient$7.getAcl(path);
            Assertions.assertEquals((int)aclCount, (int)acls.size(), (String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString());
            acls.foreach((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(acl, sensitive)));
        }
    }

    public static final /* synthetic */ void $anonfun$verifyUnsecureZkAcls$1(KafkaZkClient zkClient$8, String path) {
        if (zkClient$8.pathExists(path)) {
            scala.collection.Seq acls = zkClient$8.getAcl(path);
            Assertions.assertEquals((int)1, (int)acls.size(), (String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString());
            acls.foreach((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl)));
        }
    }

    private static final void failWithTimeout$1(String message$1, int timeoutMs$2) {
        Assertions.fail((String)new java.lang.StringBuilder(66).append(message$1).append(". Timed out, the concurrent functions took more than ").append(timeoutMs$2).append(" milliseconds").toString());
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, ArrayBuffer records$2, int numRecords$1) {
        records$2.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$pollUntilAtLeastNumRecords$2(ArrayBuffer records$2, int numRecords$1) {
        return new java.lang.StringBuilder(65).append("Consumed ").append(records$2.size()).append(" records before timeout instead of the expected ").append(numRecords$1).append(" records").toString();
    }

    public static final /* synthetic */ boolean $anonfun$consumeRecordsFor$1(ArrayBuffer records$3, KafkaConsumer consumer$3, long startTime$1, long duration$1) {
        records$3.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)consumer$3.poll(java.time.Duration.ofMillis(50L))).asScala());
        return System.currentTimeMillis() - startTime$1 > duration$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecordsFor$2(long duration$1) {
        return new java.lang.StringBuilder(52).append("The timeout ").append(duration$1).append(" was greater than the maximum wait time.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$resetToCommittedPositions$1(Tuple2 x$32) {
        return x$32._2() != null;
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ boolean $anonfun$waitForLeaderToBecome$1(Admin client$1, String topic$10, int partition$3, Option leader$4) {
        boolean bl;
        try {
            TopicPartitionInfo partitionResult = (TopicPartitionInfo)((TopicDescription)((java.util.Map)client$1.describeTopics(Arrays.asList(topic$10)).all().get()).get(topic$10)).partitions().get(partition$3);
            Option option = Option$.MODULE$.apply((Object)partitionResult.leader()).map((Function1 & Serializable)x$33 -> BoxesRunTime.boxToInteger((int)x$33.id()));
            if (option != null ? !option.equals(leader$4) : leader$4 != null) {
                return false;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof ExecutionException) || !(((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException)) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$waitForLeaderToBecome$3() {
        return "Timed out waiting for leader metadata";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersOutOfIsr$1(Admin client$2, Set partition$4, Set brokerIds$1) {
        Set isr = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)partition$4.map((Function1 & Serializable)x$34 -> x$34.topic())).asJava()).all().get()).asScala().values().flatMap((Function1 & Serializable)x$35 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$35.partitions()).asScala().flatMap((Function1 & Serializable)x$36 -> CollectionConverters$.MODULE$.ListHasAsScala(x$36.isr()).asScala()))).map((Function1 & Serializable)x$37 -> BoxesRunTime.boxToInteger((int)x$37.id()))).toSet();
        return brokerIds$1.intersect((scala.collection.Set)isr).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersOutOfIsr$6(Set brokerIds$1, Set partition$4) {
        return new java.lang.StringBuilder(46).append("Expected brokers ").append(brokerIds$1).append(" to no longer in the ISR for ").append(partition$4).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersInIsr$1(Admin client$3, TopicPartition partition$5, Set brokerIds$2) {
        Set isr = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client$3.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{partition$5.topic()}))).asJava()).all().get()).asScala().values().flatMap((Function1 & Serializable)x$38 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$38.partitions()).asScala().flatMap((Function1 & Serializable)x$39 -> CollectionConverters$.MODULE$.ListHasAsScala(x$39.isr()).asScala()))).map((Function1 & Serializable)x$40 -> BoxesRunTime.boxToInteger((int)x$40.id()))).toSet();
        return brokerIds$2.subsetOf((scala.collection.Set)isr);
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersInIsr$5(Set brokerIds$2, TopicPartition partition$5) {
        return new java.lang.StringBuilder(39).append("Expected brokers ").append(brokerIds$2).append(" to be in the ISR for ").append(partition$5).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicasAssigned$1(Admin client$4, TopicPartition partition$6, scala.collection.Seq brokerIds$3) {
        Seq replicas = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client$4.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{partition$6.topic()}))).asJava()).all().get()).asScala().values().flatMap((Function1 & Serializable)x$41 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$41.partitions()).asScala().flatMap((Function1 & Serializable)x$42 -> CollectionConverters$.MODULE$.ListHasAsScala(x$42.replicas()).asScala()))).map((Function1 & Serializable)x$43 -> BoxesRunTime.boxToInteger((int)x$43.id()))).toSeq();
        scala.collection.Seq seq = brokerIds$3;
        return !(seq != null ? !seq.equals(replicas) : replicas != null);
    }

    public static final /* synthetic */ String $anonfun$waitForReplicasAssigned$5(scala.collection.Seq brokerIds$3, TopicPartition partition$6) {
        return new java.lang.StringBuilder(41).append("Expected brokers ").append(brokerIds$3).append(" to be the replicas for ").append(partition$6).toString();
    }

    public static final /* synthetic */ void $anonfun$assertFutureExceptionTypeEquals$2(Throwable cause$1, String message) {
        Assertions.assertTrue((boolean)cause$1.getMessage().contains(message), (String)new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(25).append("Received error message : ").append(cause$1.getMessage()).toString()).append(new java.lang.StringBuilder(43).append(" does not contain expected error message : ").append(message).toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$totalMetricValue$1(String metricName$1, KafkaMetric x$44) {
        String string = x$44.metricName().name();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ double $anonfun$totalMetricValue$2(double total, KafkaMetric metric) {
        return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$meterCount$1(String metricName$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((MetricName)x0$1._1()).getMBeanName().endsWith(metricName$2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$clearYammerMetrics$1(MetricName metricName) {
        KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
    }

    public static final /* synthetic */ String $anonfun$formatReplicaThrottles$2(TopicPartition tp$5, int replicaId) {
        return new java.lang.StringBuilder(1).append(tp$5.partition()).append(":").append(replicaId).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllReassignmentsToComplete$1(Admin adminClient$1) {
        return ((java.util.Map)adminClient$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForAllReassignmentsToComplete$2() {
        return "There still are ongoing reassignments";
    }

    public static final /* synthetic */ void $anonfun$addAndVerifyAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ void $anonfun$removeAndVerifyAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    private TestUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$subscribeAndWaitForRecords$1$adapted(ConsumerRecords records) {
        return BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$subscribeAndWaitForRecords$1(records));
    }

    public static final /* synthetic */ Object $anonfun$tryUntilNoAssertionError$2$adapted(Option x$10) {
        return BoxesRunTime.boxToBoolean((boolean)x$10.isEmpty());
    }

    public static final /* synthetic */ Object $anonfun$waitUntilControllerElected$2$adapted(Option x$18) {
        return BoxesRunTime.boxToBoolean((boolean)x$18.isDefined());
    }

    public static final /* synthetic */ Object $anonfun$pollUntilAtLeastNumRecords$1$adapted(ArrayBuffer records$2, int numRecords$1, ConsumerRecords polledRecords) {
        return BoxesRunTime.boxToBoolean((boolean)TestUtils$.pollAction$1(polledRecords, records$2, numRecords$1));
    }
}

