/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import javax.crypto.SecretKeyFactory;
import kafka.server.Defaults$;
import kafka.utils.CoreUtils$;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r3AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u0005]\t\u0019\u0002+Y:to>\u0014H-\u00128d_\u0012,'\u000fV3ti*\u0011\u0001\"C\u0001\u0006kRLGn\u001d\u0006\u0002\u0015\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011aB\u0001\u0011i\u0016\u001cH/\u00128d_\u0012,G)Z2pI\u0016$\u0012!\u0007\t\u0003\u001diI!aG\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\u0005)\u0016\u001cH/A\fuKN$XI\\2pI\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u00121!H\u0001\u001bi\u0016\u001cH/\u00128d_\u0012,G)Z2pI\u0016\fEnZ8sSRDWn\u001d\u0015\u0003\tu\tQC^3sS\u001aLXI\\2pI\u0016$\u0007+Y:to>\u0014H\r\u0006\u0003\u001a_Q\n\u0005\"\u0002\u0019\u0006\u0001\u0004\t\u0014aB3oG>$WM\u001d\t\u0003-IJ!aM\u0004\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJDQ!N\u0003A\u0002Y\n\u0001\u0002]1tg^|'\u000f\u001a\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005ezQ\"\u0001\u001e\u000b\u0005mZ\u0011A\u0002\u001fs_>$h(\u0003\u0002>\u001f\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tit\u0002C\u0003C\u000b\u0001\u0007a'A\u0004f]\u000e|G-\u001a3")
public class PasswordEncoderTest {
    @Test
    public void testEncodeDecode() {
        String string;
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)None$.MODULE$, Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), Defaults$.MODULE$.PasswordEncoderKeyLength(), Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assertions.assertEquals((Object)"4096", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assertions.assertEquals((Object)"128", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        try {
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            string = "PBKDF2WithHmacSHA512";
        }
        catch (Exception exception) {
            string = "PBKDF2WithHmacSHA1";
        }
        Assertions.assertEquals((Object)string, (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assertions.assertEquals((Object)"AES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        this.verifyEncodedPassword(encoder, password, encoded);
    }

    @Test
    public void testEncoderConfigChange() {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "DES/CBC/PKCS5Padding", 64, 1024);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assertions.assertEquals((Object)"1024", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assertions.assertEquals((Object)"64", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        Assertions.assertEquals((Object)"PBKDF2WithHmacSHA1", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assertions.assertEquals((Object)"DES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        PasswordEncoder decoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 2048);
        Assertions.assertEquals((Object)password, (Object)decoder.decode(encoded).value());
        try {
            new PasswordEncoder(new Password("secret-2"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 1024).decode(encoded);
            return;
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testEncodeDecodeAlgorithms() {
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DES/CBC/PKCS5Padding", 64);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DESede/CBC/PKCS5Padding", 192);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/OFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA1"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/GCM/NoPadding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA256"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA512"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
    }

    private void verifyEncodedPassword(PasswordEncoder encoder, String password, String encoded) {
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assertions.assertEquals((Object)Integer.toString(password.length()), (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()));
        Assertions.assertNotNull((Object)encoder.base64Decode((String)encodedMap.apply((Object)"salt")), (String)"Invalid salt");
        Assertions.assertNotNull((Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())), (String)"Invalid encoding parameters");
        Assertions.assertNotNull((Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp())), (String)"Invalid encoded password");
        Assertions.assertEquals((Object)password, (Object)encoder.decode(encoded).value());
    }

    private final void verifyEncodeDecode$1(Option keyFactoryAlg, String cipherAlg, int keyLength) {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), keyFactoryAlg, cipherAlg, keyLength, Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        this.verifyEncodedPassword(encoder, password, encoded);
    }
}

