/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigHelper;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q4AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\ri\u0002\u0001\u0015!\u0003/\u0011\u001dY\u0004A1A\u0005\nqBa\u0001\u0011\u0001!\u0002\u0013i\u0004bB!\u0001\u0005\u0004%IA\u0011\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\"\t\u000f1\u0003!\u0019!C\u0005\u001b\"1\u0011\u000b\u0001Q\u0001\n9CQA\u0015\u0001\u0005\u0002MCQA\u0019\u0001\u0005\u0002\rDQ!\u001b\u0001\u0005\u0002MCQA\u001c\u0001\u0005\u0002MCQ\u0001\u001d\u0001\u0005\u0002MCQA\u001d\u0001\u0005\u0002M\u0013!CW6BI6Lg.T1oC\u001e,'\u000fV3ti*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\n\u0002\u0011i\\7\t\\5f]R,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003QU\t!A_6\n\u0005):#!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u00059Q.\u001a;sS\u000e\u001cX#\u0001\u0018\u0011\u0005=BT\"\u0001\u0019\u000b\u00051\n$B\u0001\u001a4\u0003\u0019\u0019w.\\7p]*\u0011a\u0003\u000e\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:a\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012!\u0010\t\u00035yJ!aP\u000e\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005)Ao\u001c9jGV\t1\t\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006!A.\u00198h\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u0014\t\u0003E=K!\u0001U\n\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002)B\u0011!$V\u0005\u0003-n\u0011A!\u00168ji\"\u0012A\u0002\u0017\t\u00033\u0002l\u0011A\u0017\u0006\u00037r\u000b1!\u00199j\u0015\tif,A\u0004kkBLG/\u001a:\u000b\u0005}3\u0014!\u00026v]&$\u0018BA1[\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nde\u0016\fG/Z\"p]\u001aLw\rS3ma\u0016\u0014Hc\u00013hQB\u0011!%Z\u0005\u0003MN\u0011AbQ8oM&<\u0007*\u001a7qKJDQ\u0001T\u0007A\u00029CQaI\u0007A\u0002\u0015\nA\u0006^3ti\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON<\u0016\u000e\u001e5Ok2d7i\u001c8gS\u001e,(/\u0019;j_:\\U-_:)\u00059Y\u0007CA-m\u0013\ti'L\u0001\u0003UKN$\u0018!\f;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cx+\u001b;i\u000b6\u0004H/_\"p]\u001aLw-\u001e:bi&|gnS3zg\"\u0012qb[\u0001)i\u0016\u001cH\u000fR3tGJL'-Z\"p]\u001aLwm],ji\"\u001cuN\u001c4jOV\u0014\u0018\r^5p].+\u0017p\u001d\u0015\u0003!-\fA\u0005^3ti\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON<\u0016\u000e\u001e5E_\u000e,X.\u001a8uCRLwN\u001c\u0015\u0003#-\u0004")
public class ZkAdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ConfigHelper createConfigHelper(MetadataCache metadataCache, KafkaZkClient zkClient) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        return new ConfigHelper(metadataCache, KafkaConfig$.MODULE$.fromProps(props), (ConfigRepository)new ZkConfigRepository(new AdminZkClient(zkClient)));
    }

    @Test
    public void testDescribeConfigsWithNullConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        List resources = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeConfigsRequestData.DescribeConfigsResource[]{new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(null)}));
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs(resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithEmptyConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        List resources = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeConfigsRequestData.DescribeConfigsResource[]{new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id())}));
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs(resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        List resources = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeConfigsRequestData.DescribeConfigsResource[]{new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes", "segment.bytes"}))).asJava())}));
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs(resources, true, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Set resultConfigKeys = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs()).asScala().map((Function1 & Serializable)r -> r.name())).toSet();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes", "segment.bytes"})), (Object)resultConfigKeys);
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), Integer.toString(this.brokerId()))).andReturn((Object)new Properties());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        ConfigHelper configHelper = this.createConfigHelper(this.metadataCache(), this.zkClient());
        List resources = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DescribeConfigsRequestData.DescribeConfigsResource[]{new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(Integer.toString(this.brokerId())).setResourceType(ConfigResource.Type.BROKER.id())}));
        List results = configHelper.describeConfigs(resources, true, true);
        Assertions.assertEquals((int)2, (int)results.size());
        results.foreach((Function1 & Serializable)r -> {
            ZkAdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(r);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(DescribeConfigsResponseData.DescribeConfigsResult r) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)r.errorCode());
        Assertions.assertFalse((boolean)r.configs().isEmpty(), (String)"Should return configs");
        r.configs().forEach(c -> {
            Assertions.assertNotNull((Object)c.documentation(), (String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString());
            Assertions.assertNotEquals((Object)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (String)c.documentation().trim());
        });
    }

    public ZkAdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }
}

