/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;

public abstract class AbstractStoreBuilder<K, V, T extends StateStore>
implements StoreBuilder<T> {
    private Map<String, String> logConfig = new HashMap<String, String>();
    protected final String name;
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    final Time time;
    boolean enableCaching;
    boolean enableLogging = true;

    public AbstractStoreBuilder(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(time, "time cannot be null");
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    @Override
    public StoreBuilder<T> withCachingEnabled() {
        this.enableCaching = true;
        return this;
    }

    @Override
    public StoreBuilder<T> withCachingDisabled() {
        this.enableCaching = false;
        return this;
    }

    @Override
    public StoreBuilder<T> withLoggingEnabled(Map<String, String> config) {
        Objects.requireNonNull(config, "config can't be null");
        this.enableLogging = true;
        this.logConfig = config;
        return this;
    }

    @Override
    public StoreBuilder<T> withLoggingDisabled() {
        this.enableLogging = false;
        this.logConfig.clear();
        return this;
    }

    @Override
    public Map<String, String> logConfig() {
        return this.logConfig;
    }

    @Override
    public boolean loggingEnabled() {
        return this.enableLogging;
    }

    @Override
    public String name() {
        return this.name;
    }
}

