/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamTransformValues<K, V, R>
implements ProcessorSupplier<K, V> {
    private final ValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier;

    KStreamTransformValues(ValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier) {
        this.valueTransformerSupplier = valueTransformerSupplier;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamTransformValuesProcessor(this.valueTransformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.valueTransformerSupplier.stores();
    }

    public static class KStreamTransformValuesProcessor<K, V, R>
    extends AbstractProcessor<K, V> {
        private final ValueTransformerWithKey<K, V, R> valueTransformer;

        KStreamTransformValuesProcessor(ValueTransformerWithKey<K, V, R> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(context));
        }

        @Override
        public void process(K key, V value) {
            this.context.forward(key, this.valueTransformer.transform(key, value));
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

