/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.common.Constants;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="jackson")
public class JacksonUndoLogParser
implements UndoLogParser {
    public static final String NAME = "jackson";
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUndoLogParser.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return "{}".getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        try {
            byte[] bytes = MAPPER.writeValueAsBytes((Object)branchUndoLog);
            return bytes;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("json encode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        try {
            BranchUndoLog branchUndoLog = (BranchUndoLog)MAPPER.readValue(bytes, BranchUndoLog.class);
            return branchUndoLog;
        }
        catch (IOException e) {
            LOGGER.error("json decode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
    }
}

